<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Новости';
require_once ROOT.'/system/header.php';
?>
<div class="col-lg-4"></div>
<div class="col-sm-8 col-md-6 col-lg-4">
	<nav aria-label="breadcrumb">
		<ol class="breadcrumb">
			<div class="b-item">
				<li class="breadcrumb-item">
					<a href="/">На главную</a>
				</li>
				<li class="breadcrumb-item active" aria-current="page"><?=$title?></li>
			</div>
		</ol>
	</nav>
	<script>
	$(document).ready(function () {
		var alerts = $('#alerts');
		
		function getNews() {
			var response = $('#response');
			
            $.ajax({
            url: '/AJAX/news/getNews.php',
            type: 'POST',
            data: {offset: 0, limit: 10},
            dataType: 'json',
            success: function(json) {

				if (json['success'] == 1)
				{
					
					json['response'].forEach(function(news) {
						var cardHeader = '<div class="card-header" id="card-header"><p class="card-title" style="margin-bottom: 10px;"><a href="/id' + news['user_id'] + '" class="text-secondary" style="font-size: 17px;">' + news['user_name'] + ' ' + news['user_last_name'] + '</a><br><small class="text-muted"><i class="material-icons md-18" style="top: 5px!important;">schedule</i> ' + news['time'] + '</small><span class="badge badge-theme badge-pill float-right" style="margin-top: -25px; position: relative; top: 5px;">' + news['user_date_last'] + '</span></p></div>';
						var cardBody = '<div class="card-body pb-2"><p class="pb-0">' + news['message'] + '</p><a href="?hashTags" class="float-right text-secondary">#' + news['id'] + '</a></div>';
						var cardFooter = '<div class="card-footer p-2"><div class="btn-group"><a href="#like" class="btn btn-sm btn-theme-link add-like" style="border: 0!important;" data-id="' + news['id'] + '" data-type="like"><i class="material-icons md-22">favorite_border</i> <span style="position: relative; top: 0px;" id="count-like-id' + news['id'] + '">' + news['likes'] + '</span></a><a href="?comments" class="btn btn-sm btn-theme" style="border: 0!important;"><i class="material-icons md-22">chat_bubble_outline</i> <span style="position: relative; top: 0px;">0</span></a></div><span class="float-right color-theme text-small" style="position: relative; top: 4px!important; "><i class="material-icons md-22" style="top: 7px!important;">visibility</i> ' + news['views'] + '</span></div></div>';
						var cardPhoto = '';
						
						if (news['files'] != false)
						{
							news['files'].forEach(function(newsFile) {
								cardPhoto += '<div class="col-sm-12"><span href="' + newsFile['url'] + '" onclick="return false;" class="lightbox"><img src="' + newsFile['url'] + '" class="w-100" /></span></div>';
							});
						}
						
						response.append('<div class="card">' + cardHeader + ' <div class="tz-gallery"><div class="form-row">' + cardPhoto + '</div></div> ' + cardBody + ' ' + cardFooter + '</div>');
					});
				}
				else if (json['error'] == 1)
				{
					alerts.addClass("alert alert-danger").html(json['comment']);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
            	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
            },
            complete: function() {
				$('#loader').hide();
				baguetteBox.run('.tz-gallery');
			}
            });
		}
		getNews();
		
		$(document).on('click', '.add-like', function(e) {
			e.preventDefault();
			
			var data = {
				id: $(this).attr('data-id'),
				type: $(this).attr('data-type'),
			};
			
			$.ajax({
				url: '/AJAX/news/addLike.php',
				type: 'POST',
				data: data,
				dataType: 'json',
				success: function(json) {
					
					if (json['success'] == 1)
					{
						alerts.addClass("alert alert-success");
						alerts.html(json['comment']);
						
						$('#count-like-id' + data['id']).text(json['count']);
					}
					else
					{
						alerts.addClass("alert alert-danger");
						alerts.html(json['comment']);
					}
					
					setTimeout(function() {
						alerts.removeClass("alert alert-danger");
						alerts.html('');
					}, 1000);
				},
				error: function(xhr, ajaxOptions, thrownError) {
					
					if (xhr.statusText == 'Not Found')
					{
						var json = $.parseJSON(xhr.responseText);
						
						alerts.addClass("alert alert-danger");
						alerts.html(json['comment']);
					}
					else
					{
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				}
			});
		});
	});
	</script>
	
	<div class="mb-3">
		<a href="/news/new" class="btn btn-theme-active btn-block">Новая запись</a>
	</div>
	
	<div id="alerts"></div>
	
	<div class="p-5 mt-5 mb-3 w-100 d-none text-center" id="loader">
		<div class="cssload-loader">
			<div class="cssload-inner cssload-one"></div>
			<div class="cssload-inner cssload-two"></div>
			<div class="cssload-inner cssload-three"></div>
		</div>
	</div>
	
	<div id="response"></div>
</div>
<div class="col-lg-4"></div>
<?php
require_once ROOT.'/system/footer.php';
?>