<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/App.php';
$title = 'Редактировать';
require_once ROOT.'/system/header.php';
$user->access();

if(!empty($id))
{
    $album = $albums->getByID($id);
    $author = (empty($album['user_id']) ? 'Гость' : '<a href="/id'.$album['user_id'].'" class="text-success">@'.$user->infoByID($album['user_id'])['login'].'</a>');
    
    if(empty($album))
    {
        $core->redirect('/albums');
    }
}

if($album['user_id'] != $me['id'] && $me['access'] < 1)
{
	$core->redirect('/albums');
}
?>
<div class="col-sm">
</div>

<div class="col-sm-10 col-md-6 col-lg-4 col-xl-4">
    <nav aria-label="breadcrumb">
    	<ol class="breadcrumb">
    		<div class="b-item">
    			<li class="breadcrumb-item">
    				<a href="/albums">Альбомы</a>
    			</li>
    			<li class="breadcrumb-item active" aria-current="page">Редактировать</li>
    		</div>
    	</ol>
    </nav>
    
	<script type="text/javascript">
	$(document).ready(function () {
		
		$('#saveInfo').on('click', function(e) {
			e.preventDefault();
			var formData = $('#editAlbum').serialize();
			var alerts = $('#alerts');
			
			$.ajax({
			url: '/AJAX/editAlbum.php',
			type: 'POST',
			data: formData, // можно строкой, а можно, например, так: $('input[type="text"], input[type="radio"]:checked, input[type="checkbox"]:checked, select, textarea')
			dataType: 'json',
			success: function(json) {
				$('#alerts').show();
				
				if(json['error'] == 1) {
					$(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
				} else if(json['success'] == 1) {
					$(alerts).html('<div class="alert alert-success">'+json['comment']+'</div>');
				}
				setTimeout(function () {
					$(alerts).html('');
				}, 2000);
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
			}
			});
		});
	});
	</script>
	
	<noscript>
	<div class="alert alert-danger">Включите Javascript, для корректной работы сайта.</div>
	</noscript>
	
	<div id="alerts"></div>
	
	<div class="card list-group list-group-flush">
        <div class="list-group-item">Автор: <?=$author?></div>
        <div class="list-group-item">
            <form id="editAlbum" role="form">
            	<input type="hidden" name="album_id" value="<?=$album['id']?>">
            	
                <div class="form-group">
                    <label class="form-check-label text-secondary">Название альбома</label>
			        <input type="text" class="form-control" id="albumName" name="name" value="<?=$album['name']?>">
		        </div>
            </form>
		</div>
		<div class="list-group-item">
			<script type="text/javascript">
			$(document).ready(function(){
				var progressBar = $('#progressbar');
				var alerts = $('#alerts');
				var files;
				
				$('input[type=file]').on('change', function(){
				files = this.files;
				});
				
				$('#my_file').on('change', function(e){
    				e.preventDefault();
    				progressBar.show();
    				var $that = $('#uploadPhotosToAlbum');
    				
    				if(typeof files == 'undefined') return;
    				
    				var data = new FormData();
    				
    				$.each(files, function(key, value) {
    				data.append(key, value);
    				});
    				data.append('album_id', '<?=$album['id']?>');
    				
    				$.ajax({
        				url: $that.attr('action'),
        				type: $that.attr('method'),
        				contentType: false,
        				processData: false,
        				data: data,
        				dataType: 'json',
        				xhr: function() {
            				var xhr = $.ajaxSettings.xhr();
            				xhr.upload.addEventListener('progress', function(evt){
                				if(evt.lengthComputable) {
                				    var percentComplete = Math.ceil(evt.loaded / evt.total * 100);
                				    progressBar.html('<div class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: ' + percentComplete + '%"></div>');
                				}
        				    }, false);
        				    return xhr;
        				},
        				success: function(json){
        				    progressBar.hide()
        				
            				if(json['error'] == 1) {
            				    if(!isEmpty(json['comment']))
            				    {
            					    alerts.html('<div class="alert alert-danger">'+json['comment']+'</div>');
            				    }
            				} else if(json['success'] == 1) {
            				    if(!isEmpty(json['comment']))
            				    {
            					    alerts.html('<div class="alert alert-success">'+json['comment']+'</div>');
            				    }
            				}
            				setTimeout(function () {
            				    alerts.html('');
            				}, 2000);
        				},
        				error: function(xhr, ajaxOptions, thrownError) {
        					alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
        				}
    				});
				});
				
				function deletePhoto() {
                    $('.deleteButton').on('click', function(e) {
                        e.preventDefault();
                        var data = $(this).attr('data-id');
                        var element = $('#photo' + data);
                        var alerts = $('#alerts');
                        
                        $.ajax({
                            url: '/AJAX/deletePhoto.php',
                            type: 'post',
                            data: {id:data},
                            dataType: 'json',
                            success: function(json) {

                                if(json['error'] == 1) {
                                    $(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                                } else if(json['success'] == 1) {
                                    $(alerts).html('<div class="alert alert-success">'+json['comment']+'</div>');
                                    $(element).remove();
                                }
                                setTimeout(function () {
                                    $(alerts).html('');
                                }, 2000);
                            },
                            error: function(xhr, ajaxOptions, thrownError) {
                                alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                            }
                        });
                    });
                }
                deletePhoto();
			});
			</script>
			<div class="progress mb-3" id="progressbar" style="display: none;"></div>
			<div class="form_upload mb-3 w-100 text-center">
				<form action="/AJAX/uploadPhotosToAlbum.php" method="POST" id="uploadPhotosToAlbum">
					<input type="hidden" name="form_id" id="form_id" value="<?=$form_id?>">
					<input type="file" name="my_file[]" id="my_file" multiple/>
				</form>
				<span class="btn btn-theme-active">Загрузить ещё</span>
			</div>
			
            <div class="form-row">
            <?php
            $photos = $albums->photosByID($album['id'], 0, 250);

			if(!empty($photos))
			{
				
				if(count($photos) == 1)
				{
					$num = 12;
				}
				else if(count($photos) == 2 || count($photos) == 5)
				{
					$num = 6;
				}
				else if(count($photos) == 3 || count($photos) == 6 || count($photos) == 7 || count($photos) == 9)
				{
					$num = 4;
				}
				else if(count($photos) == 4 || count($photos) == 8)
				{
					$num = 3;
				}
				else if(count($photos) == 10 || count($photos) == 11 || count($photos) == 12 || count($photos) > 12)
				{
					$num = 2;
				}
				else
				{
					$num = 1;
				}
				
				foreach($photos as $photo)
				{
					?>
					<div class="col-<?=$num?> col-sm-<?=$num?> col-md-3 mb-3" id="photo<?=$photo['id']?>">
					<a href="<?=HOME?>/uploads/<?=$photo['name']?>" class="image-prev"  style="background-image: url(http://<?=$_SERVER['HTTP_HOST']?>/uploads/<?=$photo['name']?>);">
					<a href="#delete"  data-id="<?=$photo['id']?>" id="deletePhoto" class="deleteButton"><i class="material-icons" style="font-size: 20px; top: 2px!important;">clear</i></span>
					</a>
					</div>
					<?php
				}
			}
			?>
            </div>
        </div>
        <div class="card-footer text-right">
            <button type="submit" class="btn btn-theme-active" name="ok" id="saveInfo">Сохранить</button>   
        </div>
    </div>
    
</div>

<div class="col-sm">
</div>

<?php
require_once ROOT.'/system/footer.php';
?>