<?php
require_once($_SERVER['DOCUMENT_ROOT'].'/system/App.php');

if(!empty($id)) $profile = App::$user->infoByID($id, 'id, age, status, login, name, last_name, online, date_last, date_reg, avatar, fon_avatar, gender, email, access, country, city');
if(empty($profile)) $core->redirect('/');

$title = $profile['name'].' '.$profile['last_name'];
require_once ROOT.'/system/header.php';

$userGifts = $gifts->getUserGifts($id, 0, 6); 
$albumsUser = $albums->albumsByID($id, 0, 8);
?>
<script src="/design/js/upload.ajax.js"></script>
<div class="col-md-0 col-lg-1"></div>
<div class="col-md-4 col-lg-3">
    <div class="card" style="">
        <div class="profile-user">
            <div class="profile-user-fon" style="background-image: url(<?=$profile['avatar']?>);">
            	<div class="profile-info w-100 text-left pl-2 pt-2">
            		<div class="profile-user-avatar d-none" style="background-image: url(<?=$profile['avatar']?>);" style="width: 60px; height: 60px; "></div>
					<span class="text-light font-weight-bold" style="font-size: large;">
						<?=$profile['name']?> <?=$profile['last_name']?>
						<?php if ($id != $me['id']): ?>
							<span class="d-block font-weight-normal text-small"><?=($user->isOnline($id) ? 'Онлайн' : 'Заходил '.$sys->time($profile['date_last']))?></span>
						<?php endif; ?>
					</span>
					<?php if ($id == $me['id']): ?>
						<span class="float-right input-file-button" style="color: rgba(255,255,255, .8); bottom: 7px; right: 10px;">
							<input type="file" class="input-file" name="avatar" id="avatar">
							<i class="material-icons md-26">
								photo_camera
							</i>
						</span>
					<?php endif; ?>
				</div>
            </div>
            <style>
			.status {
				background: rgba(255, 255, 255, .03);
				color: #999;
				padding: 8px;
				margin: 8px;
				font-size: small;
				width: 87%;
			}
			</style>
			
            <div class="status" id="status">
            	<?php if ($profile['id'] == $me['id']): ?>
					<a href="#editStatus" id="edit-status" class="d-block text-center text-light"><?=(!empty($profile['status']) ? $profile['status'] : 'Изменить статус')?></a>
				<?php else: ?>
					<span class="d-block text-center"><?=(!empty($profile['status']) ? $profile['status'] : 'Статус отсутствует')?></span>
				<?php endif; ?>
			</div>
            <div class="status" id="status-form" style="display:none;"><input type="text" class="form-control" id="input-status" value="<?=$profile['status']?>"></div>
        </div>
        <script>
		$(document).ready(function() {
			var alerts = $('#alerts');
			
			$('#edit-status').on('click', function(e) {
				e.preventDefault();
				
				$('#status').hide();
				$('#status-form').show();
			});
			
			$('#input-status').blur(function() {
				var data = $('#input-status').val();
			
				$.ajax({
					url: '/AJAX/profile/editStatus.php',
					type: 'POST',
					data: {status: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'])
						{
							$('#edit-status').text(data);
							$('#status-form').hide();
							$('#status').show();
						}
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});
			$('#remove-friend').on('click', function(e) {
				e.preventDefault();
				var data = '<?=$id?>';
				
				$.ajax({
					url: '/AJAX/friends/removeFriend.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert mb-2 alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert mb-2 alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});
			$('#accept-app').on('click', function(e){
				e.preventDefault();
				var data = '<?=$id?>';
				
				$.ajax({
					url: '/AJAX/friends/acceptApplication.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert mb-2 alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert mb-2 alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});

			$('#reject-app').on('click', function(e){
				e.preventDefault();
				var data = '<?=$id?>';
				
				$.ajax({
					url: '/AJAX/friends/rejectApplication.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert mb-2 alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert mb-2 alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});
			
			$('#cancel-app').on('click', function(e){
				e.preventDefault();
				var data = '<?=$id?>';
				
				$.ajax({
					url: '/AJAX/friends/cancelApplication.php',
					type: 'POST',
					data: {id: data},
					dataType: 'json',
					success: function(json) {
						
						if (json['success'] == 1)
						{
							alerts.addClass("alert mb-2 alert-success");
							alerts.html(json['comment']);
						}
						else
						{
							alerts.addClass("alert mb-2 alert-danger");
							alerts.html(json['comment']);
						}
						
						setTimeout(function() {
							alerts.removeClass();
							alerts.html('');
						}, 1000);
					},
					error: function(xhr, ajaxOptions, thrownError) {
						alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
					}
				});
			});
		});
       </script>
        
        <div class="card-footer p-2">
        	<div id="alerts"></div>
        	
            <?php if($id != $me['id']): ?>
            	<div class="form-row mb-2">
	                <div class="col-6"><a href="/mail/new/id<?=$profile['id']?>" class="btn btn-theme-active btn-sm btn-block">Написать</a></div>
	                <div class="col-6">
		                <?php if ($friends->isSubscriber($me['id'], $id)): ?>
							<div class="btn-group"><a href="#acceptApp" class="btn btn-theme btn-sm" style="font-size: 80%;" id="accept-app">Принять</a> <a href="#rejectApp" class="btn btn-theme btn-sm" style="font-size: 80%;" id="reject-app">Отклонить</a></div>
						<?php elseif ($friends->isSubscriber($id, $me['id'])): ?>
							<a href="#cancelApp" class="btn btn-theme btn-sm btn-block" id="cancel-app">Отписаться</a>
		                <?php elseif (!$friends->isFriends($me['id'], $id)): ?>
							<a href="/friends/add/id<?=$profile['id']?>" class="btn btn-theme btn-sm btn-block" id="add-friend">Добавить в друзья</a>
						<?php else: ?>
							<a href="#deleteFriend" class="btn btn-theme btn-sm btn-block" id="remove-friend">Удалить из друзей</a>
						<?php endif; ?>
					</div>
				</div>
				<a href="#makePresent" class="btn btn-theme btn-sm btn-block" data-toggle="modal" data-target="#exampleModalLong">Сделать подарок</a>
                <!-- Modal -->
                <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content bg-theme-dark">
                            <script type="text/javascript">
                            $(document).ready(function() {
                            	
                                var response = $('#response');
                                var alerts = $('#alert');
                                
                                function getGifts() {               
                                    $.ajax({
                                    url: '/AJAX/user/getGifts.php',
                                    type: 'POST',
                                    data: '',
                                    dataType: 'json',
                                    beforeSend: function() {
                                    	$(response).html('<div class="text-center p-4">Загрузка...</div>');
                                    },
                                    success: function(jsoon) {
                                    
                                    	if(jsoon['error'] == 1) 
                                    	{
                                    		$(response).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                                    	} 
                                    	else if(jsoon['success'] == 1)
                                    	{
                                    	    $(response).html('');
                                    		jsoon['response'].forEach(function(cat) {
                                    	    	$(response).append('<h5>' + cat['name'] + '</h5>');
                                    	    	$(response).append('<div class="form-row text-center">');
                                    	    	cat['gifts'].forEach(function(gift) {
                                    	    	    $(response).append('<a href="#buy_gifts" class="col-2" data-id="' + gift['id'] + '"><div class="gift" style="background-image: url(' + gift['image'] + ');"><span id="price" class="badge badge-theme badge-pill">' + gift['price'] + ' ₽</span></div></a>');
                                    	    	});
                                    	    	$(response).append('</div>');
                                            });
                                    	}
                                    	
                                    },
                                    error: function(xhr, ajaxOptions, thrownError) {
                                    	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                                    }
                                    });
                                }
                                
                                $('#exampleModalLong').on('show.bs.modal', function () { 
                                    getGifts();
                                    
                                    $('#exampleModalLong').on('hidden.bs.modal', function () { 
                                        $('#buy-response').hide();
                                        $(response).show();
                                    });
                                });
                
                        		$('body').off('click').on('click', 'a.col-2', function (e) { 
                        		    e.preventDefault();
                        		    var dat = $(this).attr('data-id');
                                    
                                    $.ajax({
                                        url: '/AJAX/user/getGiftByID.php',
                                        type: 'POST',
                                        data: {id:dat},
                                        dataType: 'json',
                                        beforeSend: function() {
                                    		$('#response').html('<div class="text-center p-4">Загрузка...</div>');
                                    	},
                                        success: function(json) {
                                           $(response).hide();
                                           
                                        	if(json['error'] == 1) 
                                        	{
                                        		$(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                                        	} 
                                        	else if(json['success'] == 1)
                                        	{
                                        	    $('#giftName').html(json['response']['name']);
                                        	    $('#giftImage').css('backgroundImage', 'url(' + json['response']['image'] + ')')
                                        	    $('#giftPrice').html(json['response']['price'] + ' ₽');
                                        	    $('#buy-response').show();
                                        	}
                                        	
                                        },
                                        error: function(xhr, ajaxOptions, thrownError) {
                                        	alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                                        	console.log(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                                        }
                                    });
                                    
                                	$('#makeGiftButton').on('click', function(e) {
                        				e.preventDefault();
                        				
                        				var giftMessage = $('#giftMessage').val();
                        				$.ajax({
                                        	url: '/AJAX/user/makeGift.php',
                                        	type: 'POST',
                                        	data: {who:<?=$id?>, gift:dat, message:giftMessage},
                                        	dataType: 'json',
                                        	success: function(json) {
                                        		
                                        		if(json['error'] == 1) 
                                        		{
                                        			$(alerts).html('<div class="alert alert-danger">'+json['comment']+'</div>');
                                        		} 
                                        		else if(json['success'] == 1)
                                        		{
                                        			$(alerts).html('<div class="alert alert-success">'+json['comment']+'</div>');
                                        		}
                                        		
                                        		setTimeout(function () {
                                					$(alerts).html('');
                                				}, 2000);
                                        	},
                                        	error: function(xhr, ajaxOptions, thrownError) {
                                        		alert(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                                        		console.log(thrownError + "\r\n" + xhr.statusText + "\r\n " + xhr.responseText);
                                        	}
                                        });
                        			});
                        		});
                        	
                        	});
                            </script>
                            <div class="modal-header" style="border-bottom: 1px solid rgba(0,0,0,0.2)!important;">
                                <h5 class="modal-title" id="exampleModalLongTitle">Выберите подарок для @<?=$profile['login']?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div id="response"></div>
                                <div id="buy-response" class="text-center w-100" style="display: none;">
                                	<div id="alert"></div>
                                    <div class="form-row">
                                    	<div class="col-6 text-left">
                                        	<h5 id="giftName"></h5>
                                        	Стоимость: <span id="giftPrice" class="badge badge-theme badge-pill"></span>
                                        </div>
                                        <div class="col-6 text-right">
                                        	<span class="gift" id="giftImage" style="background-image: url();"></span>
                                        </div>
                                    </div>
                                    <div class="form-group text-left">
                						<label class="form-check-label text-secondary">Ваше сообщение получателю</label>
                						<input type="text" class="form-control" id="giftMessage" name="message" value="Лови подарок :)">
                					</div>
                                    <a href="#makeGift" class="btn btn-theme-active btn-sm" id="makeGiftButton">Подарить</a>
                                </div>
                            </div>
                            <div class="modal-footer d-none">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="button" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <a href="/profile/edit" class="btn btn-theme btn-sm btn-block">Редактировать информацию</a>
            <?php endif; ?>
        </div>
	</div>   
</div>

<div class="col-md-7 col-lg-7">
    <div class="card"> 
        <div class="card-body">
            <h6 class="card-title">
                <?=$profile['name']?> <?=$profile['last_name']?><br>
                <small class="text-muted">@<?=$profile['login']?></small>
            </h6>
            <p class="text-muted">
                <small>
                    Дата регистрации: <?=$sys->time($profile['date_reg'])?><br>
                    Посл. посещение: <?=$sys->time($profile['date_last'])?><br>
                    <?=(!empty($profile['country']) ? 'Страна: '.$profile['country'].'<br>' : '')?>
                    <?=(!empty($profile['city']) ? 'Город: '.$profile['city'].'<br>' : '')?>
					<?=(!empty($profile['age']) ? 'Возраст: '.$profile['age'].'<br>' : '')?>
                </small>
            </p>
            <button class="btn btn-theme-active btn-block collapsed" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample" style="margin-bottom: 0;">Подробная Информация</button><br>
            <div class="collapse" id="collapseExample" style="">
                <h6 class="card-title mb-0">Контактная информация</h6>
                <small class="text-muted">
                    E-mail: <?=(!empty($profile['email']) ? $profile['email'] : 'Пусто')?><br>
                </small>
                <br>
                <h6 class="card-title mb-0">Прочая информация</h6>
                <small class="text-muted">
                    Ранг: <?=(!empty($profile['access']) ? ($profile['access'] == 1 ? 'Модератор' : ($profile['access'] == 2 ? 'Администратор' : ($profile['access'] == 3 ? 'Создатель' : ($profile['access'] == 4 ? 'Разработчик' : 'Пользователь' ) ) )) : 'Пусто')?>
                </small>
            </div>
            <h6 class="card-title">Подарки</h6>
            <?php if(!empty($userGifts)): ?>
    		    <div class="form-row">
    			    <?php foreach($userGifts as $gift): ?>
    					<div class="col-4">
    						<div class="gift" style="background-image: url(<?=$gift['image']?>);"></div>
    					</div>
    				<?php endforeach; ?>
				</div>
			<?php else: ?>
				<div class="text-center text-muted">Пока пусто</div>
			<?php endif; ?>
        </div>
    </div>
    <div class="card">
        <ul class="list-group list-group-flush text-center">
            <a href="/albums/id<?=$profile['id']?>" class="list-group-item color-theme text-left">Альбомы <span class="badge badge-pill badge-theme float-right" style="position: relative; top: 5px;"><?=Base::count('albums', 'user_id = :id', ['id' => $id]) ?></span></a>
            <?php if(!empty($albumsUser)): ?>
                <li class="list-group-item">
                    <div class="form-row">
                    	<?php foreach($albumsUser as $list): ?>
                    	    <?php $preview = $albums->previewAlbum($list['id']); if(!empty($preview)): ?>
                    			<div class="col-6 col-sm-4 col-lg-3 w-100">
                    				<a href="/album/id<?=$list['id']?>" class="photo-album w-100" style="background-image: url(/uploads/<?=$preview['name']?>);"></a>
                    			</div>
                    		<?php else: ?>
                    				<div class="no-photo">Альбом пуст</div>
                    		<?php endif; ?>
                    	<?php endforeach; ?>
            	    </div>
                </li>
            <?php else: ?>
				<li class="list-group-item text-center text-muted">Пока пусто</li>
			<?php endif; ?>
        </ul>
    </div>
</div>
<?php
require_once ROOT.'/system/footer.php';
?>