<?php
/*
* App.php
* Router/Евгений Николаевич
* vk.com/zheka_9l
*/

// старт генерации
$startGenTime = (float)  microtime();

// Кодировка
mb_internal_encoding("UTF-8"); 

// Показ ошибок
ini_set('error_reporting', E_ALL); 
ini_set('display_errors', 1); 
ini_set('display_startup_errors', 1); 

// Сессии
session_start(); 
ob_start(); 

// Чекаем версию php
if(version_compare(PHP_VERSION, '7.2', '<'))
{ 
	exit('ОШИБКА! Версия PHP должна быть 7.2 и больше.'); 
}

// Особые константы и переменные
define('FILE', realpath(dirname(__FILE__)));
define('HOME', 'http://'.$_SERVER['HTTP_HOST']);
define('TIME', time());
define('ROOT', $_SERVER['DOCUMENT_ROOT']);
define('PATH_SYS_FILES', ROOT.'/system/files/');
define('FILE_SETTINGS', PATH_SYS_FILES.'site_settings.json');

$act = isset($_GET['act']) ? trim(htmlspecialchars($_GET['act'])) : null;
$id = isset($_GET['id']) ? abs(intval($_GET['id'])) : null;
$IP = isset($_SERVER['REMOTE_ADDR']) ? htmlspecialchars($_SERVER['REMOTE_ADDR']) : null;
$UA = isset($_SERVER['HTTP_USER_AGENT']) ? htmlspecialchars($_SERVER['HTTP_USER_AGENT']) : null;

// Грузим классы
spl_autoload_register(function($class) {
	$class = ROOT.'/system/classes/'.ucfirst($class).'.class.php';
	
	if(!is_file($class)) {
		throw new Exception('Файл класса не найден! '.$class);
	}
	require_once $class; 
});


Base::$debug = 1; // 0 - не выводить ошибок бд, 2 - выводить все(даже успешные запросы), 1 - только ошибки, пусть будет оно

$data = [
   'host' => 'localhost',
   'user' => 'siwap',
   'pass' => 'qazxsw102',
   'base' => 'siwap',
   'charset' => 'utf8'
];

Base::connect('mysql', $data) or die('Нет подключения.'); 

// настройки smsaero.ru
$arrSettings = [
	'key' => 'YKgaJidpP2INbwOpLnniEHye3l', // Ключ от smsaero
	'email' => urlencode('zheka.9l@yandex.ru') // Email
];

App::$core = $core = new Core; // класс Core
App::$sys = $sys = new System; // класс System
App::$settings = $settings = new Settings; // Настройки
App::$user = $user = new User; // класс User
App::$mail = $mail = new Mail; // класс Mail
App::$albums = $albums = new Albums; // класс Albums
App::$gifts = $gifts = new Gifts; // класс System
App::$stat = $stat = new Statistic; // класс Statistic
App::$me = $me = $user->info(); // информация текущего пользователя
App::$curl = $curl = new Curl;

$chat = new Chat;
$news = new News;
$users = new Users;
$friends = new Friends;
$notifications = new Notifications;

$aero = new Aero($arrSettings['key'], $arrSettings['email']); // класс для работы с smsaero.ru
