<?php

class Aero {
	
	public $apiKey = null, // API key
					$apiEmail = null, // Email
							$site = 'gate.smsaero.ru'; 
	
	public function __construct($apiKey, $apiEmail)
	{
		if (empty($apiKey) || empty($apiEmail))
		{
			throw new \Exception('Empty API key or Email');
		}
		else
		{
			$this->apiKey = $apiKey;
			$this->apiEmail = $apiEmail;
		}
	}
	
	public function send($text, $numbers)
	{
		$response = false;
		
		if (!empty($text) && !empty($numbers))
		{
			$sendParams = [
				'number' => $numbers,
				'text' => $text,
				'sign' => 'SMS Aero',
				'channel' => 'INFO'
			];
			$params = http_build_query($sendParams, '', '&');
			
			$request = App::$curl->get('https://'.$this->apiEmail.':'.$this->apiKey.'@'.$this->site.'/v2/sms/send?'.$params);
			
			if ($request) $response = json_decode($request);
		}
		return $response;
	}

}
