<?php

class Chat
{
	public function getMessages(int $offset = 0, int $count =10, $top = 1)
	{
		$response = false;
		
		if (!empty($count))
		{
			$request = Base::query(
				'SELECT `chat`.*, `user`.`name` as `user_name`, `user`.`last_name` as `last_name`, `user`.`avatar` as `user_avatar` FROM `chat`, `user` WHERE `user`.`id` = `chat`.`user_id` ORDER BY `time` '.($top == 1 ? 'ASC' : 'DESC').' LIMIT :offset,:count', [
					'offset/int' => $offset,
					'count/int' => $count,
				], 
				'arr'
			);
			
			if (!empty($request) && is_array($request))
			{
				foreach ($request as $chatKey => $chatValue)
				{
					$request[$chatKey]['time'] = App::$sys->time($request[$chatKey]['time']);
					$request[$chatKey]['user_avatar'] = HOME.$request[$chatKey]['user_avatar'];
				}
				$response = $request;
			}
		}
		return $response;
	}
	
	public function addMessage(string $message)
	{
		$response = false;
		
		if (!empty($message))
		{
			$response = Base::add('chat', [
				'time/int' => TIME,
				'user_id/int'=> App::$me['id'],
				'message' => $message,
			]);
		}
		return $response;
	}
}
