<?php

/*
* Class: Gifts 
* Info: Класс для работы с подарками
* Author: Евгений Шишмаков
* Time: 13:48 20.12.2018
*/

class Gifts {
	
	public $user_id = null;
	
	public function __construct()
	{
		$this->user = (!empty(App::$user->info()) ? App::$user->info() : null);
	}
	
    public function addGift($name, $type = 0, $time = null)
    {
        
    }
    
	public function getGift($id, $fields = '*') 
	{
	    $result = null;
	    
		if(!empty($id))
		{
		    $result = Base::query('SELECT '.$fields.' FROM `gift` WHERE `id` = :id LIMIT 1', [
			'id/int' => $id
			]);
		}
		return $result; 
	}
	
	public function getUserGifts($id, $offset = 0, $count = 10, $fields = '*') 
	{
	    $result = null;
	    
		if(!empty($id))
		{
		    $result = Base::query('SELECT `gift`.* FROM `user_gifts`, `gift` WHERE `gift`.`id` = `user_gifts`.`gift_id` AND `user_gifts`.`who_id` = :id LIMIT :offset,:count', [
			'id/int' => $id,
			'offset/int' => $offset,
			'count/int' => $count,
			], 'arr');
		}
		return $result; 
	}
	
	public function getGiftsByID($cat_id, $offset = 0, $count = 20)
	{
	    $result = null;
	    
		if(!empty($cat_id))
		{
		    $result = Base::query('SELECT * FROM `gift` WHERE `cat_id` = :cat_id ORDER BY `id` DESC LIMIT :offset,:count', [
			'cat_id/int' => $cat_id,
			'offset/int' => $offset,
			'count/int' => $count,
			], 
			'arr'
			);
		}
		return $result;
	}
	
	public function removeGift($gift_id)
	{
	    $result = false;
	    
	    if(!empty($gift_id) && $this->user['access'] > 0)
		{
			$gift = $this->getGift($gift_id);
	            
            if(!empty($gift))
			{
				if (file_exists(ROOT.$gift['image'])) unlink(ROOT.$gift['image']);
				
            	$result = Base::remove('gift', $gift['id']);
			}
	    }
	    return $result;
	}
	
	public function getCatByID($cat_id)
	{
	    $result = null;
	    
	    if(!empty($cat_id))
	    {
	        $result = Base::get('category_gifts', $cat_id);
	    }
	    return $result;
	}

	public function getCats($offset = 0, $count = 10)
	{
		return Base::query(
		'SELECT * FROM `category_gifts` ORDER BY `id` DESC LIMIT :offset,:count', [
		'offset/int' => $offset,
		'count/int' => $count,
		],
		'arr'
		);
	}
	
	public function addCat($name, $type = 0)
	{
	    $result = null;
	    
	    if(!empty($name) && $this->user['access'] > 0)
	    {
	       $result = Base::add('category_gifts', [
                'name' => $name,
                'type' => $type,
                'time' => TIME
            ]);
	    }
	    return $result;
	}

	public function removeCat($cat_id)
	{
	    $result = null;

	    if(!empty($cat_id) && $this->user['access'] > 2)
	    {
	        $cat = $this->getCatByID($cat_id);
	        
	        if(!empty($cat))
	        {
	            $gifts = $this->getGiftsByID($cat['id'], 0, 50);
	            
	            if(!empty($gifts))
	            {
	                foreach($gifts as $gift)
	                {
	                    $bool = $this->removeGift($gift['id']);
	                }
	            }
                if(Base::remove('category_gifts', $cat_id))
                {
                    $result = true;
                }
                else
                {
                    $result = false;
                }
	        }
	    }
	    return $result;
	}

}
	
