<?php

class Mail {
	
	public $user_id = null;
	
	public function __construct()
	{
		$this->user_id = (!empty(App::$user->info()) ? App::$user->info()['id'] : null);
	}
	
	public function DialogsFromUser($offset = 0, $count = 10)
	{
		if(!empty($this->user_id))
		{
			$query = Base::query(
			'SELECT `dialogs`.* FROM `dialog_users`, `dialogs` WHERE `dialogs`.`id` = `dialog_users`.`dialog_id` AND `dialog_users`.`user_id` = :id ORDER BY `last_time` DESC LIMIT :offset,:count', [
			'id' => $this->user_id,
			'offset/int' => $offset,
			'count/int' => $count,
			],
			'arr'
			);
		}
		
		if(!empty($query))
		{
			$result = $query;
		}
		else
		{
			$result = NULL;
		}
		return $result;
	}
	
	public function DialogByID($id)
	{
		$query = Base::get('dialogs', $id);
		
		if(!empty($query))
		{
			$result = $query;
		}
		else
		{
			$result = NULL;
		}
		return $result;
	}
	
	public function MessagesFromDialog($dialog_id, $offset = 0, $count = 20)
	{
		$query = $array = Base::query(
		'SELECT * FROM `messages` WHERE `dialog_id` = :id ORDER BY `id` ASC LIMIT :offset,:count', [
		'id' => $dialog_id,
		'offset/int' => $offset,
		'count/int' => $count,
		],
		'arr'
		);
		
		if(!empty($query))
		{
			$result = $query;
		}
		else
		{
			$result = NULL;
		}
		return $result;
	}
	
	public function UsersFromDialog($dialog_id, $offset = 0, $count = 10)
	{
		$query = Base::query(
			'SELECT * FROM `dialog_users` WHERE `dialog_id` = :id LIMIT :offset,:count', [
				'id' => $dialog_id,
				'offset/int' => $offset,
				'count/int' => $count,
			],
			'arr'
		);
		
		if(!empty($query))
		{
			$result = $query;
		}
		else
		{
			$result = NULL;
		}
		return $result;
	}
	
	public function previewDialog($dialog_id)
	{
		if(!empty($dialog_id))
		{
			$query = $array = Base::query(
				'SELECT * FROM `messages` WHERE `dialog_id` = :id ORDER BY `id` DESC LIMIT 1', [
					'id' => $dialog_id,
				],
				'arr'
			);
		}
		else $query = NULL;
		
		if(!empty($query))
		{
			$result = $query[0];
		}
		else $result = NULL;
		
		return $result;
	}
	
	public function addDialog($user_id, $contact_id)
	{
		$result = NULL;
		
		$checkContact = Base::query('SELECT `dialogs`.* FROM `dialog_users`, `dialogs` WHERE `dialogs`.`id` = `dialog_users`.`dialog_id` AND `dialogs`.`contact_id` = :contact_id AND `dialog_users`.`user_id` = :id ORDER BY `dialogs`.`last_time` DESC LIMIT 1', [
			'id/int' => $this->user_id,
			'contact_id/int' => $contact_id
		]);
		
		if(!empty($checkContact))
		{
				$result = ['dialog_id' => $checkContact['id']];
		}
		else
		{
			$dialog_id = Base::add('dialogs', [
				'author_id' => $user_id,
				'contact_id' => $contact_id,
				'last_time' => TIME
			]);
			
			if(!empty($dialog_id))
			{
				Base::add('dialog_users', [
					'user_id' => $user_id,
					'dialog_id' => $dialog_id, 
					'date_add' => TIME,
					'access' => 3
				]);
				Base::add('dialog_users', [
					'user_id' => $contact_id,
					'dialog_id' => $dialog_id, 
					'date_add' => TIME
				]);
				
				$result = ['dialog_id' => $dialog_id, 'author_id' => $user_id, 'contact_id' => $contact_id];
			}
		}
		return $result;
	}
	
	public function createChat($name, $avatar, $users)
	{
		$result = false;
		
		if(!empty($name) || !empty($avatar))
		{
			if(!empty($users) || count($users) < 2)
			{
				$chatId = Base::add('dialogs', [
					'author_id' => $this->user_id,
					'avatar' => $avatar,
					'name' => $name,
					'last_time' => TIME
				]);
				$insert = Base::add('dialog_users', [
					'user_id' => $this->user_id,
					'dialog_id' => $chatId,
					'access' => 3,
					'date_add' => TIME
				]);
				
				if(!empty($chatId) && !empty($insert))
				{
					foreach($users as $list)
					{
						$insert_id = Base::add('dialog_users', [
							'user_id' => $list,
							'dialog_id' => $chatId,
							'access' => 0,
							'date_add' => TIME
						]);
					}
					$result = $chatId;
				}
			}
		}
		return $result;
	}
	
	public function sendMessage($dialog_id, $message)
	{
		$result = false;
		
		if(!empty($dialog_id) && !empty($message))
		{
			$mess_id = Base::add('messages', [
				'read' => 0, 
				'time' => TIME,
				'message' => $message,
				'user_id' => $this->user_id,
				'dialog_id' => $dialog_id,
			]);
			
			$bool = Base::update('dialogs', $dialog_id, [
				'last_time' => TIME,
			]);
			
			if(!empty($mess_id))
			{
				$result = true;
			}
		}
		return $result;
	}
	
	public function unreadMessages($dialog_id)
	{
		$result = NULL;
		
		if(!empty($dialog_id))
		{
			$count = Base::query('SELECT COUNT(`dialog_id`) as `count` FROM `messages` WHERE `read` = 0 AND `user_id` != :user_id AND `dialog_id` = :dialog_id',[
			'user_id/int' => $this->user_id,
			'dialog_id/int' => $dialog_id,
			]
			);
			if(!empty($count['count']))
			{
				$result = $count['count'];
			}
		}
		return $result;
	}
	
	public function unreadDialogs()
	{
		$result = NULL;
		$dialogs = self::DialogsFromUser(0, 1000);
		
		if(!empty($dialogs))
		{
			$count = 0;
			
			foreach($dialogs as $dialog)
			{
				$unreadMessages = self::unreadMessages($dialog['id']);
				
				if(!empty($unreadMessages))
				{
					$count += 1;
				}
			}
			$result = $count;
		}
		return $result;
	}
	
	public function readMessage($array)
	{
		$result = false;
		
		if(!empty($array))
		{
			if($this->user_id != $array['user_id'] && $array['read'] == 0)
			{
				$result = Base::update('messages', $array['id'], [
					'read' => 1
				]);
			}
		}
		return $result;
	}
	
	public function isUserTheDialog(int $userId, int $dialogId)
	{
		$response = false;
		
		if (!empty($userId) && !empty($dialogId))
		{
			$query = Base::query(
				'SELECT id FROM `dialog_users` WHERE `dialog_id` = :dialog_id AND `user_id` = :user_id LIMIT 1', [
					'user_id/int' => $userId,
					'dialog_id/int' => $dialogId,
				],
				'arr'
			);
			if (!empty($query)) $response = true;
		}
		return $response;
	}
	
	public function ContactFromDialog($dialogId)
	{
	    $response = false;
	    
		if(!empty($dialogId))
		{
			$query = Base::query('SELECT * FROM `dialogs` WHERE `id` = :id AND (`author_id` = :user_id OR `contact_id` = :user_id) LIMIT 1', [
					'id/int' => $dialogId,
					'user_id/int' => $this->user_id,
			]);
			
			if (is_array($query))
			{
				$response = ($query['author_id'] != $this->user_id ? $query['author_id'] : $query['contact_id']);
			}
		}
		return $response;
	}
}
?>