<?php

class System {

    public static function quantDec($num, $word) {

    $col = intval($num);
    $rest = substr($col, -1);

    if ($col > 10 && $col < 20) {

        $res = trim($word[2]);

    } elseif ($rest > 1 && $rest < 5) {

        $res = trim($word[1]);

    } elseif ($rest == 1) {

        $res = trim($word[0]);

    } else {

        $res = trim($word[2]);

    }

    return $num . ' ' . $res;

    }
    
    public static function time($var) {
    
        $date = date('d.m.Y', $var);
        $time = date('H:i', $var);
        $hour = date('H', $var);
        $minut = date('i', $var);
    
        if ($date == date('d.m.Y')) 
        {
    
            if ($time == date('H:i')) 
            {
                $full_time = 'Только что';
            } 
            elseif ($hour == date('H')) 
            {
                $full_time = self::quantDec(date('i') - $minut, ['минуту', 'минуты', 'минут']) . ' назад';
            } 
            else 
            {
                $full_time = date('Сегодня в H:i', $var);
            }
    
        } 
        elseif ($date == date('d.m.Y', time() - 3600 * 24)) 
        {
            $full_time = date('Вчера в H:i', $var);
        } 
        elseif ($date == date('d.m.Y', time() - 3600 * 24 * 2)) 
        {
            $full_time = date('Позавчера в H:i', $var);
        } 
        elseif ($date == date('d.m.Y', time() + 3600 * 24)) 
        {
            $full_time = date('Завтра в H:i', $var);
        } 
        elseif ($date == date('d.m.Y', time() + 3600 * 24 * 2)) 
        {
            $full_time = date('Послезавтра в H:i', $var);
        } 
        else 
        {
            $full_time = date('d.m.Y в H:i', $var);
        }
    
        return $full_time;
    }
    
    public function createZip($files = array(),$destination = '',$overwrite = false) {
    	//if the zip file already exists and overwrite is false, return false
    	if(file_exists($destination) && !$overwrite) { return false; }
    	//vars
    	$valid_files = array();
    	//if files were passed in...
    	if(is_array($files)) {
    		//cycle through each file
    		foreach($files as $file) {
    			//make sure the file exists
    			if(file_exists($file)) {
    				$valid_files[] = $file;
    			}
    		}
    	}
    	//if we have good files...
    	if(count($valid_files)) {
    		//create the archive
    		$zip = new ZipArchive();
    		if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
    			return false;
    		}
    		//add the files
    		foreach($valid_files as $file) {
    			$zip->addFile($file,$file);
    		}
    		//debug
    		//echo 'The zip archive contains ',$zip->numFiles,' files with a status of ',$zip->status;
    		
    		//close the zip -- done!
    		$zip->close();
    		
    		//check to make sure the file exists
    		return file_exists($destination);
    	}
    	else
    	{
    		return false;
    	}
    }
    
    public function protect(string $str)
    {
    	if(!empty(trim($str)))
    	{
    		return htmlspecialchars(trim($str));
    	}
    	else return false;
    }
    
	public function isAjax()
	{
		return (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest' ? true : false);
    }
    
}

?>