<?php

class User
{
    public $user = null;
	
	public function __construct()
	{
		if (isset($_COOKIE['token']))
		{
			$cookieToken = $_COOKIE['token'];
			
			if ($userData = Base::get('user', ['token' => $cookieToken]))
			{
				$this->user = $userData; // массив с информацией юзера
				
				if (empty($this->user['date_last']) || $this->user['date_last'] < TIME)
				{
					$userOn = TIME - $this->user['date_last'];
					$newTime = $this->user['online'] + $userOn;
					
					$update = Base::update('user', $this->user['id'], [
						'date_last' => TIME,
						'online' => $newTime
					]);
				}
				
			}
			else if ($this->user['token'] != $cookieToken)
			{
				setcookie('token', '', TIME +60*60*24*7, '/');
			}
		}
	}

	public function access($type = 'user')
	{
		if ($type == 'user' && empty($this->user))
		{
			App::$core->redirect('/authorization');
		}
		else if ($type == 'guest' && !empty($this->user))
		{
			App::$core->redirect('/main');
		}
		else if ($type == 'md' && $this->user['access'] < 1)
		{
			App::$core->redirect('/main');
		}
		else if($type == 'adm' && $this->user['access'] < 2)
		{
			App::$core->redirect('/main');
		}
		else if($type == 'crt' && $this->user['access'] < 3)
		{
			App::$core->redirect('/main');
		}
		else if($type == 'dev' && $this->user['access'] < 4)
		{
			App::$core->redirect('/main');
		}
		return false;
	}

	public function info()
	{
		if (!empty($this->user) && empty($this->user['avatar']))
		{
			$this->user['avatar'] = '/design/img/avatar.jpg';
		}
		elseif (!empty($this->user) && empty($this->user['fon_avatar']))
		{
			$this->user['fon_avatar'] = '/design/img/cover.jpg';
		}
		elseif (!empty($this->user) && empty($this->user['login']))
		{
			$this->user['login'] = 'id'.$this->user['id'];
		}
		return $this->user;
	}

	public function infoByID(int $id, string $fields = '*')
	{
		$result = false;
		
		if(!empty($id) && !empty($fields))
		{
			$query = Base::query('SELECT '.$fields.' FROM `user` WHERE `id` = :id LIMIT 1', [
				'id/int' => $id,
			]);
			
			if (isset($query['avatar']) && empty($query['avatar']))
			{
				$query['avatar'] = '/design/img/avatar.jpg';
			}
			elseif (isset($query['fon_avatar']) && empty($query['fon_avatar']))
			{
				$query['fon_avatar'] = '/design/img/cover.jpg';
			}
			elseif (isset($query['login']) && empty($query['login']))
			{
				$query['login'] = 'id'.$id;
			}
			$result = $query;
		}
		return $result;
	}
	
	public function search($text, $fields = '*')
	{
		$response = false;
		
		if(!empty($text) && !empty($fields))
		{
			$query = Base::query(
				'SELECT '.$fields.' FROM `user` WHERE `id` LIKE :text OR `login` LIKE :text OR `name` LIKE :text OR `last_name` LIKE :text ORDER BY `id` DESC LIMIT 10', [
					'text' => '%'.$text.'%',
				],
				'arr'
			);
			
			if (is_array($query) && count($query) > 0)
			{
				foreach($query as $queryList)
				{
					if(isset($queryList['avatar']) && empty($queryList['avatar']))
					{
						$queryList['avatar'] = '/design/img/avatar.jpg';
					}
					if(isset($queryList['fon_avatar']) && empty($queryList['fon_avatar']))
					{
						$queryList['fon_avatar'] = '/design/img/cover.jpg';
					}
					if(isset($queryList['login']) && empty($queryList['login']))
					{
						$queryList['login'] = 'id'.$queryList['id'];
					}
					if($queryList['id'] != $this->user['id'])
					{
						$result[] = $queryList;
					}
				}
			}
		}
		return $result;
	}
	
	public function isOnline(int $id)
	{
		$response = false;
		
		if (!empty($id))
		{
			$response = $this->infoById($id, 'date_last') == (TIME - 300) ? true : false;
		}
		return $response;
	}
	
	public function isEmptyAvatar(int $id)
	{
		$response = false;
		
		if (!empty($id))
		{
			$query = $this->infoById($id, 'avatar');
			
			if (is_array($query))
			{
				$response = $query['avatar'] == '/design/img/avatar.jpg' || empty($query['avatar']) ? true : false;
			}
		}
		return $response;
	}
}