<?php
class CACHE {

	private $dir = 'cache';

	public function __construct ($dir) {
		$this->dir = $dir;
		if (!is_dir($this->dir)) {
			die('Папки для кеша не существует!');
		}
		else if (!is_writable($this->dir)) {
			die('Нет прав на запись файла!');
		}
	}

	public function cache ($name, $lifetime = 86400) {
		$cache = $this->name($name);
		
		if (!file_exists($cache)) {
			return false;
		}
		
		if (filemtime($cache) < (time() - $lifetime)) {
			$this->delete($cache);
			return false;
		}
		
		if (!$cache = file_get_contents($cache)) {
			return false;
		}
		
		return $cache;
	}

	public function save ($name, $data, $return = true) {
		$cache = $this->name($name, true);
		
		if (trim($data)) {
			file_put_contents($cache, $data);
			chmod($cache, 0644);
			if ($return) {
				return $data;
			} else {
				echo $data;
			}
		} else {
			return false;
		}
	}

	public function delete ($name) {
		$cache = $this->name($name);
		
		if (file_exists($cache)) {
			unlink($cache);
			return true;
		}
		
		return false;
	}

	private function name ($name, $create = false) {
		$hash = md5($name);
		$dir = substr($hash, 0, 5);
		
		if ($create && !is_dir($this->dir.'/'.$dir)) {
			mkdir($this->dir.'/'.$dir, 0755, true);
		}
		
		return sprintf('%s/%s/%s', $this->dir, $dir, $hash);
	}
	
}
?>