<?php

function checkout($var)
{
	return strip_tags(addslashes(html_entity_decode($var,ENT_QUOTES, 'utf-8')));
}

function parse_url_if_valid($url)
{
    $arUrl = parse_url($url);
    $ret = null;

    if (!array_key_exists("scheme", $arUrl)
            || !in_array($arUrl["scheme"], array("http", "https")))
        $arUrl["scheme"] = "http";

    if (array_key_exists("host", $arUrl) &&
            !empty($arUrl["host"]))
        $ret = sprintf("%s://%s%s", $arUrl["scheme"],
                        $arUrl["host"], $arUrl["path"]);

   else if (preg_match("/^\w+\.[\w\.]+(\/.*)?$/", $arUrl["path"]))
        $ret = sprintf("%s://%s", $arUrl["scheme"], $arUrl["path"]);

    if ($ret && empty($ret["query"]))
        $ret .= sprintf("?%s", $arUrl["query"]);

    return $ret;
}

function text($mes)
{
    $mes = nl2br($mes);
 
    return $mes;
}

function no_tags($mes)
{
    $mes = str_replace("<br />", "\r\n", $mes);
 
    return $mes;
}
	
function cut($str,$href) {
if (mb_strlen($str) > 300) $str = str_replace("|", "<br />", mb_substr(str_replace("<br />", "|", $str), 0, 300, 'UTF-8')).'...<div><a style="font-weight:bold;" href="'.$href.'" onclick="Page.Go(this.href); return false">'.lang('Читать делее...','Читати далі...').'</a></div>';
return $str;
}

// Ретранслит русских букв на латинницу
function retranslit($in)
{

	$trans1= array("'",'`',',',' ',"Ё","Ж","Ч","Ш","Щ","Э","Ю","Я","ё","ж","ч","ш","щ","э","ю","я","А","Б","В","Г","Д","Е","З","И","Й","К","Л","М","Н","О","П","Р","С","Т","У","Ф","Х","Ц","Ь","Ы","а","б","в","г","д","е","з","и","й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ь","ы");
	
	$trans2= array('_','_','_','_',"JO","ZH","CH","SH","SCH","Je","Jy","Ja","jo","zh","ch","sh","sch","je","jy","ja","A","B","V","G","D","E","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","C","","Y","a","b","v","g","d","e","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","c","","y");
	
	return str_replace($trans1,$trans2,$in);

}

// Ретранслит латинских букв на русские
function translit($in)
{
	$trans1= array("w","yu","W","YU","JO","ZH","CH","SH","SCH","JE","JY","JA","jo","zh","ch","sh","sch","je","jy","ja","A","B","V","G","D","E","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","C","'","Y","a","b","v","g","d","e","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","c","'","y");
	$trans2= array("ш","ю","Ш","Ю","Ё","Ж","Ч","Ш","Щ","Э","Ю","Я","ё","ж","ч","ш","щ","э","ю","я","А","Б","В","Г","Д","Е","З","И","Й","К","Л","М","Н","О","П","Р","С","Т","У","Ф","Х","Ц","Ь","Ы","а","б","в","г","д","е","з","и","й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ь","ы");
	return str_replace($trans1,$trans2,$in);
}

// Проверка длины русских символов
function strlen_rus($var)
{
    $rus_symbols = array('а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ', 'ъ', 'ы', 'ь', 'э', 'ю', 'я', 'А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я', 'І', 'і', 'Ї', 'ї', 'Є', 'є');

    return strlen(str_replace($rus_symbols, '0', $var));
}

function generate($number){
	$arr = array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','r','s','t','u','v','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','R','S','T','U','V','X','Y','Z','1','2','3','4','5','6','7','8','9','0');  
    // Генерируем пароль  
    $pass = '';  
    for($i = 0; $i < $number; $i++){
		// Вычисляем случайный индекс массива
		$index = rand(0, count($arr) - 1);
		$pass .= $arr[$index];  
    }
	return $pass;  
}

function utfwin($str) {
    $str = strtr($str, array("Р°" => "а", "Р±" => "б", "РІ" => "в", "Рі" => "г", "Рґ" => "д", "Рµ" => "е", "С‘" => "ё", "Р¶" => "ж", "Р·" => "з", "Рё" => "и", "Р№" => "й", "Рє" => "к", "Р»" => "л", "Рј" => "м", "РЅ" => "н", "Рѕ" => "о",
    "Рї" => "п", "СЂ" => "р", "СЃ" => "с", "С‚" => "т", "Сѓ" => "у", "С„" => "ф", "С…" => "х", "С†" => "ц", "С‡" => "ч", "С€" => "ш", "С‰" => "щ", "СЉ" => "ъ", "С‹" => "ы", "СЊ" => "ь", "СЌ" => "э", "СЋ" => "ю", "СЏ" => "я", "Рђ" => "А",
    "Р‘" => "Б", "Р’" => "В", "Р“" => "Г", "Р”" => "Д", "Р•" => "Е", "РЃ" => "Ё", "Р–" => "Ж", "Р—" => "З", "Р" => "И", "Р™" => "Й", "Рљ" => "К", "Р›" => "Л", "Рњ" => "М", "Рќ" => "Н", "Рћ" => "О", "Рџ" => "П", "Р " => "Р", "РЎ" => "С",
    "Рў" => "Т", "РЈ" => "У", "Р¤" => "Ф", "РҐ" => "Х", "Р¦" => "Ц", "Р§" => "Ч", "РЁ" => "Ш", "Р©" => "Щ", "РЄ" => "Ъ", "Р«" => "Ы", "Р¬" => "Ь", "Р­" => "Э", "Р®" => "Ю", "РЇ" => "Я"));
    return $str;
}

function winutf($str) {
    $str = strtr($str, array("а" => "Р°", "б" => "Р±", "в" => "РІ", "г" => "Рі", "д" => "Рґ", "е" => "Рµ", "ё" => "С‘", "ж" => "Р¶", "з" => "Р·", "и" => "Рё", "й" => "Р№", "к" => "Рє", "л" => "Р»", "м" => "Рј", "н" => "РЅ", "о" => "Рѕ", "п"
    => "Рї", "р" => "СЂ", "с" => "СЃ", "т" => "С‚", "у" => "Сѓ", "ф" => "С„", "х" => "С…", "ц" => "С†", "ч" => "С‡", "ш" => "С€", "щ" => "С‰", "ъ" => "СЉ", "ы" => "С‹", "ь" => "СЊ", "э" => "СЌ", "ю" => "СЋ", "я" => "СЏ", "А" => "Рђ", "Б" =>
    "Р‘", "В" => "Р’", "Г" => "Р“", "Д" => "Р”", "Е" => "Р•", "Ё" => "РЃ", "Ж" => "Р–", "З" => "Р—", "И" => "Р", "Й" => "Р™", "К" => "Рљ", "Л" => "Р›", "М" => "Рњ", "Н" => "Рќ", "О" => "Рћ", "П" => "Рџ", "Р" => "Р ", "С" => "РЎ", "Т" =>
    "Рў", "У" => "РЈ", "Ф" => "Р¤", "Х" => "РҐ", "Ц" => "Р¦", "Ч" => "Р§", "Ш" => "РЁ", "Щ" => "Р©", "Ъ" => "РЄ", "Ы" => "Р«", "Ь" => "Р¬", "Э" => "Р­", "Ю" => "Р®", "Я" => "РЇ"));
    return $str;
}

$dir = opendir(HOME.'/autoload/');

while ($file = readdir($dir))
{
    if (preg_match('/\.php$/i', $file)) require_once(HOME.'/autoload/'. $file);
}

// Обработка времени
function vtime($var, $title=false)
{
    # Если время не задано берем текущее
    if ($var == NULL) $var = time();

    # Время + Дата
    $full_time = date('d.m.Y '.lang('в','о').' H:i', $var);

    # Дата
    $date = date('d.m.Y', $var);

    # Время
    $time = date('H:i', $var);

    # Если текущаяя дата совпадает с заданной
    if ($date == date('d.m.Y'))
	{
		$full_time = date(''.lang('Сегодня в','Сьогодні о').' H:i', $var);
		$h = date('H', $var);
		$i = date('i', $var);
		if ($h == date('H'))
		{
			if ($i == date('i')) $full_time = lang('только что','тільки що');
			else $full_time = (date('i') - $i).' '.lang('мин. назад','хв. тому');
		}
		else
		{
			$full_time = $time;
		}
	}

    # Вчерашняя дата
    if ($date == date('d.m.Y', time()-60*60*24)) $full_time = date(''.lang('Вчера в','Вчора о').' H:i', $var);

	if ($title == false) $full_time = '<font class="time"><small>'.$full_time.'</small></font>';
	
    return $full_time;
}

// Вывод ошибок
function err($err) {
if ($err == true) $err = '<div class="err">'.$err.'</div>';
	else $err = '';
	return $err;
}
function ok($text) {
if (!empty($text))
{
	$text = '<div class="ok">'.$text.'</div>';
}
	return $text;
}


// рекурсивное удаление папки
function delete_dir($dir){
if (is_dir($dir)){$od=opendir($dir);
while ($rd=readdir($od)){
if ($rd == '.' || $rd == '..') continue;
if (is_dir("$dir/$rd")){
@chmod("$dir/$rd", 0777);
delete_dir("$dir/$rd");}
else{
@chmod("$dir/$rd", 0777);
@unlink("$dir/$rd");}}
closedir($od);
@chmod("$dir", 0777);
return @rmdir("$dir");}
else{
@chmod("$dir", 0777);
@unlink("$dir");}}

?>