CREATE TABLE IF NOT EXISTS `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `opis` varchar(256) NOT NULL,
  `access` enum('all','only_me','friends','pass','auth') DEFAULT 'all',
  `password` mediumtext,
  `my` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gallery_frend` (
  `time` int(11) NOT NULL,
  `id_avtor` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_foto` int(11) NOT NULL DEFAULT '0',
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gallery_rating` (
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) DEFAULT '0',
  `avtor` int(11) DEFAULT '0',
  `ready` int(11) DEFAULT '1',
  `time` int(11) DEFAULT '0',
  KEY `id_foto` (`id_foto`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gallery_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gallery` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `ras` varchar(4) NOT NULL,
  `type` varchar(64) NOT NULL,
  `adult` enum('0','1') DEFAULT '0',
  `opis` varchar(10024) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `komm` enum('all','only_me','friends') DEFAULT 'all',
  `avatar` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_gallery` (`id_gallery`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gallery_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(10024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `gallery_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_foto` int(11) NOT NULL,
  `like` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;