<?php

/* DCMS Special
 * Дата последнего редактирования 10.10.2016
 * Модифицировал densnet
 */

foreach (array('start', 'compress', 'sess', 'settings', 'db_connect', 'ipua', 'fnc', 'user') as $inc) {
    require_once "../../sys/inc/$inc.php";
}
#Спрашиваем разрешение на создание новости
access('adm_news_add', null, 'index.php?' . SID);

$set['title'] = lang('Новости');

require_once H . 'sys/inc/thead.php';

if (isset($_POST['title']) && isset($_POST['msg']) && isset($_POST['link'])) {

    $title = esc(stripcslashes(htmlspecialchars($_POST['title'], 1)));
    $link = esc($_POST['link'], 1);

    if ($link != NULL && !preg_match('#^https?://#i', $link) && !preg_match('#^/#', $link)) {
        $link = '/' . $link;
    }

    if (utf8_strlen($title) > 250) {
        $err = lang('Длинный заголовок');
    }

    if (utf8_strlen($title) < 3) {
        $err = lang('Короткий заголовок');
    }

    $mat = antimat($title);

    if ($mat) {
        $err[] = lang("В заголовке обнаружен мат") . ": $mat";
    }

    $msg = esc($_POST['msg']);

    if (utf8_strlen($msg) > 10024) {
        $err = lang('Содержиние слишком длинное');
    }

    if (utf8_strlen($msg) < 2) {
        $err = lang('Содержиние слишком короткое');
    }

    $mat = antimat($msg);

    if ($mat) {
        $err[] = lang("В содержании обнаружен мат") . ": $mat";
    }

    if (isset($_POST['tags']) && $_POST['tags'] != NULL) {
        $tags = esc(stripcslashes(htmlspecialchars($_POST['tags'])));

        if (utf8_strlen($tags) < 2) {
            $err[] = lang('Слишком короткие теги');
        }
        if (utf8_strlen($tags) > 128) {
            $err[] = lang('Слишком длинные теги');
        }

        $mat = antimat($tags);

        if ($mat) {
            $err[] = lang('В тегах обнаружен мат') . ': ' . $mat;
        }
        $tags = $db->safesql($tags);
    } else {
        $tags = NULL;
    }

    $close = intval($_POST['close']);

    if (!isset($err)) {

        $ch = intval($_POST['ch']);
        $mn = intval($_POST['mn']);
        $main_time = time() + $ch * $mn * 60 * 60 * 24;

        if ($main_time <= time()) {
            $main_time = 0;
        }

        $db->query("INSERT INTO `news` (`time`, `msg`, `title`, `main_time`, `link`, `avtor`, `tags`, `close`) values('$time', '" . $db->safesql($msg) . "', '$title', '$main_time', '$link', '$user[nick]', '$tags', '$close')");
        $db->query("OPTIMIZE TABLE `news`");

        #Расслылка новостей на майл
        if (isset($_POST['mail'])) {
            $q = $db->query("SELECT `ank_mail` FROM `user` WHERE `set_news_to_mail` = '1' AND `ank_mail` <> ''");
            while ($ank = $db->get_row($q)) {
                $db->query("INSERT INTO `mail_to_send` (`mail`, `them`, `msg`) values('$ank[ank_mail]', '" . lang('Новости') . "', '" . toOutput($msg) . "')");
            }
        }

        $_SESSION['message'] = lang('Новость успешно опубликована');
        header("Location: index.php");
        exit;
    }
}

err();

#Навигация
echo "<div class='list-group-item-null list-group-item-grey'><small>";
echo "<a href='/' class='hint--right' data-hint='" . lang('На главную') . "'><i class='fa fa-home fa-lg'></i></a> <i class='fa fa-angle-right fa-fw'></i> ";
echo "<a href='" . DIR_NEWS . "'>" . lang('Новости') . "</a> <i class='fa fa-angle-right fa-fw'></i> ";
echo lang('Новая новость');
echo "</small></div><br />";

echo "<form class='list-group-item-null' name='add' method='POST' action='add.php'>";

$count_email = $db->super_query("SELECT COUNT(*) as count FROM `user` WHERE `set_news_to_mail` = '1' AND `ank_mail` <> ''");
$count_email = $count_email['count'];

$doc->Input('title', 'Заголовок новости', 250, null, 'form-control', 'text', 'required');
$doc->Input('link', 'Ссылка на источник', 200);

echo lang('Содержание новости') . "<br />";
echo auto_bb("add", "msg");
echo "<textarea name='msg' required class='form-control'></textarea><br />";

$doc->Input('tags', 'Теги', 128);
echo "<br />";

if ($count_email != 0) {
    $doc->Checkbox('mail', "Рассылка на email ($count_email)", 1, "checked='checked'");
}

echo "<b>" . lang('Кто может комментировать') . "</b><br />";
$doc->Radio('close', 'Все', 0, "checked='checked'", 'users');
$doc->Radio('close', 'Никто', 1, null, 'lock');

echo "<br />";

echo "<b>" . lang('Показывать на главной') . "</b><br />";
echo "<input name='ch' type='number' value='1' class='form-control' style='width: 20%'><br /> ";

echo "<select name='mn' class='custom-select'>";
echo "<option value='0' selected='selected'>" . lang('Не показывать') . "</option>";
echo "<option value='1'>" . lang('Дней') . "</option>";
echo "<option value='7'>" . lang('Недель') . "</option>";
echo "<option value='31'>" . lang('Месяцев') . "</option>";
echo "</select><br /><br />";


$doc->Button('btn btn-primary btn-sm', 'ok', 'pencil', 'Опубликовать');

echo "</form>";

require_once H . 'sys/inc/tfoot.php';
