<?php

/* DCMS Special
 * Дата последнего редактирования 10.10.2016
 * Модифицировал densnet
 */

foreach (array('start', 'compress', 'sess', 'settings', 'db_connect', 'ipua', 'fnc', 'user') as $inc) {
    require_once "../../sys/inc/$inc.php";
}

$set['title'] = lang('Новости');

require_once H . 'sys/inc/thead.php';

#Заголовок
aut();

#Путь папки новостей
define('DIR_NEWS', "/modules/news/");

#Сокращаем пути
if (isset($_GET['edit'])) {
    require_once H . DIR_NEWS . 'edit.php';
} elseif (isset($_GET['delete'])) {
    require_once H . DIR_NEWS . 'delete.php';
} elseif (isset($_GET['add'])) {
    require_once H . DIR_NEWS . 'add.php';
} elseif (isset($_GET['settings'])) {
    require_once H . DIR_NEWS . 'settings.php';
} elseif (isset($_GET['edit_komm'])) {
    require_once H . DIR_NEWS . 'edit_komm.php';
} elseif (isset($_GET['news'])) {
    require_once H . DIR_NEWS . 'news.php';
} elseif (isset($_GET['new_komm'])) {
    require_once H . DIR_NEWS . 'komm.php';
} elseif (isset($_GET['add'])) {
    require_once H . DIR_NEWS . 'add.php';
} else {
    $k_post = $db->super_query("SELECT COUNT(*) as count FROM news");
    $k_page = k_page($k_post['count'], $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];
    $q = $db->query("SELECT * FROM `news` ORDER BY `id` DESC LIMIT $start, $set[p_str]");

    #Навигация
    echo "<div class='list-group-item-null list-group-item-grey'><small>";
    echo "<a href='/' class='hint--right' data-hint='" . lang('На главную') . "'><i class='fa fa-home fa-lg'></i></a> <i class='fa fa-angle-right fa-fw'></i> ";
    echo lang('Новости');
    echo "</small></div>";

    if (isset($user)) {
        echo "<div class='list-group-item-null'>";

        echo "<a href='/user/settings/news.php' class='btn btn-secondary btn-sm'><span style='color: grey;'><i class='fa fa-cog fa-fw'></i> " . lang('Параметры') . "</span></a> ";
        echo "<a href='tags.php' class='btn btn-secondary btn-sm'><span style='color: grey;'><i class='fa fa-tags fa-fw'></i> " . lang('Метки') . "</span></a> ";

        if (access('adm_news_add') && isset($user)) {
            echo " <a href='?add' class='btn btn-secondary btn-sm'><span style='color: grey;'><i class='fa fa-plus fa-fw'></i> " . lang('Создать') . "</span></a> ";
        }

        echo "</div>";
    }
    #Выводим список новостей
    while ($post = $db->get_row($q)) {
        $like = $db->super_query("SELECT COUNT(*) as count FROM `news_like` WHERE `id_news` = '" . $post['id'] . "'");
        $like = $like['count'];

        echo "<div class='list-group-item-null list-group-item-grey dop'>";

        if (access('adm_news_edit') || access('adm_news_delete')) {
            echo "<span style='float:right;'>";
            echo "<div class='btn-group'>";
            echo "<a class='btn btn-sm' style='margin-right: -12px;' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'><i class='fa fa-chevron-down'></i></a>";
            echo "<div class='dropdown-menu dropdown-menu-right'>";
            if (access('adm_news_edit')) {
                echo "<a class='dropdown-item' href='?edit=$post[id]'><i class='fa fa-edit fa-fw'></i> " . lang('Редактировать') . "</a>";
            }
            if (access('adm_news_delete')) {
                echo "<a class='dropdown-item' href='?delete=$post[id]'><i class='fa fa-trash-o fa-fw'></i> " . lang('Удалить') . "</a>";
            }
            echo "</div>";
            echo "</div>";
            echo "</span>";
        }

        if (IS_WEB) {
            echo "<b><a href='?news=$post[id]'>" . toOutput($post['title']) . "</a></b><br /><br />";
        } else {
            echo "<small><b><a href='?news=$post[id]'>" . toOutput($post['title']) . "</a></b></small><br /><br />";
        }


        #Текст новости
        if (IS_WEB) {
            echo toOutput(cutStr($post['msg'], 300)) . "<br />";
        } else {
            echo "<small>" . toOutput(cutStr($post['msg'], 300)) . "</small><br />";
        }
        #Изображение, если есть
        if ($user['set_news_images'] == 1) {
            if (is_file(H . 'modules/news/images/' . $post['id'] . '.png')) {
                echo "<br /><img src='" . DIR_NEWS . "images/$post[id].png' style='border: 1px solid #CCDDED; padding: 2px; border-radius: 5px; max-width: 200px;' /><br />";
            }
        }

        echo "<br /><small style='color: #9197a3;'>";
        if ($post['time_edit'] != 0) {
            #Показываем последнее редактирование
            echo "<span style='float: right;color: green;'>" . lang('обновлено') . " " . date::timek($post['time_edit']) . "</span>";
        }
        echo "<i class='fa fa-user fa-fw'></i> $post[avtor] &#183; <span class='hint--right' data-hint='" . date::time($post['time']) . "'>" . date::timek($post['time']) . "</span> ";
        if ($post['link'] != NULL) {
            echo " &#183; <a href='" . htmlentities($post['link'], ENT_QUOTES, 'UTF-8') . "'>" . lang('Источник') . "</a>  ";
        }
        if ($post['close'] == 1) {
            echo " &#183; <i class='fa fa-lock' style='color: grey;'></i>";
        }
        echo "</small>";

        if (isset($user)) {
            echo "<div class='hr'></div>";

            if ($like == 0) {
                $l = null;
            } else {
                $l = $db->super_query("SELECT COUNT(*) as count FROM `news_like` WHERE `id_news` = '$post[id]'");
                $l = $l['count'];
            }
            $news_like = $db->super_query("SELECT COUNT(*) as count FROM `news_like` WHERE `id_news` = '$post[id]' AND `id_user` = '$user[id]' LIMIT 1");

            if ($news_like['count'] == 0) {
                echo "<a href='?news=$post[id]&amp;likes' class='btn btn-secondary btn-sm hint--right' data-hint='" . lang('Мне нравится') . "' ><i class='fa fa-heart-o fa-fw'></i> $l</a> ";
            } else {
                echo "<a href='?news=$post[id]&amp;unlikes' class='btn btn-secondary btn-sm hint--top-right' data-hint='" . lang('Вам понравилась новость') . "'><i class='fa fa-heart fa-fw'></i> $l</a> ";
            }
            unset($news_like);

            $komms = $db->super_query("SELECT COUNT(*) as count FROM `news_komm` WHERE `id_news` = '$post[id]' LIMIT 1");
            $komms = $komms['count'];

            echo "<span style='float: right;'>";
            echo " <a href='" . DIR_NEWS . "?news=$post[id]' class='hint--left btn btn-secondary btn-sm' data-hint='" . lang('Прокомментировали') . " " . sklon_text($komms, array(lang('раз'), lang('раза'), lang('раз'))) . "'><i class='fa fa-comments fa-fw' style='color: grey;'></i> $komms </a> ";

            #Просмотры
            echo " <span class='hint--top-left btn btn-secondary btn-sm' data-hint='" . lang('Просмотрели') . " " . sklon_text($post['prosm'], array(lang('раз'), lang('раза'), lang('раз'))) . "'><i class='fa fa-eye fa-fw' style='color: grey;'></i> $post[prosm]</span> ";
            echo "</span>";
            if ($like > 0) {
                if (IS_WEB) {
                    $q_like = $db->query("SELECT * FROM `news_like` WHERE `id_news` = '$post[id]' ORDER BY id DESC LIMIT 10");
                } else {
                    $q_like = $db->query("SELECT * FROM `news_like` WHERE `id_news` = '$post[id]' ORDER BY id DESC LIMIT 5");
                }
                while ($post_like = $db->get_array($q_like)) {
                    $ank = get_user($post_like['id_user']);
                    echo "<a href='/id$ank[id]' class='hint--top' data-hint='$ank[nick]'>";
                    echo avatar($ank['id'], '25', 'border-radius: 2px;');
                    echo "</a> ";
                }
            }
        }

        #По настройке пользователя выводим комментарии
        if ($user['set_news_comments'] == 1) {
            echo "<div class='hr'></div>";

            $k_posts = $db->super_query("SELECT COUNT(*) as count FROM `news_komm` WHERE `id_news` = '$post[id]'");
            $k_posts = $k_posts['count'];
            $k_pages = k_page($k_posts, $set['p_str']);
            $pages = page($k_pages);
            $starts = $set['p_str'] * $pages - $set['p_str'];
            #Количество выводимых комментариев
            if (IS_WEB) {
                $qs = $db->query("SELECT * FROM `news_komm` WHERE `id_news` = '$post[id]' ORDER BY `id` DESC LIMIT 5");
            } else {
                $qs = $db->query("SELECT * FROM `news_komm` WHERE `id_news` = '$post[id]' ORDER BY `id` DESC LIMIT 3");
            }

            if ($k_posts == 0) {
                echo "<span style='color: #9197a3;'><i class='fa fa-comments fa-fw'></i> " . lang('Еще не обсуждали') . "...</span>";
            }

            while ($posts = $db->get_row($qs)) {
                $anks = get_user($posts['id_user']);

                echo "<small>";
                echo "<span style='float: right;color: #ccc;'>" . date::timek($posts['time']) . "</span>";
                echo "<b>$anks[nick]</b>: ";
                echo " " . toOutput($posts['msg']);
                echo "</small><br />";
            }
        }
        echo "</div>";
    }

    #Если нет новостей
    if ($k_post['count'] == 0) {
        $doc->NoResult();
    }

    if ($k_page > 1) {
        str('index.php?', $k_page, $page);
    }
}

require_once H . 'sys/inc/tfoot.php';


