<?php

/* DCMS Special
 * Дата последнего редактирования 07.10.2016
 * Модифицировал densnet
 */

foreach (array('start', 'compress', 'sess', 'settings', 'db_connect', 'ipua', 'fnc', 'user') as $inc) {
    require_once "../../sys/inc/$inc.php";
}

$set['title'] = lang('Новости - Поиск по меткам'); // заголовок страницы
require_once H . 'sys/inc/thead.php';

$tag = NULL;
if (isset($_SESSION['tag'])) {
    $tag = $_SESSION['tag'];
}
if (isset($_GET['tag'])) {
    $tag = esc(urldecode($_GET['tag']));
}
$_SESSION['tag'] = $tag;

$tag = preg_replace("#( ){2,}#", " ", $tag);
$tag = preg_replace("#^( ){1,}|( ){1,}$#", "", $tag);

aut();
err();

#Навигация
echo "<div class='list-group-item-null list-group-item-grey'><small>";
echo "<a href='/' class='hint--right' data-hint='" . lang('На главную') . "'><i class='fa fa-home fa-lg'></i></a> <i class='fa fa-angle-right fa-fw'></i> ";
echo "<a href='/modules/news/'>" . lang('Новости') . "</a> <i class='fa fa-angle-right fa-fw'></i> ";
echo lang('Поиск по меткам');
echo "</small></div><br />";

if ($tag != NULL) {

    $q_tag = str_replace('%', '', $tag);
    $q_tag = str_replace(' ', '%', $q_tag);
    $q_tag = str_replace(',', '%', $q_tag);
    $k_post = $db->super_query("SELECT COUNT(*) as count FROM `news` WHERE `tags` like '%" . $db->safesql($q_tag) . "%'");
    $k_post = $k_post['count'];
    $k_page = k_page($k_post, $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];
    if ($k_post == 0) {
        $doc->NoResult();
    }
    $q = $db->query("SELECT * FROM `news` WHERE `tags` like '%" . $db->safesql($q_tag) . "%' ORDER BY `id` DESC LIMIT $start, $set[p_str]");

    while ($post = $db->get_row($q)) {
        $us = get_user($post['avtor']);
        $post['tags'] = str_replace("$tag", "<span style='color:red'>$tag</span>", $post['tags']);

        echo "<div class='list-group-item-null list-group-item-grey' style='margin-bottom: 5px;'>";

        echo "<a href='/modules/news/?news=$post[id]'><i class='fa fa-feed fa-fw'></i> $post[title]</a> <small style='color: grey;'>" . date::time($post['time']) . "</small><br />";

        echo "<i class='fa fa-tags fa-fw'></i> " . lang('Метки') . ": $post[tags]<br />";
        echo "<i class='fa fa-user fa-fw'></i> $post[avtor] &#183; <span class='hint--top' data-hint='" . date::time($post['time']) . "' style='color: grey;'>" . date::times($post['time']) . "</span> ";

        echo "</div>";
        echo "<div class='hr'></div>";
    }

    if ($k_page > 1) {
        str("?", $k_page, $page);
    }
} else {
    echo '<div class="list-group-item-null list-group-item-grey">';
    echo lang('Введите метку для поиска');
    echo '</div>';
}

echo '<form method="get" action="?" class="list-group-item-null">';
$tag = stripcslashes(htmlspecialchars($tag));
$doc->Input('tag', 'Метки', 54, "$tag");
echo "<br />";
$doc->Button('btn btn-success btn-sm', null, 'search', 'Поиск');
echo '</form>';

require_once H . 'sys/inc/tfoot.php';
