<?php

class gifdecoder {

    public $GIF_buffer = Array();
    public $GIF_arrays = Array();
    public $GIF_delays = Array();
    public $GIF_offset = Array();
    public $GIF_stream = "";
    public $GIF_string = "";
    public $GIF_bfseek = 0;
    public $GIF_screen = Array();
    public $GIF_global = Array();
    public $GIF_sorted;
    public $GIF_colorS;
    public $GIF_colorC;
    public $GIF_colorF;

    function gifdecoder($GIF_pointer) {
        $this->GIF_stream = $GIF_pointer;

        gifdecoder::GIFGetByte(6); // GIF89a
        gifdecoder::GIFGetByte(7); // Logical Screen Descriptor


        $this->GIF_screen = $this->GIF_buffer;
        $this->GIF_colorF = $this->GIF_buffer [4] & 0x80 ? 1 : 0;
        $this->GIF_sorted = $this->GIF_buffer [4] & 0x08 ? 1 : 0;
        $this->GIF_colorC = $this->GIF_buffer [4] & 0x07;
        $this->GIF_colorS = 2 << $this->GIF_colorC;

        if ($this->GIF_colorF == 1) {
            gifdecoder::GIFGetByte(3 * $this->GIF_colorS);
            $this->GIF_global = $this->GIF_buffer;
        }

        for ($cycle = 1; $cycle;) {
            if (gifdecoder::GIFGetByte(1)) {
                switch ($this->GIF_buffer [0]) {
                    case 0x21:
                        gifdecoder::GIFReadExtensions();
                        break;
                    case 0x2C:
                        gifdecoder::GIFReadDescriptor();
                        break;
                    case 0x3B:
                        $cycle = 0;
                        break;
                }
            } else {
                $cycle = 0;
            }
        }
    }

    function GIFReadExtensions() {
        gifdecoder::GIFGetByte(1);
        for (;;) {
            gifdecoder::GIFGetByte(1);
            if (( $u = $this->GIF_buffer [0] ) == 0x00) {
                break;
            }
            gifdecoder::GIFGetByte($u);

            if ($u == 4) {
                $this->GIF_delays [] = ( $this->GIF_buffer [1] | $this->GIF_buffer [2] << 8 );
            }
        }
    }

    function GIFReadDescriptor() {
        $GIF_screen = Array();

        gifdecoder::GIFGetByte(9);
        $GIF_screen = $this->GIF_buffer;

        $this->GIF_offset [] = Array(( $this->GIF_buffer [0] | $this->GIF_buffer [1] << 8 ), ( $this->GIF_buffer [2] | $this->GIF_buffer [3] << 8 ));
        $GIF_colorF = $this->GIF_buffer [8] & 0x80 ? 1 : 0;
        if ($GIF_colorF) {
            $GIF_code = $this->GIF_buffer [8] & 0x07;
            $GIF_sort = $this->GIF_buffer [8] & 0x20 ? 1 : 0;
        } else {
            $GIF_code = $this->GIF_colorC;
            $GIF_sort = $this->GIF_sorted;
        }
        $GIF_size = 2 << $GIF_code;
        $this->GIF_screen [4] &= 0x70;
        $this->GIF_screen [4] |= 0x80;
        $this->GIF_screen [4] |= $GIF_code;
        if ($GIF_sort) {
            $this->GIF_screen [4] |= 0x08;
        }
        $this->GIF_string = "GIF87a";
        gifdecoder::GIFPutByte($this->GIF_screen);
        if ($GIF_colorF == 1) {
            gifdecoder::GIFGetByte(3 * $GIF_size);
            gifdecoder::GIFPutByte($this->GIF_buffer);
        } else {
            gifdecoder::GIFPutByte($this->GIF_global);
        }
        $this->GIF_string .= chr(0x2C);
        $GIF_screen [8] &= 0x40;
        gifdecoder::GIFPutByte($GIF_screen);
        gifdecoder::GIFGetByte(1);
        gifdecoder::GIFPutByte($this->GIF_buffer);
        for (;;) {
            gifdecoder::GIFGetByte(1);
            gifdecoder::GIFPutByte($this->GIF_buffer);
            if (( $u = $this->GIF_buffer [0] ) == 0x00) {
                break;
            }
            gifdecoder::GIFGetByte($u);
            gifdecoder::GIFPutByte($this->GIF_buffer);
        }
        $this->GIF_string .= chr(0x3B);
        $this->GIF_arrays [] = $this->GIF_string;
    }

    function GIFGetByte($len) {
        $this->GIF_buffer = Array();

        for ($i = 0; $i < $len; $i++) {
            if ($this->GIF_bfseek > strlen($this->GIF_stream)) {
                return 0;
            }
            $this->GIF_buffer [] = ord($this->GIF_stream { $this->GIF_bfseek++});
        }
        return 1;
    }

    function GIFPutByte($bytes) {
        for ($i = 0; $i < count($bytes); $i++) {
            $this->GIF_string .= chr($bytes [$i]);
        }
    }

    function GIFGetFrames() {
        return ( $this->GIF_arrays );
    }

    function GIFGetDelays() {
        return ( $this->GIF_delays );
    }

    function GIFGetOffset() {
        return ( $this->GIF_offset );
    }

}
