<?php

#усечение строки

function utf8_substr($str, $len, $dot = 1, $start = 0) {
    if (utf8_strlen($str) > $len) {
        if (USE_MBSTRING) {
            $str = mb_substr($str, $start, $len);
        } elseif (USE_ICONV) {
            $str = iconv_substr($str, $start, $len);
        } else {
            $out = substr($str, $start, $len);
        } // могут появиться нечитаемые символы
        if ($dot) {
            $str.=' ...';
        }
    }
    return $str;
}

#Умная обрезка строки

function cutStr($str, $lenght = 100, $end = '...', $charset = 'UTF-8', $token = '~') {
    $str = strip_tags($str);
    if (mb_strlen($str, $charset) >= $lenght) {
        $wrap = wordwrap($str, $lenght, $token);
        $str_cut = mb_substr($wrap, 0, mb_strpos($wrap, $token, 0, $charset), $charset);
        return $str_cut .= $end;
    } else {
        return $str;
    }
}
