

CREATE TABLE IF NOT EXISTS `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(32) NOT NULL,
  `pass` varchar(32) NOT NULL,
  `pass_time` int(11) DEFAULT '0',
  `sess` varchar(32) DEFAULT NULL,
  `activation` varchar(32) DEFAULT NULL,
  `ban` int(11) NOT NULL DEFAULT '0',
  `ban_pr` varchar(64) DEFAULT NULL,
  `ip` bigint(20) NOT NULL DEFAULT '0',
  `ip_cl` bigint(20) NOT NULL DEFAULT '0',
  `ip_xff` bigint(20) NOT NULL DEFAULT '0',
  `ua` varchar(32) DEFAULT NULL,
  `browser` varchar(3) DEFAULT 'wap', 
  `us_browser` varchar(99) NOT NULL,
  `region` varchar(32) NOT NULL,
  `date_reg` int(11) NOT NULL DEFAULT '0',
  `date_aut` int(11) NOT NULL DEFAULT '0',
  `date_last` int(11) NOT NULL DEFAULT '0',
  `sort` int(1) DEFAULT '0',
  `diary_desc` text,
  `diary_time` int(11) DEFAULT NULL,
  `diary_text` varchar(10024) DEFAULT NULL,
  `ncolor` varchar(10) NOT NULL,
  `ncolor2` varchar(10) NOT NULL,
  `adm_set` enum('1','2') DEFAULT '1',
  `do_cmpl` enum('1','0') DEFAULT '1',
  `do_cmpl_diary` enum('1','0') DEFAULT '1',
  `online` varchar(7) DEFAULT 'online',
  `write_diary` enum('1','0') DEFAULT '1',
  `money` int(11) NOT NULL DEFAULT '0',
  `activity` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `chat_mess` int(11) NOT NULL DEFAULT '0',
  `forum_mess` int(11) NOT NULL DEFAULT '0',
  `forum_them` int(11) NOT NULL DEFAULT '0',
  `panel` int(2) DEFAULT '11',
  `viewing` int(11) NOT NULL DEFAULT '0',
  `wall_password` mediumtext,
  `wall_access` enum('all','only_me','friends','pass','auth') DEFAULT 'all',
  `wall_komm` enum('all','only_me','friends') DEFAULT 'all',
  `wall_nokomm` enum('0','1') NOT NULL DEFAULT '1',
  `profile_access` enum('all','only_me','friends','pass') DEFAULT 'all',
  `profile_password` varchar(128) DEFAULT NULL,
  `anketa_password` varchar(128) DEFAULT NULL,
  `anketa_access` enum('all','only_me','friends','pass') DEFAULT 'all',
  `friends_access` enum('all','only_me','friends','pass') DEFAULT 'all',
  `friends_password` varchar(128) DEFAULT NULL,
  `friendship` enum('0','1') NOT NULL DEFAULT '0',
  `level` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `group_access` int(10) unsigned NOT NULL DEFAULT '0',
  `sex` enum('0','1') NOT NULL DEFAULT '1',
  `url` varchar(64) NOT NULL DEFAULT '/',
  `show_foot` enum('on','off') DEFAULT 'on',
  `ank_g_r` int(4) DEFAULT NULL,
  `ank_m_r` int(2) DEFAULT NULL,
  `ank_d_r` int(2) DEFAULT NULL,
  `ank_d_r_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_g_r_private` enum('all','only_me','friends') DEFAULT 'all',
  `preference` enum('0','1','2','3') NOT NULL DEFAULT '0',
  `preference_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_about_me` varchar(512) DEFAULT NULL,
  `ank_about_me_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_inter_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_lub_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_posit_private` enum('all','only_me','friends') DEFAULT 'all',
  `welcome` varchar(150) NOT NULL DEFAULT '',
  `user_url` varchar(20) NOT NULL DEFAULT 'u-s-er12_453_00-4',
  `ank_name` varchar(100) DEFAULT NULL,
  `ank_surname` varchar(100) DEFAULT NULL,
  `ank_patronymic` varchar(100) DEFAULT NULL,
  `ank_name_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_political` enum('0','1','2','3','4','5','6','7','8','9') NOT NULL DEFAULT '0',
  `ank_world_view` enum('0','1','2','3','4','5','6','7','8','9') NOT NULL DEFAULT '0',
  `ank_important_life` enum('0','1','2','3','4','5','6','7','8') NOT NULL DEFAULT '0',
  `ank_important_people` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0',
  `ank_smoking` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  `ank_alcohol` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  `ank_inspiration` varchar(512) NOT NULL,
  `ank_activities` varchar(512) DEFAULT NULL,
  `ank_music` varchar(512) DEFAULT NULL,
  `ank_teleshow` varchar(512) DEFAULT NULL,
  `ank_games` varchar(512) DEFAULT NULL,
  `ank_citates` varchar(512) DEFAULT NULL,
  `ank_films` varchar(512) DEFAULT NULL,
  `ank_books` varchar(512) DEFAULT NULL,
  `ank_course` varchar(512) DEFAULT NULL,
  `ank_passion` varchar(512) DEFAULT NULL,
  `work_company` varchar(200) DEFAULT NULL,
  `work_city` varchar(100) DEFAULT NULL,
  `work_position` varchar(200) DEFAULT NULL,
  `work_description` varchar(512) DEFAULT NULL,
  `work_private` enum('all','only_me','friends') DEFAULT 'all',
  `skill` varchar(200) NOT NULL,
  `skill_private` enum('all','only_me','friends') DEFAULT 'all',
  `university` varchar(200) DEFAULT NULL,
  `university_spec` varchar(100) DEFAULT NULL,
  `university_spec2` varchar(100) DEFAULT NULL,
  `university_spec3` varchar(100) DEFAULT NULL,
  `university_description` varchar(512) DEFAULT NULL,
  `university_on` enum('1','2') DEFAULT '1',
  `university_student` enum('1','2') DEFAULT '1',
  `university_private` enum('all','only_me','friends') DEFAULT 'all',
  `school` varchar(200) NOT NULL,
  `school_description` varchar(512) DEFAULT NULL,
  `school_on` enum('1','2') DEFAULT '1',
  `school_year` int(4) DEFAULT NULL,
  `school_year_end` int(4) DEFAULT NULL,
  `school_private` enum('all','only_me','friends') DEFAULT 'all',
  `city` text DEFAULT NULL,
  `city_private` enum('all','only_me','friends') DEFAULT 'all',
  `city_native` text DEFAULT NULL,
  `city_native_private` enum('all','only_me','friends') DEFAULT 'all',
  `country` varchar(32) NOT NULL,
  `ank_marriage` enum('0','1','2','3','4','5','6','7','8','9','10','11','12') NOT NULL DEFAULT '0',
  `ank_marriage_private` enum('all','only_me','friends') DEFAULT 'all',
  `site` text DEFAULT NULL,
  `site2` text DEFAULT NULL,
  `site3` text DEFAULT NULL,
  `site_private` enum('all','only_me','friends') DEFAULT 'all',
  `site2_private` enum('all','only_me','friends') DEFAULT 'all',
  `site3_private` enum('all','only_me','friends') DEFAULT 'all',
  `vk` text DEFAULT NULL,
  `vk_private` enum('all','only_me','friends') DEFAULT 'all',
  `instagram` text DEFAULT NULL,
  `instagram_private` enum('all','only_me','friends') DEFAULT 'all',
  `facebook` text DEFAULT NULL,
  `facebook_private` enum('all','only_me','friends') DEFAULT 'all',
  `twitter` text DEFAULT NULL,
  `twitter_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_mail` varchar(32) DEFAULT NULL,
  `ank_mail_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_n_tel` varchar(12) DEFAULT NULL,
  `ank_n_tel_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_n_tel_home` varchar(12) DEFAULT NULL,
  `ank_n_tel_home_private` enum('all','only_me','friends') DEFAULT 'all',
  `ank_n_tel_work` varchar(12) DEFAULT NULL,
  `ank_n_tel_work_private` enum('all','only_me','friends') DEFAULT 'all',
  `colorbp` varchar(16) NOT NULL DEFAULT 'fff',
  `colorbs` varchar(16) NOT NULL DEFAULT '282b36',
  `colornp` varchar(16) NOT NULL,
  `colorfp` varchar(16) NOT NULL DEFAULT '282b36',
  `colorlp` varchar(16) NOT NULL DEFAULT 'ffffff',
  `color_count` varchar(16) NOT NULL DEFAULT '5bc0de',
  `profileCover` int(11) DEFAULT '0',
  `time_on` int(11) NOT NULL,
  `icon_size` enum('0','1','2') DEFAULT '0',
  `icon_panel_left` varchar(32) DEFAULT 'user',
  `icon_panel_right` varchar(32) DEFAULT 'sliders',
  `set_forum` enum('0','1') DEFAULT '1',
  `set_icon_panel` enum('0','1') DEFAULT '1',
  `set_diary` enum('0','1') DEFAULT '1',
  `set_online` enum('0','1','2','3','4','5') DEFAULT '1',
  `set_online_view` enum('1','2','3','4','5') DEFAULT '1',
  `set_online_size` int(11) DEFAULT '36',
  `set_mail` enum('1','2') DEFAULT '1',
  `set_p_str` int(11) DEFAULT '7',
  `set_chat_str` int(11) DEFAULT '7',
  `set_files_str` int(11) DEFAULT '7',
  `set_forum_str` int(11) DEFAULT '3',
  `set_diary_str` int(11) DEFAULT '3',
  `set_times` enum('1','0') NOT NULL DEFAULT '1',
  `set_date` enum('1','0') NOT NULL DEFAULT '1',
  `set_files` enum('0','1') NOT NULL DEFAULT '0',
  `set_files_include` enum('0','1') NOT NULL DEFAULT '0',
  `set_timesdvig` int(11) NOT NULL DEFAULT '0',
  `set_menu` enum('1','0') DEFAULT '1',
  `set_search` enum('1','0') DEFAULT '1',
  `set_profile` enum('1','0') DEFAULT '1',
  `set_news` enum('1','2') DEFAULT '1',
  `set_news_images` enum('1','2') DEFAULT '1',
  `set_news_comments` enum('0','1') DEFAULT '1',
  `set_news_to_mail` enum('0','1') NOT NULL DEFAULT '0',
  `set_chat` enum('1','0') DEFAULT '1',
  `meteo_country` int(11) NOT NULL DEFAULT '0',
  `autorization` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `perehodu` int(11) NOT NULL,
  `lang` varchar(32) DEFAULT 'ru',
  `hash` varchar(99) DEFAULT NULL,
  `hash_set` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `url` (`url`)
) ENGINE=MYISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `privat_mail` int(11) DEFAULT '1',
  `email_on` int(1) DEFAULT '1',
  `email_spam` int(1) DEFAULT '1',
  `ocenka` int(11) DEFAULT '0',
  `ocenka_time` int(11) NOT NULL,
  `ocenka_user` int(11) NOT NULL,
  `ocenka_stav` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ocenka_user` (`ocenka_user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `user_collision` (
  `id_user` int(11) NOT NULL,
  `id_user2` int(11) NOT NULL,
  `type` set('sess','ip_ua_time') NOT NULL default 'sess',
  KEY `id_user` (`id_user`,`id_user2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_group` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(32) NOT NULL,
  `level` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

INSERT INTO `user_group` (`id`, `name`, `level`) VALUES
(1, 'Пользователь', 0),
(2, 'Администратор', 9),
(15, 'Создатель', 10);


CREATE TABLE IF NOT EXISTS `user_group_access` (
  `id_group` int(10) unsigned NOT NULL,
  `id_access` varchar(32) NOT NULL,
  KEY `id_group` (`id_group`,`id_access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `user_group_access` (`id_group`, `id_access`) VALUES
(15, 'adm_games'),
(15, 'adm_accesses'),
(15, 'adm_banlist'),
(15, 'adm_ban_ip'),
(15, 'adm_changelog'),
(15, 'adm_chmod'),
(15, 'adm_conf_server'),
(15, 'adm_forum_sinc'),
(15, 'adm_info'),
(15, 'adm_ip_edit'),
(15, 'adm_log_delete'),
(15, 'adm_log_read'),
(15, 'adm_menu'),
(15, 'adm_mysql'),
(15, 'adm_news'),
(15, 'adm_news_add'),
(15, 'adm_news_delete'),
(15, 'adm_news_delete_comments'),
(15, 'adm_news_edit'),
(15, 'adm_panel_show'),
(15, 'adm_profile'),
(15, 'adm_ref'),
(15, 'adm_rekl'),
(15, 'adm_rekl_black_list'),
(15, 'adm_send_mess'),
(15, 'adm_send_money'),
(15, 'adm_send_not'),
(15, 'adm_set_foto'),
(15, 'adm_set_forum'),
(15, 'adm_set_loads'),
(15, 'adm_set_sys'),
(15, 'adm_set_user'),
(15, 'adm_show_adm'),
(15, 'adm_statistic'),
(15, 'adm_themes'),
(15, 'adm_umenu'),
(15, 'adm_cron'),
(15, 'blog_edit'),
(15, 'blog_delete'),
(15, 'blog_cat'),
(15, 'chat_clear'),
(15, 'chat_del'),
(15, 'chat_set'),
(15, 'forum_for_create'),
(15, 'forum_for_delete'),
(15, 'forum_for_edit'),
(15, 'forum_post_close'),
(15, 'forum_post_ed'),
(15, 'forum_razd_create'),
(15, 'forum_razd_edit'),
(15, 'forum_them_del'),
(15, 'forum_them_edit'),
(15, 'foto_alb_del'),
(15, 'foto_foto_edit'),
(15, 'foto_foto_komm_del'),
(15, 'guest_show_ip'),
(15, 'loads'),
(15, 'loads_file'),
(15, 'loads_dir_create'),
(15, 'loads_dir_delete'),
(15, 'loads_dir_mesto'),
(15, 'loads_dir_rename'),
(15, 'loads_file_delete'),
(15, 'loads_file_edit'),
(15, 'loads_file_scr'),
(15, 'loads_file_scrr'),
(15, 'loads_file_scrg'),
(15, 'loads_file_scrj'),
(15, 'loads_file_scrp'),
(15, 'loads_file_import'),
(15, 'loads_file_upload'),
(15, 'user_group'),
(15, 'user_ban_set'),
(15, 'user_ban_set_h'),
(15, 'user_ban_unset'),
(15, 'user_change_group'),
(15, 'user_change_nick'),
(15, 'user_collisions'),
(15, 'user_delete'),
(15, 'user_mass_delete'),
(15, 'user_prof_edit'),
(15, 'user_show_add_info'),
(15, 'user_show_ip'),
(15, 'user_show_ua');


CREATE TABLE IF NOT EXISTS `user_ref` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `url` varchar(1024) DEFAULT NULL,
  `type_input` varchar(12) DEFAULT 'cookie',
  PRIMARY KEY (`id`),
  KEY `time` (`time`,`id_user`),
  KEY `type_input` (`type_input`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_referals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `id_ref` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_log` (
  `id` int(11) NOT NULL auto_increment,
  `id_user` int(11) NOT NULL ,
  `method` set('1','0') NOT NULL default '0',
  `time` int(11) NOT NULL ,
  `ip` bigint(20) NOT NULL default '0',
  `ua` varchar(32) default NULL,
  PRIMARY KEY  (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_icon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_icon` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_voice2` (
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `rating` int(11) NOT NULL default '0',
  KEY `id_user` (`id_user`,`id_kont`),
  KEY `rating` (`rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_to` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `forever` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

