<?php

/* DCMS Special
 * Дата последнего редактирования 09.10.2016
 * Модифицировал densnet
 */

foreach (array('start', 'compress', 'sess', 'settings', 'db_connect', 'ipua', 'fnc', 'user') as $inc) {
    require_once "../../sys/inc/$inc.php";
}

$set['title'] = lang('Блоги - Поиск по меткам'); // заголовок страницы
require_once H . 'sys/inc/thead.php';

aut();
err();

#Навигация
echo "<div class='list-group-item-null list-group-item-grey'><small>";
echo "<a href='/' class='hint--right' data-hint='" . lang('На главную') . "'><i class='fa fa-home fa-lg'></i></a> <i class='fa fa-angle-right fa-fw'></i> ";
echo "<a href='/modules/diary/'>" . lang('Блоги') . "</a> <i class='fa fa-angle-right fa-fw'></i> ";
echo lang('Поиск по меткам');
echo "</small></div>";

$tag = NULL;
if (isset($_SESSION['tag'])) {
    $tag = $_SESSION['tag'];
}
if (isset($_GET['tag'])) {
    $tag = esc(urldecode($_GET['tag']));
}
$_SESSION['tag'] = $tag;

$tag = preg_replace("#( ){2,}#", " ", $tag);
$tag = preg_replace("#^( ){1,}|( ){1,}$#", "", $tag);


if ($tag != NULL) {

    $q_tag = str_replace('%', '', $tag);
    $q_tag = str_replace(' ', '%', $q_tag);
    $q_tag = str_replace(',', '%', $q_tag);

    $k_post = $db->super_query("SELECT COUNT(*) as count FROM `diary` WHERE `tags` like '%" . $db->safesql($q_tag) . "%'");
    $k_page = k_page($k_post['count'], $set['p_str']);
    $page = page($k_page);
    $start = $set['p_str'] * $page - $set['p_str'];

    if ($k_post['count'] == 0) {
        echo "<br />";
        $doc->NoResult();
    } else {
        echo "<div class='list-group-item-null-mini'><div class='left_text'>" . lang('Найденные результаты') . "</div>";

        echo "<div class='hr'></div></div>";
    }
    $tags = $db->query("SELECT * FROM `diary` WHERE `tags` like '%" . $db->safesql($q_tag) . "%' ORDER BY `id` DESC LIMIT $start, $set[p_str]");

    while ($result = $tags->fetch_object()) {
        $result->tags = str_replace("$tag", "<span style='color:red'>$tag</span>", $result->tags);

        $razdel = $db->query("SELECT * FROM `diary_cat` WHERE `id` = '$result->id_cat' LIMIT 1");
        $razdel = $razdel->fetch_object();
        $ank = get_user($result->id_user);

        echo '<div class="list-group-item-null-mini list-group-item-grey dop">';
        echo "<a href='/modules/diary/$result->name/'><i class='fa fa-book fa-fw'></i> $result->name</a> <small class='right grey'>" . date::timek($result->time) . "</small><br />";

        if ($result->tags != null) {
            echo '<small class="grey"><i class="fa fa-tags fa-fw"></i> ' . $result->tags . '</small><br />';
        }
        echo '<small>';
        echo "<span class='grey right'><i class='fa fa-user fa-fw'></i> $ank[nick]</span>";
        echo '<i class="fa fa-folder fa-fw"></i> <a href="index.php?r=' . $razdel->id . '">' . $razdel->name . '</a> &#183; ';
        echo '<i class="fa fa-eye fa-fw"></i> ' . $result->viewings . ' &#183; ';
        echo '<i class="fa fa-thumbs-up fa-fw"></i> ' . $result->rating . '<br/>';
        echo '</small></div>';
    }

    if ($k_page > 1) {
        str("?", $k_page, $page);
    }
} else {
    echo '<div class="list-group-item-null-mini list-group-item-grey dop">';
    echo lang('Введите метку для поиска');
    echo '</div>';
}

echo '<form method="get" action="?" class="list-group-item-null-mini">';
$tag = stripcslashes(htmlspecialchars($tag));
$doc->Input('tag', 'Метки', 54, "$tag", 'form-control', 'text', 'required');
echo "<br />";
$doc->Button('btn btn-success btn-sm', null, 'search', 'Поиск');
echo '</form>';

require_once H . 'sys/inc/tfoot.php';
