<?php

# SocCMS Ред 24.10.2016

foreach (array('start', 'compress', 'sess', 'settings', 'db_connect', 'ipua', 'fnc', 'adm_check', 'user') as $inc) {
    require_once "../sys/inc/$inc.php";
}

access('adm_menu', null, 'index.php?' . SID);
adm_check();

$set['title'] = lang('Левое меню');

require_once H . 'sys/inc/thead.php';

aut();
err();

$act = (isset($_GET['act'])) ? htmlspecialchars($_GET['act']) : null;

switch ($act) {
    default:
        #Навигация
        $nav = new nav();
        $nav->start();
        $nav->a('/', 'nav-link', 'home fa-lg ');
        $nav->a('?act=add', 'nav-link btn btn-secondary btn-sm', 'plus', 'Добавить пункт');
        $nav->dropdown('navig', 'btn btn-secondary btn-sm', 0, 'Еще');
        $nav->dropdown_a("" . DIR_PANEL . "", 'dropdown-item', 'th', 'Панель управления');
        $nav->dropdown_end();
        $nav->end();

        if (isset($_GET['id']) && isset($_GET['act'])) {
            $menu = $db->super_query("SELECT COUNT(*) as count FROM `menu` WHERE `id` = '" . intval($_GET['id']) . "'");
            if ($menu['count']) {
                $menu = $db->query("SELECT * FROM `menu` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");
                $menu = $menu->fetch_object();
            }

            if ($_GET['act'] == 'up') {
                $db->query("UPDATE `menu` SET `pos` = '" . ($menu->pos) . "' WHERE `pos` = '" . ($menu->pos - 1) . "' LIMIT 1");
                $db->query("UPDATE `menu` SET `pos` = '" . ($menu->pos - 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

                $_SESSION['message'] = lang('Изменения сохранены');
                header("Location: ?");
            }
            if ($_GET['act'] == 'down') {
                $db->query("UPDATE `menu` SET `pos` = '" . ($menu->pos) . "' WHERE `pos` = '" . ($menu->pos + 1) . "' LIMIT 1");
                $db->query("UPDATE `menu` SET `pos` = '" . ($menu->pos + 1) . "' WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");

                $_SESSION['message'] = lang('Изменения сохранены');
                header("Location: ?");
            }
            if ($_GET['act'] == 'del') {
                $db->query("DELETE FROM `menu` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");
                $_SESSION['message'] = lang('Пункт успешно удален');
                header("Location: ?");
            }
        }

        $k_post = $db->super_query("SELECT COUNT(*) as count FROM menu");

        if ($k_post['count'] == 0) {
            $doc->NoResult();
        }

        $menu = $db->query("SELECT * FROM menu ORDER BY pos ASC");
        while ($post = $menu->fetch_object()) {
            echo "<div class='list-group-item-null-mini list-group-item-grey dop'>";
            echo "<div class='btn-group right'>";
            echo "<a class='btn btn-sm' data-toggle='dropdown'><i class='fa fa-chevron-down'></i></a>";
            echo "<div class='dropdown-menu dropdown-menu-right'>";

            $doc->a("?act=edit&amp;id=$post->id", 'dropdown-item', 'edit', 'Редактировать');
            $doc->a("?id=$post->id&amp;act=del", 'dropdown-item', 'trash-o', 'Удалить');
            $doc->a("?id=$post->id&amp;act=up", 'dropdown-item', 'arrow-up', 'Выше');
            $doc->a("?id=$post->id&amp;act=down", 'dropdown-item', 'arrow-down', 'Ниже');

            echo "</div>";
            echo "</div>";

            echo icons($post->icon) . " $post->name<br />";

            echo "<small class='grey'>";
            echo lang('Тип') . ": " . ($post->type == 'link' ? lang('Ссылка') : lang('Раздел'));
            if ($post->type == 'link') {
                echo " - ($post->url)";
            }
            echo "<br />" . lang('Счетчик') . ": " . ($post->counter == null ? lang('отсутствует') : $post->counter) . "";
            echo "</small>\n";
            echo "</div>\n";
        }
        break;

    #Добавляем новый пункт
    case 'add':
        if (isset($_POST['add']) && isset($_POST['name']) && $_POST['name'] != NULL) {
            $name = $db->safesql($_POST['name']);
            $url = $db->safesql($_POST['url']);
            $counter = $db->safesql($_POST['counter']);
            $pos = $db->query("SELECT MAX(pos) FROM menu")->fetch_row();
            $pos = $pos[0] + 1;
            $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);

            if (in_array($_POST['type'], array('link', 'razd'))) {
                $type = $_POST['type'];
            } else {
                $type = 'link';
            }

            $db->query("INSERT INTO menu (name, url, counter, pos, icon, type) VALUES ('$name', '$url', '$counter', '$pos', '$icon', '$type')");

            $_SESSION['message'] = lang('Пункт успешно добавлен');
            header("Location: menu.php?");
        }

        #Навигация
        $nav = new nav();
        $nav->start();
        $nav->a('/', 'nav-link', 'home fa-lg ');
        $nav->a('menu.php?', 'nav-link btn btn-secondary btn-sm', 'arrow-left', 'Вернуться');
        $nav->dropdown('navig', 'btn btn-secondary btn-sm', 0, 'Еще');
        $nav->dropdown_a("" . DIR_PANEL . "", 'dropdown-item', 'th', 'Панель управления');
        $nav->dropdown_end();
        $nav->end();

        echo "<form action='?act=add' class='list-group-item-null-mini' method='post'>";

        $doc->Input('name', 'Название');
        $doc->Input('url', 'Ссылка');
        $doc->Input('counter', 'Счетчик');
        echo lang('Иконка') . "<br />";
        echo "<div class='input-group'><input value='list' type='text' name='icon' class='form-control'>";
        echo "<span class='input-group-addon'><i class='fa fa-list fa-fw'></i></span>";
        echo "</div>";

        echo lang('Тип') . ":<br />";
        echo "<select name='type' class='custom-select'>";
        echo "<option value='link'>" . lang('Ссылка') . "</option>";
        echo "<option value='razd'>" . lang('Раздел') . "</option>";
        echo "</select><br />";

        echo "<br /><a href='http://fontawesome.io/icons/'><i class='fa fa-fa fa-fw'></i> <b>" . lang('Список иконок') . "</b></a><br /><br />";

        $doc->Button('btn btn-primary btn-sm', 'add', 'plus', 'Добавить');
        $doc->a("menu.php?", 'btn btn-secondary btn-sm', null, 'Отмена');

        echo "</form>";

        break;

    #Редактируем пункт
    case 'edit':
        $menu = $db->super_query("SELECT COUNT(*) as count FROM `menu` WHERE `id` = '" . intval($_GET['id']) . "'");
        if ($menu['count']) {
            $menu = $db->query("SELECT * FROM `menu` WHERE `id` = '" . intval($_GET['id']) . "' LIMIT 1");
            $menu = $menu->fetch_object();
        }

        if (isset($_POST['save']) && isset($_GET['id']) && isset($_POST['name']) && $_POST['name'] != NULL) {
            $id = intval($_GET['id']);
            $name = $db->safesql($_POST['name']);
            $url = $db->safesql($_POST['url']);
            $counter = $db->safesql($_POST['counter']);
            $icon = preg_replace('#[^a-z0-9 _\-\.]#i', null, $_POST['icon']);

            if (in_array($_POST['type'], array('link', 'razd'))) {
                $type = $_POST['type'];
            } else {
                $type = 'link';
            }

            $db->query("UPDATE `menu` SET `name` = '$name', `url` = '$url', `counter` = '$counter', `icon` = '$icon', `type` = '$type' WHERE `id` = '$id' LIMIT 1");
            $_SESSION['message'] = lang('Изменения сохранены');
            header("Location: menu.php?");
        }

        #Навигация
        $nav = new nav();
        $nav->start();
        $nav->a('/', 'nav-link', 'home fa-lg ');
        $nav->a('menu.php?', 'nav-link btn btn-secondary btn-sm', 'arrow-left', 'Вернуться');
        $nav->dropdown('navig', 'btn btn-secondary btn-sm', 0, 'Еще');
        $nav->dropdown_a("" . DIR_PANEL . "", 'dropdown-item', 'th', 'Панель управления');
        $nav->dropdown_end();
        $nav->end();

        echo "<form class='list-group-item-null-mini' action='?act=edit&amp;id=$menu->id' method='post'>";

        $doc->Input('name', 'Название', 200, "$menu->name");
        $doc->Input('url', 'Ссылка', 200, "$menu->url");
        $doc->Input('counter', 'Счетчик', 200, "$menu->counter");

        echo lang('Иконка') . "<br />";
        echo "<div class='input-group'><input value='$menu->icon' type='text' name='icon' class='form-control'>";
        echo "<span class='input-group-addon'><i class='fa fa-$menu->icon fa-fw'></i></span>";
        echo "</div>";
        echo lang('Тип') . ":<br />";
        echo "<select name='type' class='custom-select'>";
        echo "<option value='link' " . ($menu->type == 'link' ? "selected" : null) . ">" . lang('Ссылка') . "</option>";
        echo "<option value='razd' " . ($menu->type == 'link' ? null : "selected") . ">" . lang('Раздел') . "</option>";
        echo "</select><br />";

        echo "<br /><a href='http://fontawesome.io/icons/'><i class='fa fa-fa fa-fw'></i> <b>" . lang('Список иконок') . "</b></a><br /><br />";

        $doc->Button('btn btn-success btn-sm', 'save', 'save', 'Сохранить');
        $doc->a("menu.php?", 'btn btn-secondary btn-sm', null, 'Отмена');

        echo "</form>";

        break;
}
require_once H . 'sys/inc/tfoot.php';
