<?php

# SocCMS Ред 24.10.2016

require_once '../sys/inc/start.php';
require_once H . 'sys/inc/compress.php';
require_once H . 'sys/inc/sess.php';
require_once H . 'sys/inc/settings.php';
$temp_set = $set;
require_once H . 'sys/inc/db_connect.php';
require_once H . 'sys/inc/ipua.php';
require_once H . 'sys/inc/fnc.php';
require_once H . 'sys/inc/adm_check.php';
require_once H . 'sys/inc/user.php';

access('adm_set_sys', null, 'index.php?' . SID);
adm_check();

$set['title'] = lang('Настройки системы');
require_once H . 'sys/inc/thead.php';

if (isset($_POST['save'])) {

    $temp_set['show_err_php'] = (isset($_POST['show_err_php']) && $_POST['show_err_php']);
    $temp_set['antidos'] = (isset($_POST['antidos']) && $_POST['antidos']);
    $temp_set['antimat'] = (isset($_POST['antimat']) && $_POST['antimat']);
    $temp_set['meta_keywords'] = esc($_POST['meta_keywords']);
    $temp_set['meta_description'] = esc($_POST['meta_description']);
    $temp_set['title'] = esc(stripcslashes(htmlspecialchars($_POST['title'])), 1);
    $temp_set['currency'] = htmlspecialchars($_POST['currency']);
    $temp_set['currency_icon'] = htmlspecialchars($_POST['currency_icon']);
    $db->query("ALTER TABLE `user` CHANGE `set_p_str` `set_p_str` INT(11) DEFAULT '$temp_set[p_str]'");

    if (save_settings($temp_set)) {
        admin_log('Настройки', 'Система', 'Изменение системных настроек');
        $_SESSION['message'] = lang('Изменения сохранены');

        header("Location: ?");
        exit();
    } else {
        $err = lang('Нет прав для изменения файла настроек');
    }
}

aut();
err();

#Навигация
$nav = new nav();
$nav->start();
$nav->a('/', 'nav-link', 'home fa-lg ');
$nav->a("" . DIR_PANEL . "", 'nav-link btn btn-secondary btn-sm', 'th', 'Панель управления');
$nav->end();

echo "<form method='post' class='list-group-item-null' action='?'>";

$doc->Input('title', 'Название сайта', 50, "$temp_set[title]");
$doc->Textarea('meta_keywords', 'Ключевые слова META', 100, "$temp_set[meta_keywords]");
$doc->Textarea('meta_description', 'Описание META', 100, "$temp_set[meta_description]");

$doc->Checkbox('antidos', 'Анти-Dos', 1, "" . ($temp_set['antidos'] ? " checked='checked'" : null) . "");
$doc->Checkbox('antimat', 'Анти-Мат', 1, "" . ($temp_set['antimat'] ? " checked='checked'" : null) . "");
$doc->Checkbox('show_err_php', 'Ошибки интерпретатора', 1, "" . ($temp_set['show_err_php'] ? " checked='checked'" : null) . "");

$doc->Input('currency', 'Валюта сайта', 100, "$temp_set[currency]");
echo lang('Иконка валюты') . "<br />";
echo "<div class='input-group'><input value='$temp_set[currency_icon]' type='text' name='currency_icon' class='form-control'>";
echo "<span class='input-group-addon'><i class='fa fa-$temp_set[currency_icon] fa-fw'></i></span>";
echo "</div>";

echo "<br />";

echo "* Анти-Dos - защита от частых запросов с одного IP-адреса<br />\n";
$doc->Button('btn btn-success btn-sm', 'save', 'save', 'Сохранить');
echo "</form>\n";

require_once H . 'sys/inc/tfoot.php';
