<?php

function toOutput($str, $br = 1, $html = 1, $smiles = 1, $links = 1, $bbcode = 1) {

    if ($html) {
        $str = htmlentities($str, ENT_QUOTES, 'UTF-8');
    } // преобразуем все к нормальному перевариванию браузером
    if ($links) {
        $str = links($str);
    } // обработка ссылок
    if ($bbcode) {
        $tmp_str = $str;
        $str = bbcode($str); // обработка bbcode
    }

    if ($smiles && $tmp_str == $str) {
        $str = smiles($str);
    } // вставка смайлов
    // преобразование ссылок в тег URL
    $str = preg_replace('#(^|\s|\(|\])([a-z]+://([^ \r\n\t`\'"<]+))(,|\[|<|\s|$)#iuU', '\1[url="\2"]\2[/url]\4', $str);
    // обработка старых цитат с числом в теге
    $str = preg_replace('#\[(/?)quote_([0-9]+)(\]|\=)#ui', '[\1quote\3', $str);

    // преобразование ссылки на youtube ролик в BBCode
    $str = preg_replace('#(^|\s|\(|\])((https?://)?www\.youtube\.com/watch\?(.*?&)*v=([^ \r\n\t`\'"<]+))(,|\[|<|\s|$)#iuU', '\1[youtube]\5[/youtube]\6', $str);

    // видео vk.com
    $str = preg_replace('#<iframe src="http://vk\.com/video_ext\.php\?oid=([0-9]+)&id=([0-9]+)&hash=([a-z0-9]+)&hd=([0-9])" width="([0-9]+)" height="([0-9]+)" frameborder="0"></iframe>#iuU', '[vk_video oid=\1 id=\2 hash=\3 hd=\4]', $str);
    if ($br) {
        $str = br($str); // переносы строк
    }

    //$str = lang($str);
    $str = output_add($str);

    return esc($str); // возвращаем обработанную строку
}

function text($text, $maxwords = 21, $maxchar = 210) {
    $sep = ' ';
    $sep2 = '...';
    $words = @preg_split($sep, $text);
    $char = iconv_strlen($text, 'utf-8');
    if (count($words) > $maxwords) {
        $text = join($sep, array_slice($words, 0, $maxwords));
    }
    if ($char > $maxchar) {
        $text = iconv_substr($text, 0, $maxchar, 'utf-8');
    }
    return $text;
}
