<?php

require_once H . 'sys/fnc/lang.php';
#подключаем языковой пакет
lang::start('default');

#Защита от частых запросов с одного IP
if ($set['antidos']) {
    $antidos[] = array('time' => $time);
    $k_loads = 0;
    if (is_file(H . 'sys/tmp/antidos_' . $iplong . '.dat')) {
        $antidos_dat = unserialize(file_get_contents(H . 'sys/tmp/antidos_' . $iplong . '.dat'));
        for ($i = 0; $i < 150 && $i < sizeof($antidos_dat); $i++) {
            if ($antidos_dat[$i]['time'] > $time - 5) {
                $k_loads++;
                $antidos[] = $antidos_dat[$i];
            }
        }
    }

    @file_put_contents(H . 'sys/tmp/antidos_' . $iplong . '.dat', serialize($antidos));
    @chmod(H . 'sys/tmp/antidos_' . $iplong . '.dat', 0777);
}

function getChmodToRead($is_dir = false) {
    if ($is_dir) {
        return 0500;
    } else {
        return 0400;
    }
}

// рекурсивное удаление папки
function delete_dir($dir) {
    if (is_dir($dir)) {
        $od = opendir($dir);
        while ($rd = readdir($od)) {
            if ($rd == '.' || $rd == '..')
                continue;
            if (is_dir("$dir/$rd")) {
                @chmod("$dir/$rd", 0777);
                delete_dir("$dir/$rd");
            } else {
                @chmod("$dir/$rd", 0777);
                @unlink("$dir/$rd");
            }
        }
        closedir($od);
        @chmod("$dir", 0777);
        return @rmdir("$dir");
    } else {
        @chmod("$dir", 0777);
        @unlink("$dir");
    }
}

#отчистка папки с кэшем файлов get_user()
if (!isset($hard_process)) {
    $clear_dir = $db->get_row($db->query("SELECT * FROM `cron` WHERE `id` = 'clear_user_cache'"));
    if ($clear_dir['time'] == null or $clear_dir['time'] < $time - $set['cache_get_user_time']) {
        $hard_process = true;
        $db->query("UPDATE `cron` SET `time` = '$time' WHERE `id` = 'clear_user_cache' LIMIT 1");
        $od = opendir(H . 'sys/cache/users/');
        while ($rd = readdir($od)) {
            if (!preg_match('#^\.#', $rd) and filectime(H . 'sys/cache/users/' . $rd) < $time - $set['cache_get_user_time']) {
                @delete_dir(H . 'sys/cache/users/' . $rd);
            }
        }
        closedir($od);
    }
}
#очистка временной папки
if (!isset($hard_process)) {
    $clear_dir = $db->get_row($db->query("SELECT * FROM `cron` WHERE `id` = 'clear_tmp_dir'"));
    if ($clear_dir['time'] == null || $clear_dir['time'] < $time - 60 * 60 * 24) {
        $hard_process = true;
        $db->query("UPDATE `cron` SET `time` = '$time' WHERE `id` = 'clear_tmp_dir' LIMIT 1");
        $od = opendir(H . 'sys/tmp/');
        while ($rd = readdir($od)) {
            if (!preg_match('#^\.#', $rd) and filectime(H . 'sys/tmp/' . $rd) < $time - 60 * 60 * 24) {
                @delete_dir(H . 'sys/tmp/' . $rd);
            }
        }
        closedir($od);
    }
}
#бекап базы
if (!isset($hard_process) and $set['db_backup_cron_msg_id'] > 0 and $set['mail_backup'] > 0) {
    $db_backup_cron = $db->get_row($db->query("SELECT * FROM `cron` WHERE `id` = 'db_backup'"));

    if ($db_backup_cron['time'] == null or $db_backup_cron['time'] < time() - $set['db_backup_cron']) {
        $hard_process = true;

        include_once H . 'sys/inc/backup.php';

        if ($set['db_backup_cron_msg'] == 1) {
            $db->query("INSERT INTO `mail` (`id_user`, `id_kont`, `msg`, `time`) values ('0', '" . ($set['db_backup_cron_msg_id'] > 0 ? $set['db_backup_cron_msg_id'] : 1) . "', '" . $db->safesql('Ежедневный бекап базы данных создан и отправлен вам на ваш почтовый ящик ' . $set['mail_backup']) . "', '" . time() . "')");
        }
    }
}


// Подведение итогов статистики
if (!isset($hard_process)) {
    $q = $db->query("SELECT * FROM `cron` WHERE `id` = 'visit' LIMIT 1");
    if ($db->get_row($q) == 0) {
        $db->query("INSERT INTO `cron` (`id`, `time`) VALUES ('visit', '$time')");
    }
    $visit = $db->get_row($q);
    if ($visit['time'] == null || $visit['time'] < time() - 60 * 60 * 24) {
        if (function_exists('set_time_limit')) {
            @set_time_limit(600);
        } // Ставим ограничение на 10 минут
        $last_day = mktime(0, 0, 0, date('m'), date('d') - 1); // начало вчерашних суток
        $today_time = mktime(0, 0, 0); // начало сегодняшних суток
        $c = $db->super_query("SELECT COUNT(*) as count FROM `visit_everyday` WHERE `time` = '$last_day'");

        if ($c['count'] == 0) {
            $hard_process = true;
            // записываем общие данные за вчерашние сутки в отдельную таблицу
            $db->query("INSERT INTO `visit_everyday` (`host` , `host_ip_ua`, `hit`, `time`) VALUES ((SELECT COUNT(DISTINCT `ip`) FROM `visit_today` WHERE `time` < '$today_time'),(SELECT COUNT(DISTINCT `ip`, `ua`) FROM `visit_today` WHERE `time` < '$today_time'),(SELECT COUNT(*) FROM `visit_today` WHERE `time` < '$today_time'),'$last_day')");
            $db->query('DELETE FROM `visit_today` WHERE `time` < ' . $today_time);
        }
    }
}


// запись о переходах на сайт
if (isset($_SERVER['HTTP_REFERER']) && !preg_match('#' . preg_quote($_SERVER['HTTP_HOST']) . '#', $_SERVER['HTTP_REFERER']) && $ref = @parse_url($_SERVER['HTTP_REFERER'])) {
    if (isset($ref['host'])) {
        $_SESSION['http_referer'] = $ref['host'];
    }
}

// определение оператора
function opsos($ips = NULL) {
    global $ip;
    
    $db = new db;
    if ($ips == NULL) {
        $ips = $ip;
    }
    $ipl = ip2long($ips);
    $query = $db->super_query("SELECT COUNT(*) as count FROM `opsos` WHERE `min` <= '$ipl' AND `max` >= '$ipl'");
    if ($query['count'] != 0) {
        $opsos = $db->get_row($db->query("SELECT opsos FROM `opsos` WHERE `min` <= '$ipl' AND `max` >= '$ipl' LIMIT 1"));
        return stripcslashes(htmlspecialchars($opsos['opsos']));
    } else {
        return false;
    }
    unset($query);
}

// вывод ошибок
function err() {
    global $err;
    global $passgen;
    if (isset($err)) {
        if (is_array($err)) {
            foreach ($err as $key => $value) {
                echo "<div class='bg-danger'><i class='fa fa-exclamation-triangle fa-fw'></i> $value</div>\n";
            }
        } else {
            echo "<div class='bg-danger'><i class='fa fa-exclamation-triangle fa-fw'></i> $err</div>\n";
        }
    }
}

function msg($msg) {
    global $passgen;

    echo "<div class='bg-success-msg'><i class='fa fa-check fa-fw'></i> $msg</div>\n";
}

#отправка запланированных писем
$mail_to_send = $db->query("SELECT * FROM `mail_to_send` LIMIT 1");
if ($db->num_rows($mail_to_send) != 0) {
    $mail = $db->get_row($mail_to_send);
    $adds = "From: \"admin@$_SERVER[HTTP_HOST]\" <admin@$_SERVER[HTTP_HOST]>\n";
    $adds .= "Content-Type: text/html; charset=utf-8\n";
    mail($mail['mail'], '=?utf-8?B?' . base64_encode($mail['them']) . '?=', $mail['msg'], $adds);
    $db->query("DELETE FROM `mail_to_send` WHERE `id` = '$mail[id]'");
}

#ограничение времени выполнения скрипта

function time_limit($time) {
    if (SET_TIME_LIMIT && @set_time_limit($time)) {
        return true;
    } else {
        false;
    }
}

# сохранение настроек системы

function save_settings($set) {
    if ($fopen = @fopen(H . 'sys/ini/settings.ini', 'w')) {
        $ini_file = array('[SYSTEM]');

        foreach ($set as $key => $value) {
            $ini_file[] = $key . '="' . htmlentities((string) $value, ENT_QUOTES, 'UTF-8') . '";';
        }

        @fputs($fopen, implode("\r\n", $ini_file));
        @fclose($fopen);
        return true;
    } else {
        return false;
    }
}

#запись действий администрации

function admin_log($mod, $act, $opis) {
    global $user;
    $db = new db;
    $q = $db->super_query("SELECT * FROM `admin_log_mod` WHERE `name` = '" . $db->safesql($mod) . "' LIMIT 1");


    if ($db->get_affected_rows($q) == 0) {
        //echo $q['id'];
        $db->query("INSERT INTO `admin_log_mod` (`name`) VALUES ('" . $db->safesql($mod) . "')");
        $id_mod = $db->insert_id();
    } else {
        $id_mod = $q['id'];
    }
    $q2 = $db->super_query("SELECT * FROM `admin_log_act` WHERE `name` = '" . $db->safesql($act) . "' AND `id_mod` = '$id_mod' LIMIT 1");
    if ($db->get_affected_rows($q2) == 0) {
        $db->query("INSERT INTO `admin_log_act` (`name`, `id_mod`) VALUES ('" . $db->safesql($act) . "', '$id_mod')");
        $id_act = $db->insert_id();
    } else {
        $id_act = $q2['id'];
    }
    $db->query("INSERT INTO `admin_log` (`time`, `id_user`, `mod`, `act`, `opis`) VALUES ('" . time() . "','$user[id]', '$id_mod', '$id_act', '" . $db->safesql($opis) . "')");
}

#Загрузка остальных функций из папки "sys/fnc"
$opdirbase = opendir(H . 'sys/fnc');
while ($filebase = readdir($opdirbase)) {
    if (preg_match('#\.php$#i', $filebase)) {
        include_once(H . 'sys/fnc/' . $filebase);
    }
}

#запись о посещении
$db->query("INSERT INTO `visit_today` (`ip` , `ua`, `time`) VALUES ('$iplong', '" . $db->safesql($_SERVER['HTTP_USER_AGENT']) . "', '$time')");
