<?php
class bbcode{
	///////////// главные теги
	public static function tags($text) {
		$var = nl2br($text); // сохраняем переносы
		$var = html_entity_decode($var); // сохраняем переносы
		$var = self::highlight_bb($var); // стандартные бб коды
		return $var;
	}
	// Основные бб коды
	private static function highlight_bb($var) {
		$search = [
			'#\[i](.+?)\[/i]#is', //курсив
			'#\[u](.+?)\[/u]#is', //подчеркивание
			'#\[s](.+?)\[/s]#is', //зачеркивание
			'#\[b](.+?)\[/b]#is' //жирный
		];

		$replace = [
			'<em>$1</em>', //курсив
			'<span style="text-decoration:underline">$1</span>', //подчеркивание
			'<s>$1</s>', //зачеркивание
			'<strong>$1</strong>' //жирный
		];

		return preg_replace($search, $replace, $var);
	}
}
?>