<?php
class core{
	private $db;
	public function __construct() {
		return $this->getUserData();
	}
	protected function getUserData() {
		if (isset($_COOKIE['token'])):
			return $this->authentification($_COOKIE['token']);
		else:
			$ips = self::setIP($_SERVER['REMOTE_ADDR']);
			if(DB::$dbs->querySingle('SELECT COUNT(`id`) FROM `goust` WHERE `ip` = ?', [$ips]) == 0):
				DB::$dbs->query('INSERT INTO `goust` SET `datalast` = ?, `ip` = ?, `url` = ?',[time(),$ips,functions::htmlred($_SERVER['REQUEST_URI'])]);
			else:
				DB::$dbs->query('UPDATE `goust` SET `datalast` = ?, `url` = ?, `co` = `co` + 1 WHERE `ip` = ?',[time(),functions::htmlred($_SERVER['REQUEST_URI']),$ips]);
			endif;
		endif;
		return [];
	}
	private function authentification(string $token): array {
		$req = DB::$dbs->query('SELECT * FROM `user` WHERE `token` = ? LIMIT 1',[$token]);
		if ($req->rowCount()):
			$this->userData = $req->fetch();
			DB::$dbs->query('UPDATE `user` SET `datalast` = ? WHERE `id` = ?',[time(),$this->userData['id']]);
		else: // анулируем куки
			$this->userUnset();
		endif;
		return [];
	}
	public function getData() {
		return $this->userData ?? null;
	}
	protected function userUnset(): void {
		setcookie('token', '');
	}
	private function setIP($value): string {
		return ! empty($value) && filter_var($value, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) ? $value : 0;
	}
}
?>