<?php
class functions extends core {
	//функция фильтрации текста лучшая
	public static function htmlred($var) {
		return trim(htmlspecialchars($var, ENT_QUOTES, 'UTF-8'));
	}
	//функция фильтрации чисел вынес в отдельую что бы модить потом
	public static function ints($var) {
		return filter_var($var, FILTER_VALIDATE_INT);
	}
	// Отправка почты
	public static function mailto($mail, $theme, $text, $str) {
		$adt = 'From: ' . $str . PHP_EOL;
		$adt .= 'X-sender: < ' . $str . ' >' . PHP_EOL;
		$adt .= 'Content-Type: text/html; charset=utf-8' . PHP_EOL;
		return mail($mail, $theme, $text, $adt);
	}
	// Склонения
	public static function slv($str, $msg1, $msg2, $msg3, $ks = NULL) {
		$str = (int) $str;
		$str1 = abs($str) % 100;
		$str2 = $str % 10;
		if (isset($ks)): $strrr = $str; else: $strrr = NULL; endif;
		if ($str1 > 10 && $str1 < 20) return $strrr .' '. $msg3;
		if ($str2 > 1 && $str2 < 5) return $strrr .' '. $msg2;
		if ($str2 == 1) return $strrr .' '. $msg1;
		return $strrr .' '. $msg3;
	}
	// Функция ресайза изображений
	public static function img_resize($src, $dest, $width, $height, $rgb=0xFFFFFF, $quality=100) {
		if (!file_exists($src)) return false;
		$size = getimagesize($src);
		if ($size === false) return false;
		$format = strtolower(substr($size['mime'], strpos($size['mime'], '/')+1));
		$icfunc = "imagecreatefrom" . $format;
		if (!function_exists($icfunc)) return false;
		$x_ratio = $width / $size[0];
		$y_ratio = $height / $size[1];
		$ratio = min($x_ratio, $y_ratio);
		$use_x_ratio = false;   //($x_ratio == $ratio);
		$new_width = !$use_x_ratio  ? $width  : floor($size[0] * $ratio);
		$new_height = !$use_x_ratio ? $height : floor($size[1] * $ratio);
		$new_left = $use_x_ratio ? 0 : floor(($width - $new_width) / 2);
		$new_top = !$use_x_ratio ? 0 : floor(($height - $new_height) / 2);
		$isrc = $icfunc($src);
		$idest = imagecreatetruecolor($width, $height);
		imagefill($idest, 0, 0, $rgb);
		imagecopyresampled($idest, $isrc, $new_left, $new_top, 0, 0, $new_width+1, $new_height, $size[0], $size[1]);
		imagejpeg($idest, $dest, $quality);
		imagedestroy($isrc);
		imagedestroy($idest);
		return true;
	}
	// Транслит
	public static function transliterate($s) {
		$s = (string) $s; // преобразуем в строковое значение
		$s = strip_tags($s); // убираем HTML-теги
		$s = str_replace(["\n", "\r"], " ", $s); // убираем перевод каретки
		$s = preg_replace("/\s+/", ' ', $s); // удаляем повторяющие пробелы
		$s = trim($s); // убираем пробелы в начале и конце строки
		$s = function_exists('mb_strtolower') ? mb_strtolower($s) : strtolower($s); // переводим строку в нижний регистр (иногда надо задать локаль)
		$s = strtr($s, ['а'=>'a','б'=>'b','в'=>'v','г'=>'g','д'=>'d','е'=>'e','ё'=>'e','ж'=>'zh','з'=>'z','и'=>'i','й'=>'j','к'=>'k','л'=>'l','м'=>'m','н'=>'n','о'=>'o','п'=>'p','р'=>'r','с'=>'s','т'=>'t','у'=>'u','ф'=>'f','х'=>'h','ц'=>'c','ч'=>'ch','ш'=>'sh','щ'=>'shch','ы'=>'y','э'=>'e','ю'=>'yu','я'=>'ya','ъ'=>'','ь'=>'','/'=>'-']);
		$s = preg_replace("/[^0-9a-z-_ ]/i", "", $s); // очищаем строку от недопустимых символов
		$s = str_replace(" ", "-", $s); // заменяем пробелы знаком минус
		return $s; // возвращаем результат
	}
	// функция со временем
	public static function times($time) { 
		switch (date('j n Y', $time)) {
			case date('j n Y'): 
				return 'Сегодня в ' . date('H:i', $time) .''; 
			break;

			case date('j n Y', $_SERVER['REQUEST_TIME'] - 86400): 
				return 'Вчера в ' . date('H:i', $time).''; 
			break;

			default: 
				return strtr(date('j M Y', $time), ['Jan' => 'Янв', 
				'Feb' => 'Фев', 
				'Mar' => 'Марта', 
				'Apr' => 'Апр', 
				'May' => 'Мая', 
				'Jun' => 'Июня', 
				'Jul' => 'Июля', 
				'Aug' => 'Авг', 
				'Sep' => 'Сент', 
				'Oct' => 'Окт', 
				'Nov' => 'Ноября', 
				'Dec' => 'Дек']); 
			break; 
		}
	}
}
?>