<?php
require_once("inc_common.php");
include($ld_engine_path."rooms_get_list.php");
include($engine_path."users_get_list.php");
$messages_to_show = array();
if (!$exists) {
	$error_text = "$w_no_user";
	include($file_path."designes/".$design."/error_page.php");
	exit;
}

include("inc_user_class.php");
include($ld_engine_path."users_get_object.php");
set_variable("op");
if ($current_user->user_class<1) {
	$error_text = "$w_no_admin_rights";
	include($file_path."designes/".$design."/error_page.php");
	exit;
}
if (($current_user->user_class & ADM_BAN) && $op == "") $op = "ban";

switch ($op) {
	case "ban":
		if (!($current_user->user_class & ADM_BAN)) {
			$error_text = "$w_no_admin_rights";
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out =  $w_select_nick.": <form method=\"post\" action=\"admin_work.php\">".
						"<input type=\"hidden\" name=\"session\" value=\"$session\">".
						"<input type=\"hidden\" name=\"op\" value=\"do_ban\">".
						"<table border=\"0\">";
		$allowed_to_view_ip = $current_user->user_class & ADM_VIEW_IP;
		if(count($room_ids)>1){
			for($kk=0;$kk<count($room_ids);$kk++){
				$html_to_out .= "<tr><td colspan=\"2\">$w_in_room <b>".$rooms[$room_ids[$kk]]["title"]."</b></td></tr>\n";
				for ($i=0; $i<count($users); $i++){
					$data = explode("\t", $users[$i]);
					if ($data[10] == $room_ids[$kk]) {
						$name = $data[0];
						$ip = ($allowed_to_view_ip) ? ", ".str_replace("\n","",$data[USER_IP]): "";
						$html_to_out .= "<tr><td><input type=\"radio\" name=\"toBan\" value=\"$name\"></td><td>$name$ip</td></tr>\n";
					}
				}
			}
		}else{
			for ($i=0; $i<count($users); $i++){
				$data = explode("\t", $users[$i]);
				$name = $data[0];
				$ip = ($allowed_to_view_ip) ? ", ".str_replace("\n","",$data[USER_IP]): "";
				$html_to_out .= "<tr><td><input type=\"radio\" name=\"toBan\" value=\"$name\"></td><td>$name$ip</td></tr>\n";
			}
		}
		$html_to_out .= "</table><br>".$w_admin_action.": <select name=\"action\" class=\"input\">".
						"<option value=1>$w_admin_alert</option>".
						"<option value=2>$w_admin_kill</option>";
		if ($current_user->user_class & ADM_IP_BAN) $html_to_out .= "<option value=3>$w_admin_ip_kill</option>";
		if ($current_user->user_class & ADM_BAN_BY_BROWSERHASH) $html_to_out .= "<option value=4>$w_admin_browserhash_kill</option>";
		if ($current_user->user_class & ADM_BAN_BY_SUBNET) $html_to_out .= "<option value=5>$w_admin_subnet_kill</option>";
		$html_to_out .= "</select><br>".$w_kill_time.": <select name=\"kill_time\" class=\"input\">";
		for ($i=0;$i<count($sw_times);$i++)
			$html_to_out .= "<option value=\"$i\">".$sw_times[$i]["name"]."</option>";
		$html_to_out .= "</select><br>".$w_admin_reason.": <input type=\"text\" name=\"cause\" class=\"input\">".
						"<br><input type=\"submit\" value=\"$w_admin_ban\" class=\"input\">".
						"</form>";
	break;//end of ban
	case "do_ban":
		set_variable("cause");
		set_variable("toBan");
		set_variable("kill_time");
		set_variable("action");
		if (!($current_user->user_class & ADM_BAN)) {
			$error_text = "$w_no_admin_rights";
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$flood_protection = 0;
		$def_color = $registered_colors[$default_color][1];
		if($toBan !="") {
			//for compatible with old engine
			$nameToBan = $toBan;
			#list($nameToBan, $ipToBan) = explode(":", $toBan);
			for ($i=0;$i<count($users);$i++) {
				//list($ban_nickname, $unused, $unused, $unused, $unused, $ban_user_id, $unused, $ban_user_ip, $unused, $unused, $ban_room,$unused, $ban_canon_n, $unused, $unused, $unused)
				//	= explode("\t", $users[$i]);
				$banuser_array = explode("\t", $users[$i], USER_TOTALFIELDS);
				if (strcmp($banuser_array[USER_NICKNAME], $toBan) == 0) {
					$tmp_admin_rights = $current_user->user_class;
					if ($banuser_array[USER_REGID]) {
						//fake is_regist to load user-data
						$is_regist = $banuser_array[USER_REGID];
						include($ld_engine_path."users_get_object.php");
						//current user now contains user to ban
						if (($current_user->user_class > 0) && !($tmp_admin_rights & ADM_BAN_MODERATORS)){
							$error_text = "$w_adm_cannot_ban_mod";
							include($file_path."designes/".$design."/error_page.php");
							exit;
						}
					}
					$cause = htmlspecialchars($cause);
					if ($action == 1) {
						$messages_to_show[] = array(MESG_TIME=>my_time(), 
													MESG_ROOM=>$banuser_array[USER_ROOM],  
													MESG_FROM=>"", 
													MESG_FROMWOTAGS=>"",
													MESG_FROMSESSION=>"",
													MESG_FROMID=>0,
													MESG_FROMAVATAR=>"",
													MESG_TO=>"", 
													MESG_TOSESSION=>"",
													MESG_TOID=>"",
													MESG_BODY=>"<font color=\"$def_color\">".str_replace("#",$cause,str_replace("*", $cu_array[USER_NICKNAME],str_replace("~", $toBan,$sw_alert_text)))."</font>");
					}
					$to_ban = array();
					if ($action >1) {
						$to_ban[0] = "un|".$banuser_array[USER_CANONNICK];
						$to_ban[1] = "ch|".$banuser_array[USER_COOKIE];
						$messages_to_show[] = array(MESG_TIME=>my_time(), 
													MESG_ROOM=>$banuser_array[USER_ROOM],
													MESG_FROM=>"", 
													MESG_FROMWOTAGS=>"",
													MESG_FROMSESSION=>"",
													MESG_FROMID=>0,
													MESG_FROMAVATAR=>"",
													MESG_TO=>"", 
													MESG_TOSESSION=>"",
													MESG_TOID=>"",
													MESG_BODY=>"<font color=\"$def_color\">".str_replace("$",$sw_times[$kill_time]["name"],str_replace("#",$cause,str_replace("*", $cu_array[USER_NICKNAME],str_replace("~", $toBan,$sw_kill_text))))."</font>");

						if ($logging_ban) {
							include_once($data_path."engine/files/log_message.php");
							log_ban($cu_array[USER_NICKNAME],
									$banuser_array[USER_CANONNICK],
									$banuser_array[USER_IP],
									$banuser_array[USER_ROOM], $cause);
						}
						if ($action == 3 && ($tmp_admin_rights & ADM_IP_BAN))
							$to_ban[] = "ip|".$banuser_array[USER_IP];
						if ($action == 4 && ($tmp_admin_rights & ADM_BAN_BY_BROWSERHASH)) {
							$to_ban[] = "bh|".$banuser_array[USER_BROWSERHASH];
							//not good, but I don't know a better way
							$to_ban[] = "ip|".$banuser_array[USER_IP];
						}
						if ($action == 5 && ($tmp_admin_rights & ADM_BAN_BY_SUBNET))
							$to_ban[] = "sn|".substr($banuser_array[USER_IP], 0 , strrpos($banuser_array[USER_IP],".")) ;
						if (count($to_ban)>0) {
							include($ld_engine_path."admin.php");
						}
					}
					break;
				}
			}
			include($engine_path."messages_put.php");
		}
		header("location: admin_work.php?session=$session&op=ban");
		exit;
	break;//end of do ban
	case "unban":
		if (!($current_user->user_class & ADM_UN_BAN)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out = $w_adm_banned_now."<table border=\"1\"><tr><td>$w_adm_nick_or_ip</td><td>$w_adm_ban_until</td><td></td></tr>";
		include_once($ld_engine_path."ban_check.php");
		$banned_users = get_all_bans();
		for ($i=0;$i<count($banned_users);$i++) {
			$html_to_out .= "<tr><td>".$banned_users[$i]["who"]."</td><td>".date("d M y H:i:s",$banned_users[$i]["until"])."</td><td><a href=\"admin_work.php?session=$session&op=do_unban&to_unban=".urlencode($banned_users[$i]["who"])."\">$w_adm_unban</td></tr>";
		}
		$html_to_out .="</table>";
	break;
	case "do_unban":
		if (!($current_user->user_class & ADM_UN_BAN)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		include_once($ld_engine_path."ban_check.php");
		set_variable("to_unban");
		unban(urldecode($to_unban));
		if ($logging_ban) {include_once($data_path."engine/files/log_message.php"); log_unban($user_name, $to_unban);}
		header("location: admin_work.php?session=$session&op=unban");
		exit;
	break;
	case "topic":
		if (!($current_user->user_class & ADM_CHANGE_TOPIC)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out =  "<form method=\"post\" action=\"admin_work.php\">".
						"<input type=\"hidden\" name=\"session\" value=\"$session\">".
						"<input type=\"hidden\" name=\"op\" value=\"change_topic\">".
						"<input type=\"hidden\" name=\"room_to_change\" value=\"$room_id\">".
						"$w_topic: <input type=\"text\" name=\"topic\" value=\"".str_replace("\"","&quot;",$rooms[$room_id]["topic"])."\" class=\"input\"><br>".
						"<input type=\"submit\" value=\"$w_update\" class=\"input\"></form>";
	break;
	case "change_topic":
		if (!($current_user->user_class & ADM_CHANGE_TOPIC)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("room_to_change");
		$room_to_change = intval($room_to_change);
		set_variable("topic");
		$room_to_change = intval($room_to_change);
		include_once($ld_engine_path."rooms_operations.php");
		$new_topic = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$topic))));
		change_topic($room_to_change, $new_topic);
		$messages_to_show = array();
		$messages_to_show[] = array(MESG_TIME=>my_time(), 
									MESG_ROOM=>$room_to_change,  
									MESG_FROM=>"", 
									MESG_FROMWOTAGS=>"",
									MESG_FROMSESSION=>"",
									MESG_FROMID=>0,
									MESG_FROMAVATAR=>"",
									MESG_TO=>"", 
									MESG_TOSESSION=>"",
									MESG_TOID=>"",
									MESG_BODY=>"<font color=\"$def_color\">".str_replace("#",$new_topic,str_replace("*", $user_name,$sw_set_topic_text))."</font>");

		include($engine_path."messages_put.php");
		header("location: admin_work.php?session=$session&op=topic");
		exit;
	break;
	case "rooms":
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out = 	$w_list_of_rooms.":<table border=\"1\">".
						"<tr><td>$w_room_name</td><td>$w_topic</td><td></td></tr>";
		
		for ($i=0;$i<count($room_ids);$i++) {
			$html_to_out .= "<tr><td>".$rooms[$room_ids[$i]]["title"]."</td><td>".$rooms[$room_ids[$i]]["topic"]."</td>".
							"<td><a href=\"admin_work.php?session=$session&op=edit_room&room_to_change=".$room_ids[$i]."\" class=\"jsnavi\">$w_edit</a> | ".
							"<a href=\"admin_work.php?session=$session&op=delete_room&room_to_change=".$room_ids[$i]."\" class=\"jsnavi\">$w_delete</a></td></tr>";
		}
		$html_to_out .= "</table><br><br><a href=\"admin_work.php?session=$session&op=add_room_form\" class=\"jsnavi\">$w_adm_add_room</a>";
	break;
	case "delete_room":
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("room_to_change");
		$room_to_change = intval($room_to_change);
		include_once($ld_engine_path."rooms_operations.php");
		room_delete($room_to_change);
		header("location: admin_work.php?session=$session&op=rooms");
		exit;
	break;

	
	case "add_room_form":
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out = "<form method=\"post\" action=\"admin_work.php\">".
						"<input type=\"hidden\" name=\"session\" value=\"$session\">".
						"<input type=\"hidden\" name=\"op\" value=\"add_room\">".
						"<table border=\"0\">".
						"<tr><td>$w_room_name:</td><td><input type=\"text\" name=\"room_name\" class=\"input\" size=\"20\"></td></tr>".
						"<tr><td>$w_topic:</td><td><input type=\"text\" name=\"room_topic\" class=\"input\" size=\"50\"></td></tr>".
						"<tr><td>$w_adm_room_design:</td><td><select name=\"room_design\" class=\"input\">";
		$handle = opendir($file_path."/designes/");
		while (false !== ($tmp_file = readdir($handle))) 
			if ($tmp_file!="." and $tmp_file != "..")
				$all_designes[] = $tmp_file;
		closedir($handle);
		$html_to_out .= "<option value=\"\">None</option>\n";
		for ($des_i = 0; $des_i<count($all_designes);$des_i++)
			$html_to_out .= "<option value=\"".$all_designes[$des_i]."\">".$all_designes[$des_i]."</option>\n";
		
		$html_to_out .= "</select></td></tr>".
						"<tr><td>$w_bot_name:</td><td><input type=\"text\" name=\"room_bot\" value=\"".str_replace("\"","&quot;",$w_rob_name)."\" class=\"input\" size=\"20\"></td></tr>".
						"<tr><td colspan=\"2\"><input type=\"submit\" value=\"$w_update\" class=\"input\"></td></tr>".
						"</table></form>";
	break;
	case "edit_room":
		set_variable("room_to_change");
		$room_to_change = intval($room_to_change);
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out = "";
		for ($i=0;$i<count($room_ids);$i++)
			if ($room_ids[$i] == $room_to_change) {
				$html_to_out .= "<form method=\"post\" action=\"admin_work.php\">".
								"<input type=\"hidden\" name=\"session\" value=\"$session\">".
								"<input type=\"hidden\" name=\"op\" value=\"update_room\">".
								"<input type=\"hidden\" name=\"room_to_change\" value=\"".$room_ids[$i]."\">".
								"<table border=\"0\">".
								"<tr><td>$w_room_name:</td><td><input type=\"text\" name=\"room_name\" value=\"".str_replace("\"","&quot;",$rooms[$room_ids[$i]]["title"])."\" class=\"input\" size=\"20\"></td></tr>".
								"<tr><td>$w_topic:</td><td><input type=\"text\" name=\"room_topic\" value=\"".str_replace("\"","&quot;",$rooms[$room_ids[$i]]["topic"])."\" class=\"input\" size=\"50\"></td></tr>".
								"<tr><td>$w_adm_room_design:</td><td><select name=\"room_design\" class=\"input\">";
				$handle = opendir($file_path."/designes/");
				while (false !== ($tmp_file = readdir($handle))) 
					if ($tmp_file!="." and $tmp_file != "..")
						$all_designes[] = $tmp_file;
				closedir($handle);
				$html_to_out .= "<option value=\"\">None</option>\n";
				for ($des_i = 0; $des_i<count($all_designes);$des_i++) {
					$html_to_out .= "<option value=\"".$all_designes[$des_i]."\"";
					if ($all_designes[$des_i] == $rooms[$room_ids[$i]]["design"]) $html_to_out .= " selected";
					$html_to_out .= ">".$all_designes[$des_i]."</option>\n";
				}
				
				$html_to_out .= "</select></td></tr>".
								"<tr><td>$w_bot_name:</td><td><input type=\"text\" name=\"room_bot\" value=\"".str_replace("\"","&quot;",$rooms[$room_ids[$i]]["bot"])."\" class=\"input\" size=\"20\"></td></tr>".
								"<tr><td colspan=\"2\"><input type=\"submit\" value=\"$w_update\" class=\"input\"></td></tr>".
								"</table></form>";
				break;
			}
	break;
	case "update_room":
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("room_to_change");
		$room_to_change = intval($room_to_change);
		set_variable("room_name");
		$room_name = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_name))));
		set_variable("room_topic");
		$room_topic = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_topic))));
		set_variable("room_design");
		$room_design = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_design))));
		set_variable("room_bot");
		$room_bot = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_bot))));
		include_once($ld_engine_path."rooms_operations.php");
		room_update($room_to_change,$room_name,$room_topic,$room_design,$room_bot);
		header("location: admin_work.php?session=$session&op=edit_room&room_to_change=$room_to_change");
		exit;
	break;
	case "add_room":
		if (!($current_user->user_class & ADM_CREATE_ROOMS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("room_name");
		$room_name = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_name))));
		set_variable("room_topic");
		$room_topic = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_topic))));
		set_variable("room_design");
		$room_design = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_design))));
		set_variable("room_bot");
		$room_bot = htmlspecialchars(str_replace("\r"," ",str_replace("\n"," ",str_replace("\t"," ",$room_bot))));
		include_once($ld_engine_path."rooms_operations.php");
		room_add($room_name,$room_topic,$room_design,$room_bot);
		header("location: admin_work.php?session=$session&op=rooms");
		exit;
	break;
	case "user":
		if (!($current_user->user_class & ADM_EDIT_USERS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		$html_to_out = "<form method=\"post\" action=\"admin_work.php\">".
						"<input type=\"hidden\" name=\"session\" value=\"$session\">".
						"<input type=\"hidden\" name=\"op\" value=\"user_search\">".
						"<table border=\"0\"><tr><td valign=\"middle\">".
						$w_enter_nick.": <input type=\"text\" name=\"user_to_search\" class=\"input\"> </td>".
						"<td valign=\"middle\">".
						"<input type=\"submit\" value=\"".$w_search_button."\" class=\"input\">".
						"</td></tr></table>\n</form>";
	break;
	case "user_search":
		if (!($current_user->user_class & ADM_EDIT_USERS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("user_to_search");
		$u_ids = array();
		include($ld_engine_path."users_search.php");
		$html_to_out = "";
		if (count($u_ids)) {
			$html_to_out .= "$w_search_results<br>";
			for ($i=0;$i<count($u_ids);$i++)
				$html_to_out .= "<a href=\"admin_work.php?op=user_edit&user_id=".$u_ids[$i]."&session=$session\">".htmlspecialchars($u_names[$i])."</a>".
								" -- <a href=\"javascript:if (confirm('".$w_sure_user_delete."')) {document.location.href='admin_work.php?op=user_delete&user_id=".$u_ids[$i]."&session=$session';}\">".$w_delete."</a><br>\n";
		} else
			$html_to_out .= str_replace("~","&quot;<b>".$user_to_search."</b>&quot;",$w_search_no_found);
	break;
	case "user_delete":
		if (!($current_user->user_class & ADM_EDIT_USERS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("user_id");
		$user_ids = array();
		$user_ids[0] = $user_id;
		include_once($ld_engine_path."admin_work.php");
		users_delete($user_ids);
		for ($i=0;$i<count($user_ids);$i++) {
			@unlink($file_path."photos/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".big.jpg");
			@unlink($file_path."photos/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".big.gif");
			@unlink($file_path."photos/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".jpg");
			@unlink($file_path."photos/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".gif");
			@unlink($data_path."board/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".msg");
			@unlink($data_path."users/".floor($user_ids[$i]/2000)."/".$user_ids[$i].".user");
		}
		$html_to_out = $w_user_deleted;
	break;
	
	case "user_edit":
		if (!($current_user->user_class & ADM_EDIT_USERS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("user_id");
		$is_regist = $user_id;
		include("inc_user_class.php");
		include($ld_engine_path."users_get_object.php");
		$html_to_out = "<form method=\"post\" action=\"admin_work.php\">".
						"<input type=\"hidden\" name=\"session\" value=\"$session\">".
						"<input type=\"hidden\" name=\"op\" value=\"user_update\">".
						"<input type=\"hidden\" name=\"user_id\" value=\"$user_id\">".
						$current_user->nickname ."</b>:<br>".
						"<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">".
						"<tr><td><input type=checkbox name=\"showGroup1\"".
						(($current_user->show_group_1 == 1) ? " checked":"").
						"> ".$w_show_data."<table border=\"0\">".
						"<tr><td>".$w_surname.": </td><td><input type=\"text\" size=\"15\" name=\"surname\" value=\"".$current_user->surname."\" class=\"input\"></td></tr>".
						"<tr><td>".$w_name.": </td><td><input type=\"text\" size=\"15\" name=\"firstname\" value=\"".$current_user->firstname."\" class=\"input\"></td></tr>".
						"<tr><td>".$w_birthday.": </td><td><select name=\"day\" class=\"input\"><option value=\"\">--</option>";
		for ($i=1; $i<32; $i++) {
			$html_to_out .= "<option";
			if ($i == $current_user->b_day) $html_to_out .= " selected";
			$html_to_out .= ">$i\n";
		}
		$html_to_out .= "</select> / <select name=\"month\" class=\"input\"><option value=\"\">--</option>";
		for ($i=1; $i<13; $i++) {
			$html_to_out .= "<option";
			if ($i == $current_user->b_month) $html_to_out .= " selected";
			$html_to_out .= ">$i\n";
		}
		$html_to_out .= "</select> / <select name=\"year\" class=\"input\"><option value=\"\">--</option>";
		for ($i=1950; $i<2001; $i++) {
			$html_to_out .= "<option";
			if ($i == $current_user->b_year) $html_to_out .= " selected";
			$html_to_out .= ">$i\n";
		}
		$html_to_out .= "</select></td></tr>".
						"<tr><td>".$w_city.": </td><td><input type=\"text\" name=\"city\" size=\"10\" value=\"".$current_user->city."\" class=\"input\"></td></tr>".
						"<tr><td>".$w_gender.": </td><td><select name=\"sex\" class=\"input\">";
		$sex = $current_user->sex;
		$html_to_out .= "<option value=0";
		if ($sex == 0) $html_to_out .= " selected";
		$html_to_out .= ">$w_unknown</option>\n<option value=1";
		if ($sex == 1) $html_to_out .= " selected";
		$html_to_out .= ">$w_male</option>\n<option value=2";
		if ($sex == 2) $html_to_out .= " selected";
		$html_to_out .= ">$w_female</option>\n</select></td></tr>\n";
		$html_to_out .= "<tr><td>$w_small_photo: </td><td>";
		$pic_name = "" . floor($is_regist/2000) . "/" . $is_regist . ".big.gif";
		if (!file_exists($file_path."photos/$pic_name")) $pic_name="";
		if ($pic_name == "") {
			$pic_name = "" . floor($is_regist/2000) . "/" . $is_regist . ".big.jpg";
			if (!file_exists($file_path."photos/$pic_name")) $pic_name="";
		}
		$big_picture = $pic_name;
		$pic_name = "" . floor($is_regist/2000) . "/" . $is_regist . ".gif";
		if (!file_exists($file_path."photos/$pic_name")) $pic_name="";
		if ($pic_name == "") {
			$pic_name = "" . floor($is_regist/2000) . "/" . $is_regist . ".jpg";
			if (!file_exists($file_path."photos/$pic_name")) $pic_name="";
		}
		$small_picture = $pic_name;
		if ($small_picture != "")
			$html_to_out .= "<img src=\"photos/$small_picture\"><br><input type=\"checkbox\" name=\"sm_del\">$w_check_for_delete<br>";
		$html_to_out .= "<tr><td>$w_big_photo: </td><td>";
		if ($big_picture != "") {
			$html_to_out .= "<img src=\"photos/$big_picture\"><br>";
			$html_to_out .= "<input type=\"checkbox\" name=\"big_del\">$w_check_for_delete<br>";
		}
		$html_to_out .= "<tr><td>".$w_addit_info.": </td><td>".
						"<textarea name=\"comments\" rows=\"10\" cols=\"30\" class=\"input\">".str_replace("<br>","\n",$current_user->about).
						"</textarea></td></tr>".
						"</table></td></tr>".
						"<tr><td>&nbsp;</td></tr>".
						"<tr><td>".
						"<input type=checkbox name=\"showGroup2\"".
						(($current_user->show_group_2 == 1) ? " checked":"").
						"> ".$w_show_data."<br>".
						"<table border=\"0\">".
						"<tr><td>".$w_email.": </td><td><input type=\"text\" size=\"15\" name=\"email\" value=\"".$current_user->email."\" class=\"input\"></td></tr>".
						"<tr><td>".$w_homepage.": </td><td><input type=\"text\" size=\"15\" name=\"url\" value=\"".$current_user->url."\" class=\"input\"></td></tr>".
						"<tr><td>".$w_icq.": </td><td><input type=\"text\" size=\"15\" name=\"icquin\" value=\"".$current_user->icquin."\" class=\"input\"></td></tr>".
						"</table></td></tr><tr><td>&nbsp;</td></tr>";
		if($web_indicator){
			$html_to_out .= "<tr><td><table><tr><td>".
							"<input type=\"checkbox\" name=\"enable_web_indicator\"".
							(($current_user->enable_web_indicator) ? " checked":"").
							"> ".$w_web_indicator."</td></tr>".
							"<tr><td>".str_replace("~","<img src=\"".$chat_url."user_status.php?".$is_regist."\" border=\"0\" alt=\"chat status\">",$w_web_indicator_code)."</td></tr>".
							"<tr><td align=\"center\"><textarea class=\"input\" rows=\"5\" cols=\"40\">".
							"<a href=\"".$chat_url."\" target=\"_blank\"><img src=\"".$chat_url."user_status.php?".$is_regist."\" border=\"0\" alt=\"chat status\"></a>".
							"</textarea></td></tr>".
							"</table></td></tr>".
							"<tr><td>&nbsp;</td></tr>";
		}
		$html_to_out .= "<tr><td><table border=\"0\">".
						"<tr><td colspan=\"2\">".$w_if_wanna_change_password."</td></tr>".
						"<tr><td>".$w_new_password.": </td><td><input type=\"password\" name=\"passwd1\" class=\"input\"></td></tr>".
						"<tr><td>".$w_confirm_password.": </td><td><input type=\"password\" name=\"passwd2\" class=\"input\"></td></tr>".
						"</table></td></tr>".
						"<tr><td>&nbsp;</td></tr>".
						"</table><br>".
						"<input type=\"submit\" value=\"".$w_update."\" class=\"input\">".
						"</form>";
	break;
	case "user_update":
		if (!($current_user->user_class & ADM_EDIT_USERS)) {
			$error_text = $w_adm_no_permission;
			include($file_path."designes/".$design."/error_page.php");
			exit;
		}
		set_variable("user_id");
		$is_regist = $user_id;
		set_variable("surname");
		set_variable("firstname");
		set_variable("city");
		set_variable("comments");
		set_variable("email");
		set_variable("url");
		set_variable("icquin");
		set_variable("day");
		set_variable("month");
		set_variable("year");
		set_variable("sex");
		set_variable("passwd1");
		set_variable("passwd2");
		set_variable("showGroup1");
		set_variable("showGroup2");
		set_variable("sm_del");
		set_variable("big_del");
		set_variable("enable_web_indicator");
		include("inc_user_class.php");
		include($ld_engine_path."users_get_object.php");
		
		$info_message = "";
		$html_to_out = "";
		$passwd1 = str_replace("\t","",$passwd1);
		if ( (!$passwd1) or ($passwd1 != $passwd2) )
			$html_to_out .= "$w_pas_not_changed.<br>\n";
		else {
			$html_to_out .= "$w_pas_changed.<br>\n"; 
			$current_user->password = md5($passwd1);
		}
		if ($showGroup1 == "on") $current_user->show_group_1=1; else $current_user->show_group_1 = 0;
		if ($showGroup2 == "on") $current_user->show_group_2=1; else $current_user->show_group_2=0;
		$current_user->enable_web_indicator = ($enable_web_indicator == "on") ? 1 : 0;
		
		$pic_name = "" . $is_regist . ".big.gif";
		if (!file_exists($file_path."photos/".floor($is_regist/2000)."/$pic_name")) $pic_name="";
		if ($pic_name == "")
		{
			$pic_name = "" . $is_regist . ".big.jpg";
			if (!file_exists($file_path."photos/".floor($is_regist/2000)."/$pic_name")) $pic_name="";
		}
		$big_picture = $pic_name;
		$pic_name = "" . $is_regist . ".gif";
		if (!file_exists($file_path."photos/".floor($is_regist/2000)."/$pic_name")) $pic_name="";
		if ($pic_name == "")
		{
			$pic_name = "". $is_regist . ".jpg";
			if (!file_exists($file_path."photos/".floor($is_regist/2000)."/$pic_name")) $pic_name="";
		}
		$small_picture = $pic_name;
		
		
		if ($big_del == "on") {
			if ($big_picture != "") @unlink($file_path."photos/".floor($is_regist/2000)."/".$big_picture);
		}
		if ($sm_del == "on") {
			if ($small_picture != "") @unlink($file_path."photos/".floor($is_regist/2000)."/".$small_picture);
		}
		
		$current_user->surname = htmlspecialchars($surname);
		$current_user->firstname = htmlspecialchars($firstname);
		$current_user->city = htmlspecialchars($city);
		$current_user->about = htmlspecialchars($comments);
		$current_user->about = str_replace("\n","<br>", $current_user->about);
		$current_user->email = htmlspecialchars($email);
		$current_user->url = htmlspecialchars($url);
		$current_user->icquin = htmlspecialchars($icquin);
		$current_user->b_day = intval($day);
		$current_user->b_month = intval($month);
		$current_user->b_year = intval($year);
		$current_user->sex = intval($sex);
		include($ld_engine_path."user_info_update.php");
		$html_to_out .= $info_message;

	break;
}
include($file_path."designes/".$design."/output_page.php");
?>