<?php
include("inc_common.php");
set_variable("impro_id");
include($ld_engine_path."impro.php");

$impro_width = 80;
$impro_height = 33;

#functions.
function make_background($image) {
	global $impro_width, $impro_height, $background_color, $text_color;
	switch (rand(1,3)){
		case 1:
			$start_point = rand(1,10);
			$space = rand(10,40);
			$current = $start_point;
			while ($current < $impro_width) {
				imageline($image, $current, 0, $current, $impro_height, $text_color);
				imageline($image, 0, $current, $impro_width, $current, $text_color);
				$current += $space;
			}
		break;
		case 2:
			$total_circles = rand(2, 5);
			for($i=0;$i<$total_circles;$i++) {
				$r_x = rand(10,40);
				$r_y = rand(10,40);
				$c_x = rand(-5, $impro_width+5);
				$c_y = rand(-5, $impro_height+5);
				imagearc($image, $c_x,$c_y,$r_x,$r_y,0,360,$text_color);
			}
		break;
		case 3:
			for ($i=0;$i<250;$i++){
				$c_x = rand(0,$impro_width);
				$c_y = rand(0,$impro_height);
				imagesetpixel($image,$c_x,$c_y,$text_color);
			}
		break;
	}
}
function make_foreground($image) {
	global $impro_width, $impro_height, $background_color;
	switch (rand(0,2)){
		case 1:
			#$white = imagecolorallocate ($image, 255, 255, 255);
			$start_point = rand(1,10);
			$space = rand(9,25);
			$current = $start_point;
			while ($current < $impro_width) {
				imagedashedline($image, $current, 0, $current, $impro_height, $background_color);
				#imagedashedline($image, 0, $current, $impro_width, $current, $background_color);
				$current += $space;
			}
		break;
		case 2:
			#$white = imagecolorallocate ($image, 255, 255, 255);
			$start_point = rand(1,10);
			$space = rand(9,25);
			$current = $start_point;
			while ($current < $impro_width) {
				#imagedashedline($image, $current, 0, $current, $impro_height, $background_color);
				imagedashedline($image, 0, $current, $impro_width, $current, $background_color);
				$current += $space;
			}
		break;
	}
}
#end of functions

$impro_code = impro_get_code($impro_id);
header("Content-type: image/png");
$image = imagecreate($impro_width,$impro_height);
$col_r = rand(200,255);
$col_g = rand(200,255);
$col_b = rand(200,255);
$background_color = imagecolorallocate ($image, $col_r, $col_g, $col_b);
$col_r = rand(0,150);
$col_g = rand(0,150);
$col_b = rand(0,150);
$text_color = imagecolorallocate ($image, $col_r, $col_g, $col_b);

list($usec, $sec) = explode(' ', microtime());
srand( (float) $sec + ((float) $usec * 100000));

make_background($image);

$font = rand(4,5);
$c_x = rand(0,45);
$c_y = rand(0,20);
imagestring ($image, $font, $c_x, $c_y,  $impro_code, $text_color);
make_foreground($image);
imagePng($image);
?>