<?php
if (!defined("_COMMON_")):
define("_COMMON_", 1);

if (!defined("_TAIL_"))
	ob_start();
//you can also try to use
//ob_start("ob_gzhandler);
//if you have a lot of visitors it can make chat faster,
//because it saves traffic and PHP sends pages faster (doesn't wait for a long output)



// the path, where all data is stored  -- i.e. messages, user-boards etc. and also config file
// It is recommended to put this directory outside of your web-site access-path
$data_path = "/home/voodoo/www/voc/data/";

error_reporting(E_ERROR|E_PARSE|E_CORE_ERROR|E_CORE_WARNING|E_COMPILE_ERROR|E_COMPILE_WARNING);
$debug = 0;

function my_err_h ($errno, $errstr, $errfile, $errline) {
	global $debug, $data_path,$file_path;
	if (strpos($errstr, "\t") > 0) {
		list($voc_ercode, $errstr) = split("\t", $errstr);
		$voc_ercode = intval($voc_ercode);
	} else 
		$voc_ercode = -1;
	switch($errno) {
		case E_NOTICE:
			if ($debug) echo "<b>NOTICE</b>: ".htmlspecialchars($errstr).",  at line ".$errline." in the file ".str_replace(dirname(dirname($errfile))."/", "", $errfile)."<br>";
			else return 0;
		case E_WARNING:
			if ($debug) echo "<b>WARNING</b>: ".htmlspecialchars($errstr).",  at line ".$errline." in the file ".str_replace(dirname(dirname($errfile))."/", "", $errfile)."<br>";
			else return 0;
		break;
		case E_USER_ERROR:
			echo "<center><table border=\"0\"width=\"80%\" cellpadding=\"6\" cellspacing=\"0\">";
			echo "<tr><td bgcolor=\"red\" ><span style=\"color:white; font-weight: bold; font-size:18px; font-family: Arial, Verdana\">Voodoo chat -- Fatal error</span></td></tr>";

			echo "<tr bgcolor=\"#dddddd\"><td><span style=\"color:black; font-size:14px; font-family: Arial, Verdana\">We got the error <br><b>".htmlspecialchars($errstr)."</b><br>at line <b>".$errline."</b>";
			echo " in the file <b>".str_replace(dirname(dirname($errfile)), "", $errfile);
			echo "</span></td></tr>";
			echo "<tr bgcolor=\"#dddddd\"><td><span style=\"color:black; font-size:12px; font-family: Arial, Verdana\">";
			if ($voc_ercode >0) echo "<a href=\"http://errors.vochat.com/?".$voc_ercode."\">More details about the problem</a><br><br><a href=\"http://vochat.com/\">Voodoo chat</a> &copy; 1999-2004 by Vlad Vostrykh";
			else echo "Find help at <a href=\"http://vochat.com/\">Voodoo chat homepage</a>";
			echo "</td></tr>";
			echo "</table></center>";
			exit;
		break;
		case E_USER_WARNING:
			echo "<center><table border=\"0\"width=\"80%\" cellpadding=\"6\" cellspacing=\"0\">";
			echo "<tr><td bgcolor=\"red\" ><span style=\"color:white; font-weight: bold; font-size:18px; font-family: Arial, Verdana\">Voodoo chat -- error</span></td></tr>";

			echo "<tr bgcolor=\"#dddddd\"><td><span style=\"color:black; font-size:14px; font-family: Arial, Verdana\">We got the error <br><b>".htmlspecialchars($errstr)."</b><br>at line <b>".$errline."</b>";
			echo " in the file <b>".str_replace(dirname(dirname($errfile)), "", $errfile);
			echo "</span></td></tr>";
			echo "<tr bgcolor=\"#dddddd\"><td><span style=\"color:black; font-size:12px; font-family: Arial, Verdana\">";
			if ($voc_ercode >0) echo "<a href=\"http://errors.vochat.com/?".$voc_ercode."\">More details about the problem</a><br><br><a href=\"http://vochat.com/\">Voodoo chat</a> &copy; 1999-2004 by Vlad Vostrykh";
			else echo "Find help at <a href=\"http://vochat.com/\">Voodoo chat homepage</a>";
			echo "</td></tr>";
			echo "</table></center>";
		break;
	}
	return 0;
}
set_error_handler("my_err_h");

#loading parameters from config file

if (!($conf_content = implode("",file($data_path."voc.conf")))) {
	trigger_error("1000\tCannot open voc.conf file, please check your DATA PATH parameter",E_USER_ERROR);
}
eval($conf_content);
#time-offset
function my_time() {
	global $time_offset;
	return time()+$time_offset;
}

#for Register_gloabls = off
function set_variable($variable_name) {
	global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $$variable_name;
	$$variable_name = "";
	//GPC order :)
	if (isset($HTTP_GET_VARS[$variable_name])) $$variable_name = $HTTP_GET_VARS[$variable_name];
	if (isset($HTTP_POST_VARS[$variable_name])) $$variable_name = $HTTP_POST_VARS[$variable_name];
	if (substr($variable_name,0,2)=="c_" && isset($HTTP_COOKIE_VARS[$variable_name])) $$variable_name = $HTTP_COOKIE_VARS[$variable_name];
	//i don't use string-arrays in forms, only in the admin-zone, but there it's just design &lang names
	//which is normally doesn't have ' or " etc
	if (is_string($$variable_name)) {
		$$variable_name = str_replace("\0","", $$variable_name);
		$$variable_name = str_replace("\t"," ", $$variable_name);
		if (get_magic_quotes_gpc()) $$variable_name = stripslashes($$variable_name);
	}
}
set_variable("session");
$session = preg_replace("/[^a-fA-F0-9]/", "", $session);
set_variable("design");

set_variable("c_hash");
if ($c_hash == "")
	$c_hash = md5(uniqid(rand()));
//will set it in the file which doesn't output anything before inc_common.php
//setCookie("c_hash", $c_hash, time() + 2678400);

$browser_t = "";
if (isset($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) $browser_t .= $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
if (isset($HTTP_SERVER_VARS['HTTP_ACCEPT_LANGUAGE'])) $browser_t .= $HTTP_SERVER_VARS['HTTP_ACCEPT_LANGUAGE'];
if (isset($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'])) $browser_t .= $HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'];
$browser_hash = 0;
for ($i=0;$i<strlen($browser_t);$i++) $browser_hash+=ord($browser_t[$i]);

#determening the current design
if ($design == "") $design = $default_design;
else if (!in_array($design, $designes)) $design = $default_design;
$current_design = $chat_url."designes/".$design."/";


#setting necessary variables
$daemon_url = $daemon_host;
if ($daemon_type!=2) $daemon_url = $daemon_url.":".$daemon_port."/";
$engine_path = $data_path."engine/".$engine."/";
$ld_engine_path = $data_path."engine/".$long_life_data_engine."/";

$user_data_file = $data_path."users.dat";
$who_in_chat_file = $data_path."who.dat";
$messages_file = $data_path."messages.dat";
$converts_file = $data_path."converts.dat";
$robotspeak_file = $data_path."robotspeak.dat";
$banlist_file = $data_path."banlist.dat";
$rooms_list_file = $data_path."rooms.dat";

#user statuses
define('ONLINE',0);
define('DISCONNECTED',1);
define('AWAY',2);
define('NA',4);
define('DND',8);

#admin rights
define('ADM_BAN',1);
define('ADM_IP_BAN',2);
define('ADM_VIEW_IP',4);
define('ADM_UN_BAN',8);
define('ADM_BAN_MODERATORS',16);
define('ADM_CHANGE_TOPIC',32);
define('ADM_CREATE_ROOMS',64);
define('ADM_EDIT_USERS',128);
define('ADM_BAN_BY_BROWSERHASH',256);
define('ADM_BAN_BY_SUBNET',512);
$total_admin_levels = 10;
define("_VIP_", -84);

//constans for users and messages lists
define("USER_NICKNAME",0);
define("USER_SESSION",1);
define("USER_TIME",2);
define("USER_GENDER",3);
define("USER_AVATAR",4);
define("USER_REGID",5);
define("USER_TAILID",6);
define("USER_IP",7);
define("USER_STATUS",8);
define("USER_LASTSAYTIME",9);
define("USER_ROOM",10);
define("USER_IGNORLIST",11);
define("USER_CANONNICK",12);
define("USER_CHATTYPE",13);
define("USER_LANG",14);
//new
define("USER_HTMLNICK",15);
define("USER_PRIVTAILID",16);
define("USER_COOKIE",17);
define("USER_BROWSERHASH",18);
define("USER_CLASS",19);
//old again :)
define("USER_SKIN",20);
define("USER_TOTALFIELDS",21);


define("MESG_ID",0);
define("MESG_ROOM",1);
define("MESG_TIME",2);
define("MESG_FROM",3);
define("MESG_FROMWOTAGS",4);
define("MESG_FROMSESSION",5);
define("MESG_FROMID",6);
define("MESG_FROMAVATAR", 7);
define("MESG_TO",8);
define("MESG_TOSESSION",9);
define("MESG_TOID",10);
define("MESG_BODY",11);
define("MESG_TOTALFIELDS",12);

define("ROOM_ID",0);
define("ROOM_TITLE",1);
define("ROOM_TOPIC",2);
define("ROOM_DESIGN",3);
define("ROOM_BOT",4);
define("ROOM_CREATOR",5);//for private rooms
define("ROOM_ALLOWEDUSERS",6);//for private rooms
define("ROOM_ALLOWPICS",7);//to send pics.
define("ROOM_PREMODER",8);//message must be approved by moderator
define("ROOM_LASTACTION", 9);
define("ROOM_TOTALFIELDS",10);


#loading language pack
//require beacuse I need 'fatal error' if i cannot find the file
if(!defined("_VOC_CONFIG_")) {
	require_once($file_path."languages/".$language.".php");

	//System messages -- for case user selected not default language
	//?$w_whisper_to
	//the same name, but with 's' before
	$sw_rob_login = $w_rob_login;
	$sw_rob_hb = $w_rob_hb;
	$sw_rob_logout = $w_rob_logout;
	$sw_rob_idle = $w_rob_idle;
	$sw_goes_to_room = $w_goes_to_room;
	$sw_came_from_room = $w_came_from_room;
	$sw_set_topic_text = $w_set_topic_text;
	$sw_alert_text = $w_alert_text;
	$sw_kill_text = $w_kill_text;
	$sw_times = $w_times;
	$s_registered_colors = $registered_colors;
	$s_default_color = $default_color;
	$s_highlighted_color = $highlighted_color;
}
//check for current language and call w_people_* from corresponding lang-file
function w_people($num) {
	global $language, $user_lang;
	$call_lang = $language;
	if (isset($user_lang) && $user_lang != "")
		$call_lang = $user_lang;
	return call_user_func("w_people_".$call_lang, $num);
}
endif;
?>
