#!/usr/bin/perl

# Alternative daemon for the Voodoo Chat
# (c) 2002 by Vlad Vostrykh, vlad-v@users.sourceforge.net
# Distributed under the GPL v2 license

$config = shift;
if ($config eq "") {$config = "../voc.conf";}

eval('require("$config")') or die "cannot process config file $config";
$lang_file = $file_path."languages/".$language.".php";

open(LANG,"< $lang_file");
flock(LANG, 2);
while (<LANG>)
{
	($key, $value) = split(" = ",$_,2);
	
	if ($key eq "\$w_no_user")
	{
		$value =~ s/\"//g;
		$value =~ s/;//g;
		$lang{"no_such_user"}  = $value;
	}
	if ($key eq "\$w_server_restarting")
	{
		$value =~ s/\"//g;
		$value =~ s/;//g;
		$lang{"server_restarting"} = $value;
	}
	if ($key eq "\$w_whisper_to")
	{
		$value =~ s/\"//g;
		$value =~ s/;//g;
		$lang{"whisper_to"} = $value;
	}
	if ($key eq "\$w_only_one_tail")
	{
		$value =~ s/\"//g;
		$value =~ s/;//g;
		$lang{"only_one_tail"} = $value;
	}
}
flock(LANG, 8);
close(LANG);


use POSIX;
use IO::Socket;
use IO::Select;
use Socket;

#use Fcntl; 

use Time::localtime;

$LOG = 1;


STDOUT->autoflush;
STDERR->autoflush;

$messages_file = "../messages.dat";
$who_file = "../who.dat";
$ignored_file = "../ignored.dat";
$log_file = "./daemon.log";
$header_file = "daemon_html_header.html";
$pid_file = "./daemon.pid";
my $SELF = "./daemon.pl $config";
my @ARGS = qw();

#daemonising :)
#$pid = fork;
#exit if $pid;
#die "Couldn't fork: $!" unless defined($pid);
#$pid = POSIX::setsid() or die "Can't start a new session";
#open (STDOUT, ">>$log_file");
#open (STDERR, ">>$log_file");
#unless ($LOG) {
#   close STDIN;
#   close STDOUT;
#}

%userhashes = ();
%usernames = ();
%new_users = ();
%userbuffers = ();
%user_incbuffers = ();
%usertails = ();
my $wait_counter = 0;
my @users;
my @new_messages;
my @messages;
my @ignored;
%users_to_update =();
my $user_design = "";
my $session = "";
my $send_ok = 0;
my $user_exists = 0;
my $new_counter = 0;
my $last_id = 0;
my $new_counter = 0;
my $inter = 0;
my $to_write = 0;

foreach $signal(keys %SIG)
{
	$SIG{$signal}  = \&sigger;
}
$SIG{__DIE__} = \&sigger;
$SIG{HUP} = \&restarter;
eval
{


my $vc_daemon = IO::Socket::INET->new(	LocalPort => $daemon_port,
									LocalAddr => $daemon_listen,
									Timeout => 5,
									Listen => $max_connect) or die "can't create socket";

$vc_daemon->blocking(false);
$list = IO::Select->new($vc_daemon);

my_log("Daemon started");


open(PID,"> $pid_file");
flock(PID, 2);
print PID $pid;
flock(PID, 8);
close(PID);




while(1)
{
	$to_write = 0;
	undef %users_to_update;
	%users_to_update = ();
	undef %new_users;
	%new_users=();
	#sleep(1);
	undef @messages;
	open(MESSAGES,"< $messages_file");
	flock(MESSAGES, 2);
	@messages = <MESSAGES>;
	flock(MESSAGES, 8);
	close(MESSAGES);
	undef @users;
	open(USERS,"< $who_file");
	flock(USERS, 2);
	@users = <USERS>;
	flock(USERS, 8);
	close(USERS);
	undef @ignored;
	open(USERS,"< $ignored_file");
	flock(USERS, 2);
	@ignored = <USERS>;
	flock(USERS, 8);
	close(USERS);
	$new_counter = 0;
	undef @new_messages;
	
	$new_counter = 0;
	for ($i=scalar(@messages)-1;$i>=0;$i--)
	{
		my ($cp_id,$mm) = split ("\t",$messages[$i]);
		if(!defined($cp_id)) {$cp_id =0;}
		if ($cp_id>$last_id)
		{
			$new_messages[$new_counter] = $messages[$i];
			$new_counter++;
		}
	}
	my ($ttt,$mm) = split ("\t",$messages[scalar(@messages)-1]);
	if ($ttt > $last_id)
	{
		$last_id = $ttt;
	}
	foreach $client ($list->can_read(1))
	{
		if ($client == $vc_daemon)
		{
			$new_client = $vc_daemon->accept() or do { undef $new_client; my_log("failed connection attempt");};
			if (defined $new_client)
			{
				$new_client->blocking(false);
				$list->add($new_client);
			}			
		}
		else
		{
			$readed = $client->sysread($buf,POSIX::BUFSIZ);
			if(!defined $readed) {$readed = 0;}
			if($readed)
			{
				if(!defined $userhashes{$client})
				{
					if ($readed>0) 
					{ 
						#if request too long, remove user
						if(length($user_incbuffers) < 16*1024)
						{
							$user_incbuffers{$client} .= $buf;
							my $ttt_buf  = $user_incbuffers{$client};
							if ($ttt_buf =~ /^\w+[^\012]+HTTP\/\d+\.\d+\015?\012/) 
							{
								#my_log($ttt_buf);
								if ($ttt_buf !~ s/^(\S+)[ \t]+\/\?(\S+)(?:[ \t]+(HTTP\/\d+\.\d+))?[^\012]*\012//) 
								{
									#${*$self}{'httpd_client_proto'} = _http_version("HTTP/1.0");
									#$self->send_error(400);  # BAD_REQUEST
									#$self->reason("Bad request line: $buf");
									#return;
#actually, i have to do something with wrong requests
								}
								my $method = $1;
								my $session = $2;
 								my $proto = $3 || "HTTP/0.9";
								my_log("trying to find user with hash: \"$session\"");
								$userhashes{$client} = $session;
								$usernames{$client} = "...";
								for ($i=0;$i<scalar(@users);$i++)
								{
									my ($nickname, $test_hash, $a1,$a2,$a3,$a4,$tail_num,$remote_ip,$ttt_user_design) = split("\t",$users[$i]);
									$remote_ip =~ s/\n//;
									$tail_num++;
									if ($test_hash eq $session)
									{
										$usernames{$client} = $nickname;
										$usertails{$client} = $tail_num;
										$user_design = $ttt_user_design;
										$user_design =~ s/\n//g;
										my_log("$nickname connected ($remote_ip)");
										$users_to_update{$nickname}="$nickname\t$test_hash\t".time."\t$a2\t$a3\t$a4\t$tail_num\t$remote_ip\t$user_design";
										$users[$i] = $users_to_update{$nickname}."\n";
										$to_write = 1;
									}
							
								}
								my $ttt_ex = 0;
								for ($i=0;$i<scalar(@designes);$i++)
								{
									if ($user_design eq $designes[$i]) {$ttt_ex = 1; break;}
								}
								if (!$ttt_ex) {$user_design = $default_design;}
								$new_users{$client} = $user_design;
								$userbuffers{$client} = "HTTP/1.0 200 Ok Welcome to VOC\015\012Server: Voodoo chat daemon\015\012".
														"Content-type: text/html\015\012Expires: Mon, 26 Jul 1997 05:00:00 GMT\015\012".
														"Cache-Control: no-store, no-cache, must-revalidate\015\012Cache-Control: post-check=0, pre-check=0\015\012".
														"Pragma: no-cache\015\012\015\012";
								show_top($client,$user_design);
								if ($usernames{$client} eq "...")
								{
									$userbuffers{$client} .=$lang{"no_such_user"};
									client_remove($client);
								}
							}#//end of buff checking
						}
						else 
						{
							#else for too logn request string
							client_remove($client);
						}
					}#end for reading>0
				}#end of userhash already defined
			}#redaed undefined -- client disconnected
			else { client_remove($client); }
		}
	}
	if ((scalar(@new_messages)>0) or ($wait_counter>25))
	{
		foreach $client ($list->can_write(1))
		{
				if (defined $new_users{$client})
				{
#show_top doesn't work, because it waits for new messages.
#					show_top($client,$user_design);
					undef $new_users{$client};
				}
				else
				{
					my $to_send = "";
					$send_ok = 0;
					$user_exists = 0;
					for ($i=0;$i<(scalar(@users));$i++)
					{
						my ($nickname, $test_hash, $a1,$a2,$a3,$a4,$tail_num,$remote_ip,$ttt_user_design) = split("\t",$users[$i]);
						$remote_ip =~ s/\n//;
						if ($test_hash eq $userhashes{$client})
						{
							
							$user_exists = 1;
							$ttt_user_design =~ s/\n//g;
							$users_to_update{$nickname}="$nickname\t$test_hash\t".time."\t$a2\t$a3\t$a4\t$tail_num\t$remote_ip\t$ttt_user_design";
							$to_write = 1;
							if ($tail_num != $usertails{$client})
							{
								$user_exists = 0;
								$userbuffers{$client} .= $lang{"only_one_tail"};
								client_remove($client);
							}
							break;
						}
					}
					
					if ($user_exists)
					{
						$ttt_buf = "";
						for ($i=(scalar(@new_messages)-1);$i>=0;$i--)
						{
							$ttt_buf .= show_message($new_messages[$i],$userhashes{$client},$usernames{$client});
						}
						if ($ttt_buf ne "")
						{
							$userbuffers{$client} .= $ttt_buf;
						}
						else
						{
							if ($wait_counter > 25)
							{
								$userbuffers{$client} .= "<jk>";
							}
						}
					}

				}
		}
		$wait_counter = 0;
	}
	else {$wait_counter++;}
	
		foreach $client ($list->can_write(1))
		{
			my $buffer_length = length($userbuffers{$client});
			if ($buffer_length)
			{
				eval('$bytewriten = syswrite($client, $userbuffers{$client}, $buffer_length,0);');
				if (defined $bytewriten)
				{
					$userbuffers{$client} = substr($userbuffers{$client},$bytewriten, $buffer_length -$bytewriten);
				}
				else
				{
					client_remove($client);
				}
			}
			
		}
	if ($to_write)
	{
		open(USERS,"+>> $who_file");
		binmode(USERS);
		flock(USERS, 2);
		seek (USERS, 0, 0);
		@users = <USERS>;
		seek(USERS,0,0);
		truncate (USERS, 0);
		for ($i=0;$i<(scalar(@users));$i++)
		{
			my $user_to_proc = $users[$i];
			$user_to_proc =~ s/\n//;
			my ($nickname, $test_hash, $a1,$a2,$a3,$a4,$tail_num,$remote_ip,$ttt_user_design) = split("\t",$user_to_proc);
			if (defined $users_to_update{$nickname})
			{
				print USERS $users_to_update{$nickname};
			}
			else
			{
				print USERS $user_to_proc;
			}
			if ($i<(scalar(@users)-1))
			{
				print USERS "\n";
			}
		}
		flock(USERS, 8);
		close(USERS);
	}
}
};

if ($inter)
{
	my_log("Daemon tried to restart");
		exec($SELF);
}
else
{
		exit;
}

sub client_remove
{
	my $client = shift;
			my $buffer_length = length($userbuffers{$client});
			if ($buffer_length)
			{	
				eval('$bytewriten = syswrite($client, $userbuffers{$client}, $buffer_length,0);');
			}

	my_log($usernames{$client}." disconnected");
	$list->remove($client);
	delete $userhashes{$client};
	delete $usernames{$client};
	delete $userbuffers{$client};
	delete $usertails{$client};
	delete $user_incbuffers{$client};
	close($client);
}

sub my_log
{
	my $log_message = shift;
	if ($LOG)
	{
		$tm = localtime(); 
		printf("%04d-%02d-%02d %02d:%02d:%02d: ", $tm->year + 1900,$tm->mon,$tm->mday,$tm->hour,$tm->min,$tm->sec);
		print $log_message."\n";
	}
}

#sub nonblock 
#{
#    my $socket = shift;
#    my $flags;
#    
#    my $ok = 0;
#    eval('$flags = fcntl($socket, F_GETFL, 0) or  die "PIPE"; fcntl($socket, F_SETFL, $flags | O_NONBLOCK ) or die "PIPE"; $ok = 1;');
#    return $ok;
#}

sub show_top
{
	my $client = shift;
	my $user_design = shift;
	
	my $send_ok = 0;
									$header = $file_path."designes/".$user_design."/".$header_file;
									
									open(PAGE_HEADER,"< $header");
									flock(PAGE_HEADER, 1);
									while(<PAGE_HEADER>)
									{
										$userbuffers{$client} .= $_;
									}
									flock(PAGE_HEADER, 8);
									close(PAGE_HEADER);

	my $start_at = (scalar(@messages))>10 ? ((scalar(@messages)) - 10) : 0;
	my $to_send = "";
	for ($i=$start_at;$i<scalar(@messages);$i++)
	{
		$userbuffers{$client} .=  show_message($messages[$i],$userhashes{$client},$usernames{$client});
	}
}

sub show_message
{
        my $inc = shift;
        my $rndNum = shift;
        my $userName = shift;
        my $t_to = "???";
		my $ignore_user = 0;
		my $ret = "";
		my($id,$my_time,$from,$m_to,$msg,$color) = split("\t",$inc,6);
        $tm = localtime($my_time);
		my $tmp_hour = sprintf ("%02d",$tm->hour);
		my $tmp_min = sprintf ("%02d",$tm->min);
		my $tmp_sec = sprintf ("%02d",$tm->sec);
        for ($k=0;$k<scalar(@ignored);$k++)
		{
				my ($me, $who) = split("\t",$ignored[$k]);
#$who =~ s/\n//;
				if (($me eq $rndNum) and ($who eq $from))
				{
					$ignore_user = 1;
					#if ($DEBUG) {print "$me ignores $who\n";}
					break;
				}
		}
		
		if (!$ignore_user)
		{
		
        $ret = sprintf ("%02d:%02d",$tm->hour,$tm->min);
		$ret = "<span class=datefont>$ret</span>";
		if ($from eq "<b>Robik</b>") { $from = "<span class=robotfont>$from</span>";}
		if ($m_to ne "")
		{
				$t_to = $m_to;
				if (length($m_to)>15)
				{
						$user_exists = 0;
						for ($j=0;$j<scalar(@users);$j++)
						{
								my ($nickname, $test_hash,$aa) = split("\t",$users[$j]);
								if ($test_hash eq $t_to)
								{
										$user_exists = 1;
										$t_to = $nickname;
										break;
								}
								
						}
						if ($user_exists == 0) 
						{
								$t_to = "???";
						}
				}
				
		
				if (($from eq $userName) || ($m_to eq $userName) || ($m_to eq $rndNum))
				{
						#$to need to be redefined in case of nonregistered user
						#$ret .= "<b><span class=userfont>[$from&nbsp;-&gt;&nbsp;$t_to]</span></b> $msg<br>";
						$ret = $private_message;
				}
				else
				{
						#private not for this user
						#$ret .= "<span class=userfont>[$from]</span>&nbsp;<span class=datefont>- </span><br>";
						$ret = $private_hidden;
				}
		}
		else
		{
		#non-private
			$ret = $message_format;
		}
		$ret =~ s/\[NICK\]/$from/g;
		$ret =~ s/\[PRIVATE\]/$lang{"whisper_to"}/g;
		$ret =~ s/\[TO\]/$t_to/g;
		$ret =~ s/\[HOURS\]/$tmp_hour/g;
		$ret =~ s/\[MIN\]/$tmp_min/g;
		$ret =~ s/\[SEC\]/$tmp_sec/g;
		$ret =~ s/\[MESSAGE\]/$msg/g;	
		
		$ret .= "<br><script>scroll(1,10000000)</script>\015\012";
	} else {$ret = "<jk>\015\012";}
    return $ret;

}
sub sigger
{

	my $sig = shift;
	#hope, PIPE is just somebody disconnected.
	if ($sig ne "PIPE")
	{
	foreach $client ($list->can_write(1))
	{
		$userbuffers{$client}.=show_message("1\t".time()."\t<b>Robik</b>\t\t".$lang{"server_restarting"}." <script>window.setTimeout('location.reload()',15000);</script>\t27",$userhashes{$client},$usernames{$client});
		my $buffer_length = length($userbuffers{$client});
		eval('$bytewriten = syswrite($client, $userbuffers{$client}, $buffer_length,0);');
		$list->remove($client);
		my_log($usernames{$client}." disconnected 'cause of $sig");
		delete $userhashes{$client};
		delete $usernames{$client};
		delete $userbuffers{$client};
		delete $usertails{$client};
		delete $user_incbuffers{$client};
		close($client);
		next; 	
	}
	close($vc_daemon);
	my_log("SigChecker: SIG$sig");
	open(PID,"> $pid_file");
	close(PID);
	die "sigger\n";
	}
}

sub restarter
{
	my $sig = shift;

	foreach $client ($list->can_write(1))
	{
		$userbuffers{$client}.=show_message("1\t".time()."\t<b>Robik</b>\t\t".$lang{"server_restarting"}." <script>window.setTimeout('location.reload()',15000);</script>\t27",$userhashes{$client},$usernames{$client});
		my $buffer_length = length($userbuffers{$client});
		eval('$bytewriten = syswrite($client, $userbuffers{$client}, $buffer_length,0);');
		$list->remove($client);
		my_log($usernames{$client}." disconnected 'cause of HUP");
		delete $userhashes{$client};
		delete $usernames{$client};
		delete $userbuffers{$client};
		delete $usertails{$client};
		delete $user_incbuffers{$client};
		close($client);
		next; 	
	}
	close($vc_daemon);
	$inter =1;
	sleep(4);
	open(PID,"> $pid_file");
	close(PID);	
	die "restarter\n";
}
