<?php
$title = 'Настройки игр';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($adm_id == 1) {

    echo '<div class="title">Настройки игр</div>';

    if (isset($_POST['settings'])) {

        $game_loto = intval($_POST['game_loto']);
        $game_num = intval($_POST['game_num']);
        $game_prmd = intval($_POST['game_prmd']);
 
        $error = '';

        if ($game_loto == 1) {
            if (empty($_POST['loto'])) {
                $error.= 'Лотерея: укажите количество участников!<br/>';
            }
            if (empty($_POST['loto_cena'])) {
                $error.= 'Лотерея: укажите стоимость лотерейного билета!<br/>';
            }
            elseif ($_POST['loto_cena'] < 0.01) {
                $error.= 'Лотерея: стоимость лотерейного билета не может быть меньше 0.01!<br/>';
            }
        }
        if ($game_num == 1) {
            if (empty($_POST['num_min'])) {
                $error.= 'Угадай число: укажите минимальную ставку!<br/>';
            }
            elseif ($_POST['num_min'] < 0.01) {
                $error.= 'Угадай число: минимальная ставка не может быть меньше 0.01!<br/>';
            }
            if (empty($_POST['num_max'])) {
                $error.= 'Угадай число: укажите максимальную ставку!<br/>';
            }
            elseif ($_POST['num_max'] < $_POST['num_min']) {
                $error.= 'Угадай число: максимальная ставка не может быть меньше минимальной!<br/>';
            }
            if (empty($_POST['c_num'])) {
                $error.= 'Угадай число: укажите максимальное количество ставок одного пользователя!<br/>';
            }
        }
        if ($game_prmd == 1) {
            if (empty($_POST['ptime'])) {
                $error.= 'Пирамида: укажите длительность игры!<br/>';
            }
            if (empty($_POST['pmin'])) {
                $error.= 'Пирамида: укажите минимальную начальную ставку!<br/>';
            }
            elseif ($_POST['pmin'] < 0.01) {
                $error.= 'Пирамида: минимальная начальная ставка в пирамиде не может быть меньше 0.01!<br/>';
            }
            if (empty($_POST['pmax'])) {
                $error.= 'Пирамида: укажите максимальную начальную ставку в пирамиде!<br/>';
            }
            elseif ($_POST['pmax'] < $_POST['pmin']) {
                $error.= 'Пирамида: максимальная начальная ставка не может быть меньше минимальной!<br/>';
            }
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            // Лотерея
            $sys['modules']['game_loto'] = $game_loto;
            if ($game_loto == 1) {
                $sys['system']['loto'] =  intval(abs($_POST['loto']));
                $sys['system']['loto_cena'] = floatval(abs($_POST['loto_cena']));
            }

            // Угадай число
            $sys['modules']['game_num'] = $game_num;
            if ($game_num == 1) {
                $sys['system']['num_min'] = floatval(abs($_POST['num_min']));
                $sys['system']['num_max'] = floatval(abs($_POST['num_max']));
                $sys['system']['c_num'] =  intval(abs($_POST['c_num']));
            }

            // Пирамида
            $sys['modules']['game_prmd'] = $game_prmd;
            if ($game_prmd == 1) {
                $sys['system']['ptime'] = ceil(abs($_POST['ptime']));
                $sys['system']['pmin'] = floatval(abs($_POST['pmin']));
                $sys['system']['pmax'] = floatval(abs($_POST['pmax']));
            }

            write_ini_file(FILE_CONFIG, $sys);

            header('Location: /adm/games');

        }

    }

    echo '<div class="menu">
    <form action="" method="POST">
    <div class="menu-title">Лотерея</div>
    Статус:<br/><select name="game_loto"><option value="1">Вкл.</option><option ' . ($sys['modules']['game_loto'] == 0 ? 'selected' : '') . ' value="0">Откл.</option></select><br/>
    Количество участников:<br/><input type="text" name="loto" value="'.$sys['system']['loto'].'"><br/>
    Стоимость лотерейного билета:<br/><input type="text" name="loto_cena" value="'.$sys['system']['loto_cena'].'"><br/>
    <div class="menu-title">Угадай число</div>
    Статус:<br/><select name="game_num"><option value="1">Вкл.</option><option ' . ($sys['modules']['game_num'] == 0 ? 'selected' : '') . ' value="0">Откл.</option></select><br/>
    Минимальная ставка:<br/><input type="text" name="num_min" value="'.$sys['system']['num_min'].'"><br/>
    Максимальная ставка:<br/><input type="text" name="num_max" value="'.$sys['system']['num_max'].'"><br/>
    Максимальное количество ставок одного пользователя:<br/><input type="text" name="c_num" value="'.$sys['system']['c_num'].'"><br/>
    <div class="menu-title">Пирамида</div>
    Статус:<br/><select name="game_prmd"><option value="1">Вкл.</option><option ' . ($sys['modules']['game_prmd'] == 0 ? 'selected' : '') . ' value="0">Откл.</option></select><br/>
    Длительность игры (в часах):<br/><input type="text" name="ptime" value="'.$sys['system']['ptime'].'"><br/> 
    Минимальная начальная ставка:<br/><input type="text" name="pmin" value="'.$sys['system']['pmin'].'"><br/>
    Максимальная начальная ставка:<br/><input type="text" name="pmax" value="'.$sys['system']['pmax'].'"><br/>
    <input type="submit" name="settings" value="Сохранить">
    </form></div>';

} else {
    header('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>