<?php
$title = 'Поиск по IP';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($adm_id == 1) {

    echo '<div class="title">Поиск по IP</div>
    <div class="menu">
    <form action="" method="GET">
    <input type="text" name="ip" value="'.($_GET['ip'] ?? '').'"><input type="submit" value="Поиск">
    </form></div>';

    if (isset($_GET['ip'])) {

        $error = '';

        if (empty($_GET['ip'])) {
            $error.= 'Введите IP-адрес!<br/>';
        }
        elseif (!filter_var($_GET['ip'], FILTER_VALIDATE_IP)) {
            $error.= 'IP-адрес введен неверно!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $stmt_cip = $connect->prepare("select count(*) from `authlog` where `ip` like ?");
            $stmt_cip->execute(array($_GET['ip']));
            $count_ip = $stmt_cip->fetchColumn();

            if ($count_ip == 0) {
                echo '<div class="menu">NONE</div>';
            } else {

                echo '<div class="menu">Найдено по запросу: '.$count_ip.'</div>';

                $page = new Pagination($count_ip, 10);
                $page->setLink('?ip='.$_GET['ip'].'&');

                $data = $connect->prepare("select * from `authlog` where `ip` like :ip order by `lasttime` desc limit :start, 10");
                $data->bindValue(':ip', $_GET['ip']);
                $data->bindValue(':start', $page->start, PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    echo '<div class="menu">
                    Пользователь: '.profileLink($row['uid']).'<br/>
                    Время авторизации: '.date('d.m.Y H:i', $row['time']).'<br/>
                    Последнее посещение: '.date('d.m.Y H:i', $row['lasttime']).deviceIcon($row['ua']).'<br/>
                    UA: '.$row['ua'].
                    ($row['status'] == 0 ? '<div class="forbidden">Авторизация сброшена!</div>' : '').'
                    </div>';

                }

                $page->navigation();

            }

        }

    }

} else {
    header ('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>