<?php
$title = 'Смайлы';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

if ($adm_id == 1 || $adm_id == 5) {

    $smiles = GlobFiles::findByMask(GlobFiles::MaskSmiles, GlobFiles::Smiles, true);
    $count_smiles = count($smiles);

    $dir = $_SERVER['DOCUMENT_ROOT'].'/img/smiles/';

    echo '<div class="title">Смайлы (' . $count_smiles . ')</div>';

    if ($count_smiles == 0) {

        echo '<div class="menu">Смайлов нет.</div>';

    } else {

        if (isset($_GET['del_all'])) {
            if (isset($_POST['cancel'])) {
                header('Location: /adm/smiles');
            }
            elseif (isset($_POST['yes'])) {
                GlobFiles::DelAllByMask(GlobFiles::MaskSmiles, GlobFiles::Smiles);
                header('Location: /adm/smiles'); 
            }
            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="yes" value="Удалить все смайлы"/> 
            <input type="submit" name="cancel" value="Отмена"/>
            </form></div>'; 
        }
        elseif (isset($_GET['del']) && isset($smiles[$_GET['del']])) {
            $filename = $smiles[$_GET['del']];
            if ($filename) {
                if (isset($_POST['cancel'])) {
                    header('Location: /adm/smiles');
                }
                elseif (isset($_POST['yes'])) {
                    unlink($filename);
                    header('Location: /adm/smiles'); 
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="Удалить смайл ('.basename($filename).')"/> 
                <input type="submit" name="cancel" value="Отмена"/>
                </form></div>'; 
            } else {
                header('Location: /adm/smiles');
            }
        }

        echo '<div class="menu">';

        foreach ($smiles as $key => $file) {

            $smile = basename($file);

            echo '<a href="?del=' . $key . '" title="Удалить"><img src="/img/smiles/' . $smile . '" alt="smile"></a>';

        }

        echo '<div class="information">Чтобы удалить смайл - кликните по нему.</div>
        </div>
        <div class="forlink"><a href="?del_all" class="links"><img src="/img/delete.png" alt="delete">Удалить все смайлы</a></div>';

    }

    echo '<div class="title">Новые смайлы</div>';

    if (isset($_POST['submit'])) {

        $error = '';
 
        $reFiles = reArrayFiles($_FILES['filename']);

        foreach ($reFiles as $file) {
            if (file_exists($file['tmp_name'])) {
                if (!BeforeUpload::AttachIMG($file)) {
                    $error.= $file['name'] . ': неверный тип файла!<br/>';
                }
                elseif (file_exists($dir . rus2translit($file['name']))) {
                    $error.= $file['name'] . ': смайл с таким именем уже есть!<br/>';
                }
                if ($file['size'] > 1024 * 32) {
                    $error.= $file['name'] . ': максимальный размер файла - 32 Kb!<br/>';
                }
            } else {
                unset($reFiles[$key]);
            }
        }
        if (count($reFiles) == 0) {
            $error.= 'Выберите хотя бы 1 файл!<br/>';
        }
        elseif (count($reFiles) > 10) {
            $error.= 'Нельзя загружать более 10 файлов одновременно!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {
            foreach ($reFiles as $file) {
                if (file_exists($file['tmp_name'])) {
                    // Заливаем
                    $full_path = $dir . rus2translit($file['name']);
                    move_uploaded_file($file['tmp_name'], $full_path);
                }
            }

            $_SESSION['scr_time'] = time();

            header('Location: /adm/smiles');

        }
    }

    echo '<div class="menu">
    <form action="" method="POST" enctype="multipart/form-data" name="form">
    <div id="inpContFile">
    <input type="file" name="filename[]" id="file"><br/>
    <input type="file" name="filename[]" id="file"><br/>
    <input type="file" name="filename[]" id="file"><br/>
    </div>
    <div class="butt1"><a href="javascript:AddFile()">Добавить еще</a></div><br/>
    <input type="submit" name="submit" value="Загрузить">
    </form></div>';

} else {
    header ('location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>