<?php

require_once($_SERVER["DOCUMENT_ROOT"]."/inc/file_function.php");
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/data_filter.php");
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/SimpleImage.php");
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/BeforeUpload.php");

$filename = isset($_GET['src']) ? $_SERVER["DOCUMENT_ROOT"] . base64_decode($_GET['src']) : false;

$size = sizeConv($_GET['size'] ?? '100x100');

if ($filename && $size && BeforeUpload::CheckImageSize($filename)) {

    $image = new SimpleImage($filename);

    if ($size[0] == 0) {

        $image->resizeToHeight($size[1]);

    } elseif ($size[1] == 0) {

        $image->resizeToWidth($size[0]);

    } else {

        $image->resize($size[0], $size[1]);

    }

    $image->output();

} else {

    header("Content-type: image/png");

    $img = imagecreate(176, 24);
    imagecolorallocate($img, 255, 255, 255);
    $color = imagecolorallocatealpha($img, random_int(50, 210), random_int(50, 210), random_int(50, 210), random_int(10, 30));
    imagestring($img, 5, 5, 3, 'Image Layout Error', $color);
    imagepng($img);
    imagedestroy($img);

}

 ?>