<?php

/* Проверка перед Upload */

class BeforeUpload {

    /* Расширения */

    const Archive = ['7z', 'zip', 'rar'];          // архивы
    const Picture = ['jpg', 'jpeg', 'png', 'bmp']; // картинки
    const Video = ['3gp', 'mp4'];                  // видео
    const Audio = 'mp3';                           // аудио
    const Icon = 'ico';                            // иконки
    const Gif = 'gif';                             // гифки

    // Работаем с $_FILES
    public static function ArrayFILES($files) {

        if (!is_array($files)) { // если не для upload

            $files['name'] = $files;

            $files['tmp_name'] = $files;

        }

        return $files;
    }

    // Пповерка расширения
    public static function CheckExtension($filename, $list = []) {

        $extension = get_extfile($filename);

        $check = (is_array($list) ? in_array($extension, $list) : $extension == $list);

        return ($check ? $extension : false);

    }

    // Пповерка размера картинки
    public static function CheckImageSize($filename, $width = false, $height = false) {

        $image = @getimagesize($filename);

        if ($image && exif_imagetype($filename)) {

            $check_width = ($width ? ($image[0] == $width) : ($image[0] > 0));

            $check_height = ($height ? ($image[1] == $height) : ($image[1] > 0));

            return ($check_width && $check_height);

        } else
            return false;

    }

    /* Для разных модулей */

    // Проверка всех графических файлов
    public static function AttachIMG($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return  (self::CheckImageSize($files['tmp_name']) &&
                (self::CheckExtension($files['name'], self::Picture)
              || self::CheckExtension($files['name'], self::Icon)
              || self::CheckExtension($files['name'], self::Gif)));

    }

    // Проверка архивов
    public static function AttachArchive($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return ((@RarArchive::open($files['tmp_name'])
              || @(new ZipArchive)->open($files['tmp_name'])) &&
                 self::CheckExtension($files['name'], self::Archive));

    }

    // Проверка всех файлов
    public static function AttachFile($files) {

        return (self::AttachIMG($files)
             || self::AttachArchive($files)
             || self::AttachMedia($files));

    }

    // Проверка медиа файлов (Видео & Аудио)
    public static function AttachMedia($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return  (self::CheckExtension($files['name'], self::Video)
              || self::CheckExtension($files['name'], self::Audio));

    }

    // Проверка иконок
    public static function AttachIcon($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return  (self::CheckImageSize($files['tmp_name']) &&
                (self::CheckExtension($files['name'], self::Picture)
              || self::CheckExtension($files['name'], self::Icon)));

    }

    // Проверка гифок
    public static function AttachGif($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return (self::CheckImageSize($files['tmp_name']) &&
                self::CheckExtension($files['name'], self::Gif));

    }

    // Проверка картинок
    public static function AttachPicture($files) {

        $files = self::ArrayFILES($files);

        if (!is_readable($files['tmp_name']))
            return false; // если нечитабельный файл

        return (self::CheckImageSize($files['tmp_name']) &&
                self::CheckExtension($files['name'], self::Picture));

    }

}