<?php

/* Поиск файлов */

class GlobFiles {

    // Файлы
    const Files = '/files/';

    // Магазин
    const FileShop = '/files/shop/';

    // Аватарки юзеров
    const UserAvatar = '/files/avatar/';

    // Иконки юзеров
    const UserIcon = '/files/icon/';

    // Картинки
    const SiteLogo = '/img/';

    // Смайлы
    const Smiles = '/img/smiles/';

    // Маска для смайлов
    const MaskSmiles = ['*.{jpg,jpeg,gif,png}', GLOB_BRACE];

    // Маска для файлов почты
    const MaskMail = '_mail_*';

    // Маска для файлов заданий
    const MaskTask = '_task_*';

    // Маска для иконки товара
    const MaskShopIcon = '_shopIcon_*';

    // Маска для файлов к комментариям
    const MaskComment = '_comment_*';

    // Маска для файлов форума
    const MaskForum = '_*_forum_*';

    // Маска для скринов
    const MaskScreen = '_*_screen_*';

    /* Поиск по ID */

    public static function findById($id, $dir, $params = false, $all = false) {

        $mask = is_array($params) && isset($params[0]) ? $params[0] : $params;
        $flags = is_array($params) && isset($params[1]) ? $params[1] : 0;

        $path = $_SERVER['DOCUMENT_ROOT'] . $dir;

        $mask = $id . ($mask ? $mask : '_*');

        $files = glob($path . $mask, $flags);

        return ($all ? $files : (isset($files[0]) && is_readable($files[0]) ? $files[0] : false));

    }

    /* Поиск по маске */

    public static function findByMask($params, $dir, $all = false) {

        $mask = is_array($params) && isset($params[0]) ? $params[0] : $params;
        $flags = is_array($params) && isset($params[1]) ? $params[1] : 0;

        $path = $_SERVER['DOCUMENT_ROOT'] . $dir;

        $files = glob($path . $mask, $flags);

        return ($all ? $files : (isset($files[0]) && is_readable($files[0]) ? $files[0] : false));

    }

    /* Массовое удаление по ID */

    public static function DelAllById($id, $dir, $params = false) {

        $mask = is_array($params) && isset($params[0]) ? $params[0] : $params;
        $flags = is_array($params) && isset($params[1]) ? $params[1] : 0;

        $path = $_SERVER['DOCUMENT_ROOT'] . $dir;

        $mask = $id . ($mask ? $mask : '_*');

        $files = glob($path . $mask, $flags);

        $names = [];

        foreach ($files as $file) {

            // удаляем
            if (unlink($file))
                $names[] = basename($file);

        }

        // возвращаем массив имён удалённых файлов
        return ($names ? $names : true);

    }

    /* Массовое удаление по маске */

    public static function DelAllByMask($params, $dir) {

        $mask = is_array($params) && isset($params[0]) ? $params[0] : $params;
        $flags = is_array($params) && isset($params[1]) ? $params[1] : 0;

        $path = $_SERVER['DOCUMENT_ROOT'] . $dir;

        $files = glob($path . $mask, $flags);

        $names = [];

        foreach ($files as $file) {

            // удаляем
            if (unlink($file))
                $names[] = basename($file);

        }

        // возвращаем массив имён удалённых файлов
        return ($names ? $names : true);

    }

}