<?php

// Постраничная навигация

class Pagination {

    public $k_post, $post, $k_page, $page, $start, $end;
    private $link = '?';
    private $get = 'page';

    function __construct($k_post, $post) {

        $this->k_post = intval($k_post);
        $this->post = intval($post);

        $this->k_page = $this->k_post != 0 ? ceil($this->k_post / $this->post) : 1;
        $this->page = $this->page();
        $this->end = $this->post * $this->page;
        $this->start = $this->end - $this->post;

    }

    /* Сортировка массива для постраничной навигации */

    public function pageDataArray($dataArray) {

        $pagedData = [];

        $indArr = 0;

        foreach ($dataArray as $value) {

            if ($indArr >= $this->start &&
                $indArr < $this->end)
                    $pagedData[] = $value;

            $indArr++;

        }

        return $pagedData;

    }

    public function setLink($link) {

        $this->link = $link;

    }

    public function setGET($get) {

        $this->get = $get;
        $this->page = $this->page();
        $this->end = $this->post * $this->page;
        $this->start = $this->end - $this->post;

    }

    public function page() {

        if (isset($_GET[$this->get])) {

            if ($_GET[$this->get] == 'end') {

                $page = $this->k_page;

            } elseif (is_numeric($_GET[$this->get])) {

                $page = $_GET[$this->get];

            }

            if ($page < 1) {

                $page = 1;

            } else {

                if ($page > $this->k_page) {

                     $page = $this->k_page;

                }

            }

        } else {

            $page = 1;

        }

        return intval($page);

    }

    public function navigation($return = false) {

        $output = NULL;

        if ($this->k_page > 1) {

            $output .= '<div class="menu">
            <div class="page">';

            if ($this->page != 1) {

                $output .= '<a href="' . $this->link . $this->get . '=1">1</a>';

            } else {

                $output .= '<span>1</span>';

            }

            for ($i = -3; $i <= 3; $i++) {

                if ($this->page + $i > 1 && $this->page + $i < $this->k_page) {

                    if ($i == -3 && $this->page + $i > 2) {

                        $output .= '<span>...</span>';

                    }

                    if ($i != 0) {

                        $output .= '<a href="' . $this->link . $this->get . '=' . ($this->page + $i) . '">' . ($this->page + $i) . '</a>';

                    } else {

                        $output .= '<span>' . ($this->page + $i) . '</span>';

                    }

                    if ($i == 3 && $this->page + $i < $this->k_page - 1) {

                        $output .= '<span>...</span>';

                    }

                }

            }

            if ($this->page != $this->k_page) {

                $output .= '<a href="' . $this->link . $this->get . '=end" class="end">' . $this->k_page . '</a>';

            } elseif ($this->k_page > 1) {

                $output .= '<span>' . $this->k_page . '</span>';

            }

            $output .= '</div></div>';

        }

        if ($return) {

            return $output;

        } else {

            echo $output;

        }

    }

}