<?php

// <br/> => \n
function br2nl($str) {

    $str = preg_replace('/\<br(\s*)?\/?\>/i', PHP_EOL, $str);

    return $str;

}

// Функция ББ кодов
function bb($str) {
 
    // Перенос текста
    $str = preg_replace('#\[br\]#si', '<br/>', $str);

    // Жирный шрифт
    $str = preg_replace('#\[b\](.*?)\[/b\]#si', '<b>\1</b>', $str);

    // Наклоненный шрифт
    $str = preg_replace('#\[i\](.*?)\[/i\]#si', '<i>\1</i>', $str);

    // Подчеркнутый шрифт
    $str = preg_replace('#\[u\](.*?)\[/u\]#si', '<u>\1</u>', $str);

    // Зачеркнутый шрифт
    $str = preg_replace('#\[del\](.*?)\[/del\]#si', '<del>\1</del>', $str);

    // Маленький шрифт
    $str = preg_replace('#\[small\](.*?)\[/small\]#si', '<small>\1</small>', $str);

    // Цветной шрифт
    $str = preg_replace('#\[color=(.*?)\](.*?)\[/color\]#si', '<font color="\1">\2</font>', $str);

    // Градиент текста
    $str = preg_replace('#\[gradient=(.*?),(.*?)\](.*?)\[/gradient\]#si', '<span style="background: linear-gradient(135deg, \1 20%, \2 70%);-webkit-background-clip: text;-webkit-text-fill-color: transparent;">\3</span>', $str);

    // Цитата
    $str = preg_replace('#\[cit\](.*?)\[/cit\]#si', '<div class="cit">\1</div>', $str);

    // Подсветка кода
    $str = preg_replace_callback(

        '#\[php\](.*?)\[/php\]#si',

        function($matches) {

            $code = $matches[1];

            $code = htmlspecialchars_decode($code, ENT_QUOTES);

            $code = highlight_string($code, true);

            $code = br2nl($code);

            return $code;

        },

        $str

    );

    return $str;

}

// Видео с YouTube
function bbyoutube($str) {

    $str = preg_replace('#\[youtube=(.*?)\]#si', '<iframe width="100%" src="https://www.youtube.com/embed/\1" frameborder="0" allowfullscreen></iframe>', $str);

    return $str;

}

// Ссылки
function bblinks($link) {

    $link = preg_replace_callback(

        '~\\[url=(https?://.+?)\\](.+?)\\[/url\\]|(https?://[0-9a-zA-Z\.\-]+\.[0-9a-zA-Z]{2,6}[0-9a-zA-Z/\?\.\-\~&;_=%:#\+]*)~',

        function($matches) {

            $regexp = '#^https?://'.$_SERVER['HTTP_HOST'].'/?(.*?)$#i';

            if (isset($matches[3])) {

                $url = '<a data-noajax href="' . (preg_match($regexp, $matches[3]) ? $matches[3] : '/go/' . base64_encode($matches[3])) . '">' . $matches[3] . '</a>';

            } else {

                $url = '<a data-noajax href="' . (preg_match($regexp, $matches[1]) ? $matches[1] : '/go/' . base64_encode($matches[1])) . '">' . $matches[2] . '</a>';

            }

            return $url;

        },

        $link

    );

    return $link;

}

// Функция вывода смайлов
function smiles($str) {

    $smiles = GlobFiles::findByMask(GlobFiles::MaskSmiles, GlobFiles::Smiles, true);

    foreach ($smiles as $file) {

        $smile = basename($file);

        $str = str_replace(':' . mb_substr($smile, 0, -4) . ':', '<img src="/img/smiles/' . $smile . '" alt="smile">', $str);

    }

    return $str;

}