<?php

/*
 * RekmixaCMS - The Newest Multifunctional Content Management System
 * Author - rekmixa
 * E-mail - rekmixa@gmail.com
 * Site - http://wordads.ru
 */

$title = 'Установка RCMS';

require_once("head.php");

/* Установка */

$step = $_GET['step'] ?? false;

switch ($step) {

    case 'complete':

        if (isset($_SESSION['complete_install'])) {

            // Удаляем папку install
            if (delete_dir(__DIR__)) {

                header('Location: /');

            }

        } else {

            // Возвращаем к началу
            header('Location: /install');

        }

        break;

    case 'db':

        echo '<div class="title">Подключение к БД</div>';

        if (isset($_POST['install'])) {

            $error = '';

            if (empty($_POST['host']) || empty($_POST['base']) || empty($_POST['user']) || empty($_POST['password'])) {
                $error.= 'Вы не заполнили одно из полей!<br/>';
            } else {
                try {
                    $connect = new PDO('mysql:host=' . $_POST['host'] . ';dbname=' . $_POST['base'], $_POST['user'], $_POST['password']);
                } catch (PDOException $e) {
                    $error.= 'Подключение не удалось: ' . $e . '<br/>';
                }
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                /* Заливка таблиц */

                $connect->exec("SET CHARACTER SET utf8");

                $tables = SQLParser::getQueriesFromFile("tables.sql");

                foreach ($tables as $sql) {

                    $connect->exec($sql);

                }

                // CHMOD
                chmod($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php", 0666);
                chmod("system.ini", 0666);

                /* Настройки */

                $sys['db']['db_host'] = $_POST['host'];
                $sys['db']['db_user'] = $_POST['user'];
                $sys['db']['db_pass'] = $_POST['password'];
                $sys['db']['db_name'] = $_POST['base'];

                if (isset($_SERVER['SERVER_ADMIN']) && filter_var($_SERVER['SERVER_ADMIN'], FILTER_VALIDATE_EMAIL))
                    $sys['system']['mail'] = $_SERVER["SERVER_ADMIN"];

                write_ini_file("system.ini", $sys);

                // Переносим файл настроек в папку inc
                rename("system.ini", $_SERVER["DOCUMENT_ROOT"]."/inc/system.ini");

                $_SESSION['complete_install'] = 1; // разрешаем завершить установку
 
                echo '<div class="menu">
                <ul class="tick">
                <li>Соединение с БД установлено!</li>
                <li>Таблицы успешно залиты!</li>
                <li>Права на файлы конфигурации установлены!</li>
                </ul>
                <div class="butt5"><a href="?step=complete">Завершить установку</a></div></div>
                </div>';

            }

        }

        echo '<div class="menu">
        <form method="POST">
        Хост:<br/><input type="text" name="host" value="localhost" /><br/>
        Пользователь:<br/><input type="text" name="user"><br/>
        Пароль:<br/><input type="text" name="password"><br/>
        База данных:<br/><input type="text" name="base"><br/>
        <input type="submit" name="install" value="Продолжить установку">
        </form></div>';

        break;

    default:

        echo '<div class="title">Подготовка к установке</div>
        <div class="menu">
        <div class="good">Скрипт готов к установке!</div>
        <div class="butt5"><a href="?step=db">Начать установку</a></div>
        </div>';

}

require("foot.php");

?>