<?php
$title = 'Донат';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if ($sys['modules']['donat_s'] != 0) {

    $row = user($id);

    if ($row) {

        if (DonatesAllowed($row)) {

            echo '<div class="title">Донат<span class="white-right-block-txt">Пользователю '.profileLink($row).'</span></div>';

            if (isset($active) && $id == $user['id']) {
                echo '<div class="menu"><div class="danger">Нельзя отправлять донат самому себе!</div></div>';
            } else {
                if ((!$sys['payment']['wmr'] || !$sys['payment']['hash']) &&
                    (!$sys['payment']['wk_id'] || !$sys['payment']['wk_hash']) &&
                    (!$sys['payment']['wpk_id'] || !$sys['payment']['wpk_hash']) &&
                     !isset($active)) {

                    echo '<div class="menu"><div class="danger">Способы оплаты не настроены!</div></div>';

                } else {

                    if (isset($_POST['submit'])) {

                        $error = '';

                        if (!isset($active)) {
                            if (empty($_POST['code'])) {
                                $error.= 'Введите код с картинки!<br/>';
                            }
                            elseif ($_SESSION['code'] != $_POST['code']) {
                                $error.= 'Код с картинки введен неверно!<br/>';
                            }
                        }
                        if (!$error) {
                            if (empty($_POST['sum'])) {
                                $error.= 'Введите сумму доната!<br/>';
                            }
                            elseif (!is_numeric($_POST['sum'])) {
                                $error.= 'Неверное значение!<br/>';
                            } 
                            elseif ($_POST['sum'] < $sys['system']['donat_sum']) {
                                $error.= 'Минимальна сумма доната - '.rub($sys['system']['donat_sum']).'!<br/>';
                            }
                            if (empty($_POST['pay'])) {
                                $error.= 'Выберите способ оплаты!<br/>';
                            }
                            if (!empty($_POST['comment']) && (mb_strlen($_POST['comment']) < 5 || mb_strlen($_POST['comment']) > 250)) {
                                $error.= 'Комментарий к донату должен содержать от 5 до 250 символов!<br/>';
                            }
                        }
                        if ($error) {
                            echo '<div class="menu">'.$error.'</div>';
                        } else {

                            $sum = intval($_POST['sum']);
                            $chet = random_int(11111, 99999);
                            $donater = $user['id'] ?? 0;
                            $comment = 'Донат пользователю: '.$row['login'];
                            $pay = $connect->prepare("insert into `plus` set `time` = ?, `type` = ?, `status` = ?, `donater` = ?, `uid` = ?, `sum` = ?, `num` = ?, `comment` = ?");

                            switch ($_POST['pay']) {

                                case 1:

                                    if (!$sys['payment']['wmr'] || !$sys['payment']['hash']) {
                                        echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                                    } else {

                                        if ($pay->execute(array(time(), 1, 0, $donater, $id, $sum, $chet, $_POST['comment']))) {

                                            echo '<div class="menu">
                                            <form data-noajax action="https://merchant.webmoney.ru/lmi/payment.asp" method="POST">
                                            <input type="hidden" name="LMI_PAYMENT_AMOUNT" value="'.$sum.'">
                                            <input type="hidden" name="LMI_PAYMENT_DESC_BASE64" value="'.base64_encode($comment).'">
                                            <input type="hidden" name="LMI_PAYMENT_NO" value="'.$chet.'">
                                            <input type="hidden" name="LMI_PAYEE_PURSE" value="'.$sys['payment']['wmr'].'">
                                            <input type="hidden" name="LMI_SIM_MODE" value="0">
                                            <input type="submit" value="Перейти к оплате ('.rub($sum).')">
                                            </form></div>';

                                        } else {
                                            echo '<div class="menu">Произошла ошибка!</div>';
                                        }
                                    }

                                    break;

                                case 2:

                                    if (!$sys['payment']['wk_id'] || !$sys['payment']['wk_hash']) {
                                        echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                                    } else {

                                        $data = file_get_contents('http://worldkassa.ru/user/oplata.php?id_shop='.$sys['payment']['wk_id'].'&summa='.$sum.'&hash='.$sys['payment']['wk_hash'].'&desc='.urlencode($comment));

                                        if (is_numeric($data) && $pay->execute(array(time(), 1, 0, $donater, $id, $sum, $data, $_POST['comment']))) {
                                            header('Location: http://worldkassa.ru/user/oplata.php?uniq='.$data);
                                        } else {
                                            echo '<div class="menu">Произошла ошибка!</div>';
                                        }
                                    }

                                    break;

                                case 3:

                                    if (!$sys['payment']['wpk_id'] || !$sys['payment']['wpk_hash']) {
                                        echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                                    } else {

                                        if ($pay->execute(array(time(), 1, 0, $donater, $id, $sum, $chet, $_POST['comment']))) {

                                            echo '<form data-noajax method="POST" action="https://wapkassa.ru/merchant/payment">
                                            <div class="menu">
                                            <input type="hidden" name="WK_PAYMENT_SITE" value="'.$sys['payment']['wpk_id'].'">
                                            <input type="hidden" name="WK_PAYMENT_AMOUNT" value="'.$sum.'">
                                            <input type="hidden" name="WK_PAYMENT_COMM" value="'.$comment.'">
                                            <input type="hidden" name="WK_PAYMENT_HASH" value="'.strtoupper(hash('sha256', $sys['payment']['wpk_id'].$sum.$sys['payment']['wpk_hash'])).'">
                                            <input type="hidden" name="WK_PAYMENT_ID" value="'.$chet.'">
                                            <input type="submit" value="Перейти к оплате ('.rub($sum).')">
                                            </div></form>';

                                        } else {
                                            echo '<div class="menu">Произошла ошибка!</div>';
                                        }
                                    }

                                    break;

                                default:

                                    if (isset($active)) {
                                        if ($user['money'] < $sum) {
                                            echo '<div class="menu">Недостаточно средств!</div>';
                                        } else {
                                            if (pay(-$sum, $donater) && pay($sum, $id) &&
                                                $pay->execute(array(time(), 1, 1, $donater, $id, $sum, 0, $_POST['comment']))) {

                                                header('Refresh: 2');

                                                notification('Вам отправили [url='.ROOT.'/donation/log]донат[/url]', $id);

                                                echo '<div class="menu"><div class="good">Донат успешно отправлен!</div></div>';

                                            } else {
                                                echo '<div class="menu">Произошла ошибка!</div>';
                                            }
                                        }
                                    } else {
                                        echo '<div class="menu">Вы не авторизованы!</div>';
                                    }
                            }
                        }
                    }

                    echo '<div class="menu">
                    <form data-noajax action="" method="POST">
                    Сумма:<br/><input type="text" name="sum" value="'.$sys['system']['donat_sum'].'"><br/>
                    Способ оплаты:<br/><select name="pay">
                    '.(isset($active) ? '<option value="4">С баланса аккаунта</option>' : '').
                    ($sys['payment']['wmr'] && $sys['payment']['hash'] ? '<option value="1">WebMoney Merchant</option>' : '').
                    ($sys['payment']['wk_id'] && $sys['payment']['wk_hash'] ? '<option value="2">WorldKassa</option>' : '').
                    ($sys['payment']['wpk_id'] && $sys['payment']['wpk_hash'] ? '<option value="3">WapKassa</option>' : '').'
                    </select><br/>
                    Комментарий к донату [5-250]:<br/><input type="text" name="comment"><br/>
                    '.(!isset($active) ? 'Код с картинки:<img id="captcha" src="/img/code.php" alt="check" onClick="UpCaptcha()"><br/>
                    <input type="text" name="code"><br/>' : '').'
                    <input type="submit" name="submit" value="Продолжить">
                    </form></div>';

                }

            }

        } else {
            header('location: /');
        }
    } else {
        header('location: /');
    }
} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>