<?php
$title = 'Друзья';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {

    if ($count_req > 0) {

        echo '<div class="title">Заявки в друзья ('.$count_req.')</div>';

        $stmt_num = $connect->prepare("select count(*) from `friend` where `status` = '0' and `to` = ? and `from` = ?");
        $stmt = $connect->prepare("update `friend` set `status` = ? where `status` = '0' and `to` = ? and `from` = ?");

        if (isset($_GET['yes'])) {
            $stmt_num->execute(array($user['id'], $_GET['yes']));
            if ($stmt_num->fetchColumn()) {
                if (isset($_POST['yes'])) {
                    if ($stmt->execute(array(1, $user['id'], $_GET['yes']))) {
                        notification('[b]'.$user['login'].'[/b] принял вашу заявку в друзья.', $_GET['yes']);
                        header('location: /friends');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['cancel'])) {
                    header('location: /friends');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="Добавить в друзья ('.intval($_GET['yes']).')">
                <input type="submit" name="cancel" value="Отмена">
                </form>
                </div>';
            } else {
                header('location: /friends');
            }
        }
        elseif (isset($_GET['no'])) {
            $stmt_num->execute(array($user['id'], $_GET['no']));
            if ($stmt_num->fetchColumn()) {
                if (isset($_POST['yes'])) {
                    if ($stmt->execute(array(2, $user['id'], $_GET['no']))) {
                        notification('[b]'.$user['login'].'[/b] отклонил вашу заявку в друзья.', $_GET['no']);
                        header('location: /friends');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['cancel'])) {
                    header('location: /friends');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="Отклонить заявку ('.intval($_GET['no']).')">
                <input type="submit" name="cancel" value="Отмена">
                </form>
                </div>';
            } else {
                header('location: /friends');
            }
        }

        $page = new Pagination($count_req, 5);
        $page->setGET('page_req');

        $data = $connect->prepare("select * from `friend` where `status` = '0' and `to` = :user order by `from` desc limit :start, 5");
        $data->bindValue(':user', $user['id'], PDO::PARAM_INT);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            echo '<div class="user-forlink">'.profileLink($row['from']).'
            <span class="butt1"><a href="?yes='.$row['from'].'">Добавить</a><a href="?no='.$row['from'].'">Отклонить</a></span>
            <span class="online">'.online($row['from']).'</span>
            </div>';

        }

        $page->navigation();

    }

    echo '<div class="title">Друзья ('.$count_friends.')</div>';

    $stmt_num = $connect->prepare("select count(*) from `friend` where `status` = '1' and (`from` = :from and `to` = :to or `from` = :to and `to` = :from)");

    if (isset($_GET['del'])) {
        $stmt_num->execute(array(':from' => $user['id'], ':to' => $_GET['del']));
        if ($stmt_num->fetchColumn()) {
            if (isset($_POST['cancel'])) {
                header('Location: /friends');
            }
            elseif (isset($_POST['ok'])) {
                if ($del_friend->execute(array(':from' => $user['id'], ':to' => $_GET['del']))) {
                    notification('[b]'.$user['login'].'[/b] удалил вас из друзей.', $_GET['del']);
                    header('Location: /friends');
                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
            echo '<div class="menu">
            <form action="" method="POST">
            <input type="submit" name="ok" value="Удалить из друзей ('.intval($_GET['del']).')">
            <input type="submit" name="cancel" value="Отмена">
            </form>
            </div>';
        } else {
            header('Location: /friends');
        }
    }

    if ($count_friends == 0) {
        echo '<div class="menu">Вы еще не добавляли друзей.</div>';
    } else {

        $page = new Pagination($count_friends, 10);

        $data = $connect->prepare("select * from `friend` where `status` = '1' and (`from` = :uid or `to` = :uid) order by `point` desc limit :start, 10");
        $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            $friend = $row['from'] == $user['id'] ? $row['to'] : $row['from'];

            echo '<div class="user-forlink">'.profileLink($friend).'
            <a href="?del='.$friend.'"><img src="/img/del.png" alt="del"></a>
            <span class="online">'.online($friend).'</span></div>';

        }

        $page->navigation();

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>