<?php
$title = 'История выплат';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");

switch ($act) {

    case 'my':

        if (isset($active)) {

            echo '<div class="title">Мои выплаты ('.$c_user_payment.')</div>
            <div class="menu">Вам выплачено: '.rub($user_payment).'</div>';

            if ($c_user_payment == 0) {
                echo '<div class="menu">Записей нет.</div>';
            } else {

                $page = new Pagination($c_user_payment, 10);

                $data = $connect->prepare("select * from `payment` where `uid` = :uid order by `id` desc limit :start, 10");
                $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
                $data->bindValue(':start', $page->start, PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    echo '<div class="menu">
                    Сумма: '.rub($row['money']).'<br/>
                    '.($row['status'] > 0 ? '<br/>Дата: '.daytime($row['time']) : '').
                    ($row['status'] == 1 ? '<div class="good">Выплачено</div>' : ($row['status'] == 2 ? '<div class="forbidden">Отказано в выплате</div>' : '<div class="information">В обработке</div>')).'
                    </div>';

                }

                $page->navigation();

            }

            echo '<div class="forlink"><a href="/info/payment" class="links"><img src="/img/history.png" alt="history">История выплат</a></div>';

        } else {
            header('Location: /');
        }

        break;

    case 'best':

        echo '<div class="title">Рейтинг по выплатам ('.$rate_payment.')</div>';

        if ($rate_payment == 0) {
            echo '<div class="menu">Рейтинг пуст.</div>';
        } else {

            $page = new Pagination($rate_payment, 10);

            $data = $connect->prepare("select *, sum(`money`) as `summa`, count(*) as `count` from `payment` group by `uid` order by `summa` desc limit :start, 10");
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {

                echo '<div class="user-forlink">'.profileLink($row['uid']).'<div class="chi">Выплат: '.$row['count'].' / '.rub($row['summa']).'</div></div>';

            }

            $page->navigation();

        }

        echo '<div class="forlink"><a href="/info/payment" class="links"><img src="/img/history.png" alt="history">История выплат</a></div>';

        break;

    default:

        echo '<div class="title">История выплат ('.$all_payment.')</div>';

        if ($all_payment == 0) {
            echo '<div class="menu">Записей нет.</div>';
        } else {

            $page = new Pagination($all_payment, 10);

            $data = $connect->prepare("select * from `payment` order by `id` desc limit :start, 10");
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {

                echo '<div class="menu">
                Сумма: '.rub($row['money']).'<br/>
                Пользователь: '.profileLink($row['uid']).
                ($adm_id == 1 || $adm_id == 5 ? '<br/>Кошелек: <img src="/img/wmr.png" alt="wmr">'.$row['wmr'] : '').
                ($row['status'] > 0 ? '<br/>Дата: '.daytime($row['time']) : '').
                ($row['status'] == 1 ? '<div class="good">Выплачено</div>' : ($row['status'] == 2 ? '<div class="forbidden">Отказано в выплате</div>' : '<div class="information">В обработке</div>')).'
                </div>';

            }

            $page->navigation();

        }

        echo '<div class="forlink"><a href="/info/payment/best" class="links"><img src="/img/stars.png" alt="stars">Рейтинг по выплатам</a></div>
        <div class="title">Статистика</div>
        <div class="menu">
        Заявок в обработке: '.$count_payment.'<br/>
        Выполнено заявок: '.$yes_payment.'<br/>
        Не выполнено заявок: '.$no_payment.'
        </div>
        <div class="menu">
        '.(isset($active) ? 'Вам выплачено: '.rub($user_payment).'<br/>' : '').'
        Всего выплачено: '.rub($sum_payment).'
        </div>';

        if (isset($active))
            echo '<div class="forlink"><a href="/info/payment/my" class="links"><img src="/img/history.png" alt="history">Мои выплаты<div class="chi">'.$c_user_payment.'</div></a></div>';

}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>