<?php
$title = 'Новая площадка';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['serf'] == 1) {

    echo '<div class="title">Новая площадка</div>';

    if (isset($_POST['submit'])) {

        $stmt_num = $connect->prepare("select count(*) from `link` where `url` = ?");
        $stmt_num->execute(array($_POST['url']));

        $error = '';

        if (empty($_POST['url'])) {
            $error.= 'Введите URL!<br/>';
        }
        elseif (mb_strlen($_POST['url']) < 5 || mb_strlen($_POST['url']) > 250) {
            $error.= 'URL должен содержать от 5 до 250 символов!<br/>';
        }
        elseif ($stmt_num->fetchColumn()) {
            $error.= 'Площадка с данным URL уже есть в системе!<br/>';
        }
        elseif (!isSiteAvailable($_POST['url'])) {
            $error.= 'URL недоступен или введен не правильно!<br/>';
        }
        if (empty($_POST['name'])) {
            $error.= 'Введите название!<br/>';
        }
        elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 75) {
            $error.= 'Название должно содержать от 5 до 75 символов!<br/>';
        }
        if (empty($_POST['cena'])) {
            $error.= 'Введите цену перехода!<br/>';
        }
        elseif ($_POST['cena'] < $sys['system']['cena']) {
            $error.= 'Минимальная цена перехода - '.rub($sys['system']['cena']).'!<br/>';
        }
        elseif (empty($_POST['col'])) {
            $error.= 'Введите количество переходов!<br/>';
        }
        elseif (!is_numeric($_POST['col'])) {
            $error.= 'Неверное значение!<br/>';
        } 
        elseif ($_POST['col'] < 10) {
            $error.= 'Минимальное количество переходов - 10!<br/>';
        }
        elseif ($user['money'] < $_POST['col'] * $_POST['cena']) {
            $error.= 'Недостаточно средств!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $col = intval($_POST['col']);
            $cena = floatval($_POST['cena']);
            $sum = $col * $cena;
            $status = ($adm_id == 1 || $sys['modules']['mod_s'] == 1) ? 1 : 3;

            $stmt = $connect->prepare("insert into `link` set `time` = ?, `url` = ?, `name` = ?, `click` = ?, `memory` = ?, `cena` = ?, `uid` = ?, `status` = ?");

            if (pay(-$sum, $user['id']) && $stmt->execute(array(time(), $_POST['url'], $_POST['name'], $col, $col, $cena, $user['id'], $status))) {
                header('Location: /link');
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }
    echo '<div class="menu">
    <form action="" method="POST">
    URL-адрес [5-250]:<br/><input type="text" name="url" value="http://"><br/>
    Название [5-75]:<br/><input type="text" name="name"><br/>
    Количество переходов:<br/><input type="text" name="col" value="10"><br/>
    Цена перехода:<br/><input type="text" name="cena"><br/>
    <input type="submit" name="submit" value="Создать площадку">
    </form></div>';

    echo '<div class="forlink"><a href="/link" class="links"><img src="/img/link.png" alt="">Мои площадки</a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>