<?php
$title = 'Мои площадки';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['serf'] == 1) {

    if ($links > 0) {

        echo '<div class="title">Массовое пополнение баланса площадок</div>';

        // prepared
        $stmt_nulled = $connect->prepare("select count(*) from `link` where `uid` = ? and `click` = ?");
        $memory = $connect->prepare("update `users` set `memory_serf` = ? where `id` = ?");
        $mass_bs = $connect->prepare("update `link` set `click` = `click` + ? where `id` = ?");

        if (isset($_POST['mass_bs'])) {

            $stmt_nulled->execute(array($user['id'], 0));

            if (isset($_POST['nulled']) && !$stmt_nulled->fetchColumn()) {
                $error.= 'Площадок с нулевым балансом нет!<br/>';
            }
            elseif (empty($_POST['col'])) {
                $error.= 'Введите количество переходов!<br/>';
            }
            elseif (!is_numeric($_POST['col'])) {
                $error.= 'Неверное значение!<br/>';
            }
            elseif ($_POST['col'] < 10) {
                $error.= 'Минимальное количество переходов - 10!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $success = 0; // успешных пополнений

                $col = intval($_POST['col']);

                $data = $connect->prepare("select * from `link` where `uid` = :uid order by `id` desc");
                $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
                $data->execute();
                $sql = $data->fetchAll();

                foreach ($sql as $row) {

                    // checkbox "nulled"
                    if (isset($_POST['nulled'])
                          && $row['click'] > 0)
                                        continue;

                    // сумма
                    $sum = $col * $row['cena'];

                    // если заблокирована, то не пополняем
                    if ($row['status'] == 2)
                                        continue;

                    // если недостаточно средств, то не пополняем
                    if ($user['money'] < $sum)
                                        continue;

                    // пополняем
                    if (pay(-$sum, $user['id']) &&
                        $mass_bs->execute(array($col, $row['id'])))
                            $success++; // +1 к успешным пополнениям

                }

                // эффект памяти :)
                if ($success > 0)
                    $memory->execute(array($col, $user['id']));

                header('Location: /link');

            }

        }

        echo '<div class="menu">
        <form action="" method="POST">
        Количество переходов:<br/><input type="text" name="col" value="'.($user['memory_serf'] > 0 ? $user['memory_serf'] : '').'"><br/>
        <input type="checkbox" name="nulled" value="1">Площадкам с нулевым балансом<br/>
        <input type="submit" name="mass_bs" value="Пополнить">
        </form></div>';

    }

    echo '<div class="title">Мои площадки ('.$links.')</div>
    <div class="forlink"><a href="/link/add" class="links"><img src="/img/add.png" alt="add">Создать площадку</a></div>';

    $num_u = $connect->prepare("select count(*) from `link` where `id` = ? and `uid` = ?");
    $strow = $connect->prepare("select * from `link` where `id` = ?");

    if (isset($_GET['edit'])) {
        $num_u->execute(array($_GET['edit'], $user['id']));
        if ($num_u->fetchColumn()) {
            $strow->execute(array($_GET['edit']));
            $row = $strow->fetch();
            if ($row['status'] == 2) {
                header('Location: /link');
            } else {
                if (isset($_POST['yes'])) {

                    $stmt_num = $connect->prepare("select count(*) from `link` where `url` = ? and `id` != ?");
                    $stmt_num->execute(array($_POST['url'], $_GET['edit']));

                    $cena = isset($_POST['cena']) && $row['click'] == 0 ? floatval($_POST['cena']) : $row['cena'];

                    $error = '';

                    if (empty($_POST['url'])) {
                        $error.= 'Введите URL!<br/>';
                    }
                    elseif (mb_strlen($_POST['url']) < 5 || mb_strlen($_POST['url']) > 250) {
                        $error.= 'URL должен содержать от 5 до 250 символов!<br/>';
                    }
                    elseif ($stmt_num->fetchColumn()) {
                        $error.= 'Площадка с данным URL уже есть в системе!<br/>';
                    }
                    elseif (!isSiteAvailable($_POST['url'])) {
                        $error.= 'URL недоступен или введен не правильно!<br/>';
                    }
                    if (empty($_POST['name'])) {
                        $error.= 'Введите название!<br/>';
                    }
                    elseif (mb_strlen($_POST['name']) < 5 || mb_strlen($_POST['name']) > 75) {
                        $error.= 'Название должно содержать от 5 до 75 символов!<br/>';
                    }
                    if (empty($cena)) {
                        $error.= 'Введите цену перехода!<br/>';
                    }
                    elseif ($cena < $sys['system']['cena']) {
                        $error.= 'Минимальная цена перехода - '.rub($sys['system']['cena']).'!<br/>';
                    } 
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        $status = ($adm_id == 1 || $sys['modules']['mod_s'] == 1) ? $row['status'] : 3;
                        $stmt = $connect->prepare("update `link` set `url` = ?, `name` = ?, `cena` = ?, `status` = ? where `id` = ?");
                        if ($stmt->execute(array($_POST['url'], $_POST['name'], $cena, $status, $_GET['edit']))) {
                            header('Location: /link');
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /link');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                URL-адрес [5-250]:<br/><input type="text" name="url" value="'.$row['url'].'"><br/>
                Название [5-75]:<br/><input type="text" name="name" value="'.$row['name'].'"><br/>
                '.($row['click'] == 0 ? 'Цена перехода:<br/><input type="text" name="cena" value="'.$row['cena'].'"><br/>' : '').'
                <input type="submit" name="yes" value="Сохранить ('.intval($_GET['edit']).')"/>
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
            }
        } else {
            header('Location: /link');
        }
    }
    elseif (isset($_GET['mode'])) {
        $num_u->execute(array($_GET['mode'], $user['id']));
        if ($num_u->fetchColumn()) {
            $strow->execute(array($_GET['mode']));
            $row = $strow->fetch();
            if ($row['status'] == 2 || $row['status'] == 3) {
                header('Location: /link');
            } else {
                if (isset($_POST['yes'])) {
                    $status = $row['status'] == 1 ? 0 : 1;
                    $stmt = $connect->prepare("update `link` set `status` = ? where `id` = ?");
                    if ($stmt->execute(array($status, $_GET['mode']))) {
                        header('Location: /link');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /link');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="'.($row['status'] == 1 ? 'Отключить' : 'Включить').' ('.intval($_GET['mode']).')">
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
            }
        } else {
            header('Location: /link');
        }
    }
    elseif (isset($_GET['del'])) {
        $num_u->execute(array($_GET['del'], $user['id']));
        if ($num_u->fetchColumn()) {
            $strow->execute(array($_GET['del']));
            $row = $strow->fetch();
            if ($row['status'] == 2) {
                header('Location: /link');
            } else {
                if (isset($_POST['yes'])) {
                    $del = $connect->prepare("delete from `link` where `id` = ?");
                    $fb = $connect->prepare("delete from `forbid_browser` where `link` = ?"); 
                    if (pay($row['click'] * $row['cena'], $user['id']) && $del->execute(array($_GET['del'])) && $fb->execute(array($_GET['del']))) {
                        header('Location: /link');
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /link');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="Удалить ('.intval($_GET['del']).')"/> 
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
           }
        } else {
            header('Location: /link');
        }
    }
    elseif (isset($_GET['bs'])) {
        $num_u->execute(array($_GET['bs'], $user['id']));
        if ($num_u->fetchColumn()) {
            $strow->execute(array($_GET['bs']));
            $row = $strow->fetch();
            if ($row['status'] == 2) {
                header('Location: /link');
            } else {
                if (isset($_POST['yes'])) {
                    $error = '';
                    if (empty($_POST['col'])) {
                        $error.= 'Введите количество переходов!<br/>';
                    }
                    elseif (!is_numeric($_POST['col'])) {
                        $error.= 'Неверное значение!<br/>';
                    }
                    elseif ($_POST['col'] < 10) {
                        $error.= 'Минимальное количество переходов - 10!<br/>';
                    }
                    elseif ($user['money'] < $_POST['col'] * $row['cena']) {
                        $error.= 'Недостаточно средств!<br/>';
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {

                        $col = intval($_POST['col']);
                        $sum = $col * $row['cena'];

                        $stmt = $connect->prepare("update `link` set `click` = `click` + ?, `memory` = ? where `id` = ?");

                        if (pay(-$sum, $user['id']) && $stmt->execute(array($col, $col, $_GET['bs']))) {
                            header('Location: /link');
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('Location: /link');
                }
                echo '<div class="menu">
                <form action="" method="POST">
                Количество переходов:<br/><input type="text" name="col" value="'.($row['memory'] > 0 ? $row['memory'] : '').'"><br/>
                <input type="submit" name="yes" value="Пополнить ('.intval($_GET['bs']).')"/> 
                <input type="submit" name="no" value="Отмена"/><br/>
                <div class="chi">Стоимость перехода: '.quantDec($row['cena'], ['рубль', 'рубля', 'рублей']).'</div>
                </form></div>';
            }
        } else {
            header('Location: /link');
        }
    }

    if ($links == 0) {
        echo '<div class="menu">Нет площадок!</div>';
    } else {

        $page = new Pagination($links, 10);

        $data = $connect->prepare("select * from `link` where `uid` = :uid order by `id` desc limit :start, 10");
        $data->bindValue(':uid', $user['id'], PDO::PARAM_INT);
        $data->bindValue(':start', $page->start, PDO::PARAM_INT);
        $data->execute();
        $sql = $data->fetchAll();

        foreach ($sql as $row) {

            $stmt_fb->execute(array($row['id']));
            $count_forbid = $stmt_fb->fetchColumn();

            $stmt_cl->execute(array($row['id']));
            $count_click = $stmt_cl->fetchColumn();

            echo '<div class="menu">
            ID: '.$row['id'].'<br/>
            URL: '.bblinks($row['url']).'<br/>
            Название: '.$row['name'].'<br/>
            Баланс: '.$row['click'].'<br/>
            Статус: '.($row['status'] == 1 ? 'Включена' : 'Отключена').'<br/>
            Сегодня переходов: '.$count_click.'<br/>
            <div class="chi">Стоимость перехода: '.quantDec($row['cena'], ['рубль', 'рубля', 'рублей']).'</div>
            '.($row['status'] == 2 ? '<div class="danger">Ваша площадка заблокирована!</div>' : ($row['status'] == 3 ? '<div class="information">На модерации!</div>' : '')).'
            <div class="butt2">
            <a href="?mode='.$row['id'].'">'.($row['status'] == 1 ? 'Отключить' : 'Включить').'</a>
            <a href="?bs='.$row['id'].'">Пополнить баланс</a>
            <a href="?del='.$row['id'].'">Удалить</a>
            <a href="?edit='.$row['id'].'">Редактировать</a><br/>
            <a href="/link/stats/'.$row['id'].'">Статистика площадки</a>
            <a href="/link/browser/'.$row['id'].'">Запрещенные браузеры ('.$count_forbid.')</a>
            </div> 
            </div>';

        }

        $page->navigation();

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>