<?php
$title = 'Пополнение баланса';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {

    echo '<div class="title">Пополнение баланса</div>';

    if ((!$sys['payment']['wmr'] || !$sys['payment']['hash']) &&
        (!$sys['payment']['wk_id'] || !$sys['payment']['wk_hash']) &&
        (!$sys['payment']['wpk_id'] || !$sys['payment']['wpk_hash'])) {

        echo '<div class="menu"><div class="danger">Способы оплаты не настроены!</div></div>';

    } else {

        if (isset($_POST['submit'])) {

            $error = '';

            if (empty($_POST['sum'])) {
                $error.= 'Введите сумму пополнения!<br/>';
            }
            elseif (!is_numeric($_POST['sum'])) {
                $error.= 'Неверное значение!<br/>';
            } 
            elseif ($_POST['sum'] < $sys['system']['min']) {
                $error.= 'Минимальна сумма пополнения - '.rub($sys['system']['min']).'!<br/>';
            }
            if (empty($_POST['pay'])) {
                $error.= 'Выберите способ оплаты!<br/>';
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $sum = intval($_POST['sum']);
                $chet = random_int(11111, 99999);
                $comment = 'Пополнение баланса: '.$user['login'];
                $pay = $connect->prepare("insert into `plus` set `time` = ?, `uid` = ?, `sum` = ?, `num` = ?");

                switch ($_POST['pay']) {

                    case 1:

                        if (!$sys['payment']['wmr'] || !$sys['payment']['hash']) {
                            echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                        } else {

                            if ($pay->execute(array(time(), $user['id'], $sum, $chet))) {

                                echo '<div class="menu">
                                <form data-noajax action="https://merchant.webmoney.ru/lmi/payment.asp" method="POST">
                                <input type="hidden" name="LMI_PAYMENT_AMOUNT" value="'.$sum.'">
                                <input type="hidden" name="LMI_PAYMENT_DESC_BASE64" value="'.base64_encode($comment).'">
                                <input type="hidden" name="LMI_PAYMENT_NO" value="'.$chet.'">
                                <input type="hidden" name="LMI_PAYEE_PURSE" value="'.$sys['payment']['wmr'].'">
                                <input type="hidden" name="LMI_SIM_MODE" value="0">
                                <input type="submit" value="Перейти к оплате ('.rub($sum).')">
                                </form></div>';

                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }

                        break;

                    case 2:

                        if (!$sys['payment']['wk_id'] || !$sys['payment']['wk_hash']) {
                            echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                        } else {

                            $data = file_get_contents('http://worldkassa.ru/user/oplata.php?id_shop='.$sys['payment']['wk_id'].'&summa='.$sum.'&hash='.$sys['payment']['wk_hash'].'&desc='.urlencode($comment));

                            if ($pay->execute(array(time(), $user['id'], $sum, $data)) && is_numeric($data)) {
                                header('Location: http://worldkassa.ru/user/oplata.php?uniq='.$data);
                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }

                        break;

                    case 3:

                        if (!$sys['payment']['wpk_id'] || !$sys['payment']['wpk_hash']) {
                            echo '<div class="menu"><div class="danger">Данный способ оплаты отключен!</div></div>';
                        } else {

                            if ($pay->execute(array(time(), $user['id'], $sum, $chet))) {

                                echo '<form data-noajax method="POST" action="https://wapkassa.ru/merchant/payment">
                                <div class="menu">
                                <input type="hidden" name="WK_PAYMENT_SITE" value="'.$sys['payment']['wpk_id'].'">
                                <input type="hidden" name="WK_PAYMENT_AMOUNT" value="'.$sum.'">
                                <input type="hidden" name="WK_PAYMENT_COMM" value="'.$comment.'">
                                <input type="hidden" name="WK_PAYMENT_HASH" value="'.strtoupper(hash('sha256', $sys['payment']['wpk_id'].$sum.$sys['payment']['wpk_hash'])).'">
                                <input type="hidden" name="WK_PAYMENT_ID" value="'.$chet.'">
                                <input type="submit" value="Перейти к оплате ('.rub($sum).')">
                                </div></form>';

                            } else {
                                echo '<div class="menu">Произошла ошибка!</div>';
                            }
                        }

                        break;

                    default:

                        echo '<div class="menu"><div class="forbidden">Неверный способ оплаты!</div></div>';

                }
            }
        }

        echo '<div class="menu">
        <form data-noajax action="" method="POST">
        Сумма пополнения:<br/><input type="text" name="sum" value="'.$sys['system']['min'].'"><br/>
        Способ оплаты:<br/><select name="pay">
        '.($sys['payment']['wmr'] && $sys['payment']['hash'] ? '<option value="1">WebMoney Merchant</option>' : '').
        ($sys['payment']['wk_id'] && $sys['payment']['wk_hash'] ? '<option value="2">WorldKassa</option>' : '').
        ($sys['payment']['wpk_id'] && $sys['payment']['wpk_hash'] ? '<option value="3">WapKassa</option>' : '').'
        </select><br/>
        <input type="submit" name="submit" value="Продолжить">
        </form></div>
        <div class="forlink"><a href="/info/plus/my" class="links"><img src="/img/history.png" alt="history">История пополнений<div class="chi">'.$c_user_plus.'</div></a></div>';

    }

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>