<?php
$title = 'Регистрация';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {
    header('Location: /');
} else {

    echo '<div class="title">Регистрация</div>';

    if ($sys['modules']['registration'] == 1) {

        $ref = $_SESSION['ref'] ?? false;

        if (isset($_POST['reg'])) {

            $error = '';

            if (empty($_POST['code'])) {
                $error.= 'Введите код с картинки!<br/>';
            }
            elseif ($_SESSION['code'] != $_POST['code']) {
                $error.= 'Код с картинки введен неверно!<br/>';
            } else {

                // Поиск e-mail в базе
                $email_s->execute(array($_POST['email']));

                if (empty($_POST['login'])) {
                    $error.= 'Введите логин!<br/>';
                }
                elseif (mb_strlen($_POST['login']) < 3 || mb_strlen($_POST['login']) > 25) {
                    $error.= 'Логин должен содержать от 3 до 25 символов!<br/>';
                }
                elseif (!preg_match("#^[a-z0-9_-]{1,25}$#i", $_POST['login'])) {
                    $error.= 'Логин должен состоять из латинских букв и/или цифр!<br/>';
                }
                elseif (user($_POST['login'], 1)) {
                    $error.= 'Пользователь с таким логином уже зарегистрирован!<br/>';
                }
                if (empty($_POST['pass'])) {
                    $error.= 'Введите пароль!<br/>';
                }
                elseif (mb_strlen($_POST['pass']) < 6 || mb_strlen($_POST['pass']) > 20) {
                    $error.= 'Пароль должен содержать от 6 до 20 символов!<br/>';
                }
                elseif (empty($_POST['last_pass'])) {
                    $error.= 'Введите проверочный пароль!<br/>';
                }
                elseif ($_POST['last_pass'] != $_POST['pass']) {
                    $error.= 'Проверочный пароль введен неверно!<br/>';
                } 
                if (empty($_POST['email'])) {
                    $error.= 'Поле e-mail обязательно для заполнения!<br/>';
                }
                elseif (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
                    $error.= 'Поле e-mail заполнено неверно!<br/>';
                }
                elseif ($email_s->fetchColumn()) {
                    $error.= 'Пользователь с таким e-mail уже зарегистрирован!<br/>';
                }
                if (!empty($_POST['name']) && mb_strlen($_POST['name']) > 75) {
                    $error.= 'Имя должно содержать не более 75 символов!<br/>';
                }
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $status = $sys['modules']['email_verify'] == 1 ? 0 : 1;

                $password = password_hash($_POST['pass'], PASSWORD_DEFAULT);

                $stmt = $connect->prepare("insert into `users` set `datereg` = ?, `active` = ?, `login` = ?, `pass` = ?, `email` = ?, `name` = ?, `pol` = ?, `ref` = ?");

                if ($stmt->execute(array(time(), $status, $_POST['login'], $password, $_POST['email'], $_POST['name'], $_POST['pol'], $ref))) {

                    // завершение регистрации
                    $user_id = $connect->LastInsertId();

                    if ($user_id == 1) {
                        $connect->exec("update `users` set `admin` = '1' where `id` = '1'");
                    } else {
                        mailto(
                            $_POST['email'],
                            'Регистрация в проекте '.$sys['system']['project'],
                            'Спасибо за регистрацию на нашем сайте!<br/>
                             Ваши данные для входа в личный кабинет:<br/>
                             Логин '.$_POST['login'].'<br/>
                             Сайт: '.ROOT,
                            $sys['system']['mail']
                        );
                    }

                    $auth = bin2hex(random_bytes($sys['system']['authkey'])); // ключ авторизации

                    $authlog->execute(array(time(), $user_id, $ip, $ua, md5(md5($auth)), 0));

                    $expire = time() + 3600 * 24 * 365;

                    // авторизация
                    setcookie('user_id', $user_id);
                    setcookie('user_id', $user_id, $expire, '/');
                    setcookie('pass', $password);
                    setcookie('pass', $password, $expire, '/');
                    setcookie('auth', $auth);
                    setcookie('auth', $auth, $expire, '/');

                    header('Location: /');

                } else {
                    echo '<div class="menu">Ошибка при регистрации!</div>';
                }
            }
        }

        echo '<div class="menu">
        <form name="registration" action="" method="POST">
        Логин:<br/><input type="text" name="login"><br/>
        Пароль:<br/><input type="password" name="pass"><br/>
        Повторите пароль:<br/><input type="password" name="last_pass"><br/>
        E-mail:<br/><input type="email" name="email"><br/>
        Имя:<br/><input type="text" name="name"><br/>
        Пол:<br/><select name="pol"><option value="1">Мужской</option><option value="2">Женский</option></select><br/>
        Код с картинки:<img id="captcha" src="/img/code.php" alt="check" onClick="UpCaptcha()"><br/>
        <input type="text" name="code"><br/>
        <input type="submit" name="reg" value="Зарегистрироваться">
        '.(user($ref) ? '<hr/>Вас пригласил: '.profileLink($ref) : '').'
        </form></div>';

    } else {

        echo '<div class="menu"><div class="danger">Регистрация закрыта!</div></div>';

    }

}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>