<?php
$title = 'Смена пароля';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {

    echo '<div class="title">Смена пароля</div>';

    if (isset($_POST['submit'])) {

        $error = '';

        if (empty($_POST['pass'])) {
            $error.= 'Введите действующий пароль!<br/>';
        }
        elseif (!password_verify($_POST['pass'], $user['pass'])) {
            $error.= 'Действующий пароль введен неверно!<br/>';
        }
        elseif (empty($_POST['new_pass'])) {
            $error.= 'Введите новый пароль!<br/>';
        }
        elseif (mb_strlen($_POST['new_pass']) < 3 or mb_strlen($_POST['new_pass']) > 15) {
            $error.= 'Новый пароль должен содержать от 3 до 15 символов!<br/>';
        }
        elseif (empty($_POST['last_pass'])) {
            $error.= 'Введите проверочный пароль!<br/>';
        }
        elseif ($_POST['last_pass'] != $_POST['new_pass']) {
            $error.= 'Проверочный пароль введен неверно!<br/>';
        }
        elseif (password_verify($_POST['new_pass'], $user['pass'])) {
            $error.= 'У вас уже задействован этот пароль!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $password = password_hash($_POST['new_pass'], PASSWORD_DEFAULT);

            $stmt = $connect->prepare("update `users` set `pass` = ? where `id` = ?");

            if ($stmt->execute(array($password, $user['id']))) {

                $expire = time() + 3600 * 24 * 365;

                setcookie('pass', $password);
                setcookie('pass', $password, $expire, '/');

                echo '<div class="menu">Пароль успешно изменен!</div>';

                header('Refresh: 1');

            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }

    echo '<div class="menu">
    <form action="" method="POST">
    Действующий пароль:<br /><input type="password" name="pass" maxlength="15"/><br/>
    Новый пароль:<br/><input type="password" name="new_pass" maxlength="15"/><br/>
    Повторите новый пароль:<br/><input type="password" name="last_pass" maxlength="15"/><br/>
    <input type="submit" name="submit" value="Изменить">
    </form></div>';

    echo '<div class="forlink"><a href="/settings" class="links"><img src="/img/sett.png" alt="sett">Настройки</a></div>';

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>