<?php
$title = 'Настройки профиля';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active)) {

    echo '<div class="title">Аватар</div>';

    $avatar = GlobFiles::findById($user['id'], GlobFiles::UserAvatar);

    if ($avatar) {
        if (isset($_GET['del'])) {
            if (isset($_POST['cancel'])) {
                header('location: /settings/profile');
            }
            elseif (isset($_POST['submit'])) {
                unlink($avatar);
                header('location: /settings/profile'); 
            } else {
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="submit" value="Удалить аватар">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';
            }
        }

        echo '<div class="menu">Ваш аватар: '.basename($avatar).' ('.get_filesize($avatar).')<a href="?del"><img src="/img/del.png" alt="del"></a><hr/>
        <img src="/preview/'.$sys['system']['wava'].'/'.base64_encode('/files/avatar/'.basename($avatar)).'" alt="preview" class="rounded" data-toggle="modal" data-target="#avatar">
         <div id="avatar" class="modal fade" tabindex="-1">
          <div class="modal-dialog">
            <img src="/files/avatar/'.basename($avatar).'" alt="avatar" class="img-thumbnail" data-dismiss="modal">
          </div>
        </div>
        </div>';

    }

    if (isset($_POST['avatar'])) {
        $error = '';
        if (!file_exists($_FILES['filename']['tmp_name'])) {
            $error.= 'Вы не выбрали файл!<br/>';
        }
        elseif (!BeforeUpload::AttachPicture($_FILES['filename'])) {
            $error.= 'Неверный тип файла!<br/>';
        }
        if ($_FILES['filename']['size'] > 1048576) {
            $error.= 'Максимальный размер файла - 1024 Kb!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {

            $files = $user['id']."_".random_int(11111, 99999)."_".$_FILES['filename']['name'];

            if (move_uploaded_file($_FILES['filename']['tmp_name'], $_SERVER["DOCUMENT_ROOT"]."/files/avatar/".$files)) {

                if ($avatar)
                    unlink($avatar);

                header('location: /settings/profile');

            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }

        }

    }

    echo '<div class="menu">
    <form name="form" action="" method="POST" enctype="multipart/form-data">
    Прикрепить файл:<br/><input type="file" name="filename"><br/>
    <input type="submit" name="avatar" value="Загрузить">
    </form></div>';

    echo '<div class="title">Профиль</div>';

    if (isset($_POST['profile'])) {
        $error = '';
        if (!empty($_POST['status']) && mb_strlen($_POST['status']) > 250) {
            $error.= 'Статус должен содержать не более 250 символов!<br/>';
        }
        if (!empty($_POST['name']) && mb_strlen($_POST['name']) > 75) {
            $error.= 'Имя должно содержать не более 75 символов!<br/>';
        }
        if (!empty($_POST['info']) && mb_strlen($_POST['info']) > 250) {
            $error.= 'Краткая информация о себе должна содержать не более 250 символов!<br/>';
        }
        if (!empty($_POST['birth']) && !validateDate($_POST['birth'], 'Y-m-d')) {
            $error.= 'Некорректный формат даты!<br/>';
        }
        if (!empty($_POST['timezone']) && !isAvailableTimezone($_POST['timezone'])) {
            $error.= 'Некорректный часовой пояс!<br/>';
        }
        if ($error) {
            echo '<div class="menu">'.$error.'</div>';
        } else {
            $hd = isset($_POST['hd']) ? 1 : 0;
            $stmt = $connect->prepare("update `users` set `status` = ?, `name` = ?, `pol` = ?, `info` = ?, `birth` = ?, `hd` = ?, `fmail` = ?, `timezone` = ? where `id` = ?");
            if ($stmt->execute(array($_POST['status'], $_POST['name'], $_POST['pol'], $_POST['info'], $_POST['birth'], $hd, $_POST['fmail'], $_POST['timezone'], $user['id']))) {
                header('location: /settings/profile'); 
            } else {
                echo '<div class="menu">Произошла ошибка!</div>';
            }
        }
    }
    echo '<div class="menu">
    <form action="" method="POST">
    Статус:<br/><textarea name="status">'.$user['status'].'</textarea><hr/>
    Имя:<br/><input type="text" name="name" value="'.$user['name'].'"><br/>
    Пол:<br/><select name="pol"><option value="1">Мужской</option><option '.($user['pol'] == 2 ? 'selected' : '').' value="2">Женский</option></select><br/>
    О себе:<br/><textarea name="info">'.$user['info'].'</textarea><br/>
    Дата рождения: <small>ГГГГ-ММ-ДД</small><br/><input type="date" name="birth" max="'.date('Y-m-d', mktime(0, 0, 0, date('d'), date('m'), date('Y') - 14)).'" value="'.$user['birth'].'">
    <input type="checkbox" '.($user['hd'] == 1 ? 'checked' : '').' name="hd" value="1">Скрыть год рождения<br/>
    Отправлять сообщения могут:<br/><select name="fmail"><option value="1">Все</option><option '.($user['fmail'] == 2 ? 'selected' : '').' value="2">Только друзья</option></select><br/>
    Часовой пояс:<br/>
    <select name="timezone">';

    $date = new DateTime;

    foreach (TIMEZONES as $gmt => $value) {

        $dtz = new DateTimeZone($value);

        $date->setTimezone($dtz);

        echo '<option '.($timezone == $value ? 'selected' : '').' value="'.$value.'">'.$gmt.' ('.$value.' | '.$date->format('d.m H:i').')</option>';

    }

    echo '</select><br/>
    <input type="submit" name="profile" value="Сохранить">
    </form></div>';

    echo '<div class="forlink"><a href="/settings" class="links"><img src="/img/sett.png" alt="sett">Настройки</a></div>'; 

} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>