<?php
$title = 'Скидки';
require_once($_SERVER["DOCUMENT_ROOT"]."/inc/head.php");
if (isset($active) && $sys['modules']['shop'] == 1) {

    $stmt_row = $connect->prepare("select * from `shop` where `id` = ? and `seller` = ?");
    $stmt_row->execute(array($id, $user['id']));
    $row_s = $stmt_row->fetch();

    if ($row_s && $row_s['uid'] == 0 && $row_s['free'] == 0) {

        $num_u = $connect->prepare("select count(*) from `discounts` where `pid` = ? and `id` = ?");
        $strow = $connect->prepare("select * from `discounts` where `id` = ?");
        $num_f = $connect->prepare("select count(*) from `discounts` where `pid` = ? and `uid` = ?");


        // количество скидок
        $stmt_dis = $connect->prepare("select count(*) from `discounts` where `pid` = ?");
        $stmt_dis->execute(array($id));
        $count_dis = $stmt_dis->fetchColumn();

        echo '<div class="title">Скидки на товар: '.$row_s['name'].' ('.$count_dis.')</div>';

        if (isset($_GET['edit'])) {
            $num_u->execute(array($id, $_GET['edit']));
            if ($num_u->fetchColumn()) {
                $strow->execute(array($_GET['edit']));
                $row = $strow->fetch();
                if (isset($_POST['cancel'])) {
                    header('location: /shop/discounts/'.$id);
                }
                elseif (isset($_POST['red'])) {

                    $sum = floatval(abs($_POST['sum']));

                    $error = '';

                    if (empty($sum)) {
                        $error.= 'Введите сумму скидки!<br/>';
                    }
                    elseif ($sum >= $row_s['cena']) {
                        $error.= 'Сумма скидки не должна превышать стоимость товара!<br/>';
                    }
                    if ($error) {
                        echo '<div class="menu">'.$error.'</div>';
                    } else {
                        $stmt = $connect->prepare("update `discounts` set `sum` = ? where `id` = ?");
                        if ($stmt->execute(array($sum, $_GET['edit']))) {
                            header('location: /shop/discounts/'.$id);
                        } else {
                            echo '<div class="menu">Произошла ошибка!</div>';
                        }
                    }
                }
                echo '<div class="menu">
                <form action="" method="POST">
                Пользователь: '.profileLink($row['uid']).'<br/>
                Сумма скидки:<br/><input type="text" name="sum" value="'.$row['sum'].'"><br/>
                <input type="submit" name="red" value="Сохранить ('.intval($_GET['edit']).')">
                <input type="submit" name="cancel" value="Отмена">
                </form></div>';
            } else {
                header('location: /shop/discounts/'.$id);
            }
        }
        elseif (isset($_GET['del'])) {
            $num_u->execute(array($id, $_GET['del']));
            if ($num_u->fetchColumn()) {
                if (isset($_POST['yes'])) {
                    $stmt = $connect->prepare("delete from `discounts` where `id` = ?");
                    if ($stmt->execute(array($_GET['del']))) {
                        header('location: /shop/discounts/'.$id);
                    } else {
                        echo '<div class="menu">Произошла ошибка!</div>';
                    }
                }
                elseif (isset($_POST['no'])) {
                    header('location: /shop/discounts/'.$id);
                }
                echo '<div class="menu">
                <form action="" method="POST">
                <input type="submit" name="yes" value="Удалить ('.intval($_GET['del']).')"/> 
                <input type="submit" name="no" value="Отмена"/>
                </form></div>';
            } else {
                header('location: /shop/discounts/'.$id);
            }
        }

        if ($count_dis == 0) {
            echo '<div class="menu">Скидок на этот товар нет.</div>';
        } else {

            $page = new Pagination($count_dis, 10);

            $data = $connect->prepare("select * from `discounts` where `pid` = :product order by `id` desc limit :start, 10");
            $data->bindValue(':product', $id, PDO::PARAM_INT);
            $data->bindValue(':start', $page->start, PDO::PARAM_INT);
            $data->execute();
            $sql = $data->fetchAll();

            foreach ($sql as $row) {

                echo '<div class="menu">
                Пользователь: '.profileLink($row['uid']).'<br/>
                Скидка: '.rub($row['sum']).
                ($row['sum'] >= $row_s['cena'] ? '<div class="danger">Некорректное значение!</div>' : '').'
                <div class="butt2">
                <a href="?edit='.$row['id'].'">Редактировать</a>
                <a href="?del='.$row['id'].'">Удалить</a>
                </div>
                </div>';

            }

            $page->navigation();

        }

        echo '<div class="title">Выдать скидку</div>';

        if (isset($_POST['submit'])) {

            $row_u = user($_POST['user'], 1);

            $sum = floatval(abs($_POST['sum']));

            $error = '';

            if (empty($_POST['user'])) {
                $error.= 'Введите логин пользователя!<br/>';
            } 
            elseif (!$row_u) {
                $error.= 'Пользователь с таким логином не найден в системе!<br/>';
            }
            elseif ($_POST['user'] == $user['login']) {
                $error.= 'Нельзя выдавать скидки самому себе!<br/>';
            } else {

                $num_f->execute(array($id, $row_u['id']));

                if ($num_f->fetchColumn()) {
                    $error.= 'Скидка для этого пользователя уже есть!<br/>';
                }
                if (empty($sum)) {
                    $error.= 'Введите сумму скидки!<br/>';
                }
                elseif ($sum >= $row_s['cena']) {
                    $error.= 'Сумма скидки не должна превышать стоимость товара!<br/>';
                }
            }
            if ($error) {
                echo '<div class="menu">'.$error.'</div>';
            } else {

                $stmt = $connect->prepare("insert into `discounts` set `uid` = ?, `sum` = ?, `pid` = ?");

                if ($stmt->execute(array($row_u['id'], $sum, $id))) {

                    notification('Вам выдана скидка на покупку товара [url='.ROOT.'/shop/product/'.$id.']'.$row_s['name'].'[/url]', $row_u['id']);

                    header('Location: /shop/discounts/'.$id);

                } else {
                    echo '<div class="menu">Произошла ошибка!</div>';
                }
            }
        }

        echo '<div class="menu">
        <form action="" method="POST">
        Пользователь:<br/><input type="text" name="user" maxlength="15"><br/>
        Сумма скидки:<br/><input type="text" name="sum"><br/>
        <input type="submit" name="submit" value="Продолжить">
        </form></div>';

        echo '<div class="forlink"><a href="/shop/product/'.$id.'" class="links"><img src="/img/product.png" alt="">Вернуться к товару</a></div>';

    } else {
        header('Location: /');
    }
} else {
    header('Location: /');
}

require($_SERVER["DOCUMENT_ROOT"]."/inc/foot.php");
?>